/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.BidirectionalColorGradient;
import facs.CanvasSettings;
import facs.ColorGradient;
import facs.PlotUtilities;
import facs.PopulationL;
import facs.UnidirectionalColorGradient;
import facs.scale.Scale;
import facs.scale.ScaleArgument;
import facs.scale.Scaling;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class Plot2D {
    public static final int LINEAR_DISPLAY = 0;
    public static final int LOG_DISPLAY = 1;
    public static final int ARCSINH_DISPLAY_FLUOR = 2;
    public static final int ARCSINH_DISPLAY_CYTOF = 3;
    private static final int[] edgeTable2D = new int[]{0, 9, 3, 10, 6, 15, 5, 12, 12, 5, 15, 6, 10, 3, 9, 0};
    private static final int[][] lineTable = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1}, {3, 0, -1, -1, -1, -1, -1, -1}, {0, 1, -1, -1, -1, -1, -1, -1}, {3, 1, -1, -1, -1, -1, -1, -1}, {2, 1, -1, -1, -1, -1, -1, -1}, {3, 0, 2, 1, -1, -1, -1, -1}, {2, 0, -1, -1, -1, -1, -1, -1}, {3, 2, -1, -1, -1, -1, -1, -1}, {3, 2, -1, -1, -1, -1, -1, -1}, {2, 0, -1, -1, -1, -1, -1, -1}, {3, 2, 0, 1, -1, -1, -1, -1}, {2, 1, -1, -1, -1, -1, -1, -1}, {3, 1, -1, -1, -1, -1, -1, -1}, {0, 1, -1, -1, -1, -1, -1, -1}, {3, 0, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}};

    private Plot2D() {
    }

    public static BufferedImage drawPlot(CanvasSettings cs, double[] xChanEvents, double[] yChanEvents, double[] xChanAllEvents, double[] yChanAllEvents, String xChanLabel, String yChanLabel, double xChanMaximum, double yChanMaximum, int xDisplay, int yDisplay) throws IOException {
        if (cs == null || !cs.is2DPlot()) {
            return null;
        }
        int width = cs.getCanvasWidth();
        int height = cs.getCanvasHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(cs.getBackgroundColor());
        g.fillRect(0, 0, width, height);
        g.translate(cs.getStartX(), cs.getStartY());
        g.setColor(cs.getPlotBackgroundColor());
        g.fillRect(0, 0, cs.getPlotWidth(), cs.getPlotHeight());
        g.translate(-cs.getStartX(), -cs.getStartY());
        if (xChanEvents.length > 0) {
            double[][] sortedDensityValues;
            double[][] densityValues;
            int type;
            Scale xScale = null;
            Scale yScale = null;
            ScaleArgument xScaleArgument = null;
            ScaleArgument yScaleArgument = null;
            double xMin = 0.0;
            double xMax = 1.0;
            double yMin = 0.0;
            double yMax = 1.0;
            int eventCount = xChanEvents.length;
            String scaleArg = null;
            if (xDisplay == 0) {
                type = 1;
                xMin = 1.0;
                xMax = xChanMaximum;
            } else if (xDisplay == 1) {
                type = 2;
                xMin = 1.0;
                xMax = xChanMaximum;
            } else if (xDisplay == 2) {
                type = 4;
                scaleArg = "150";
                xMin = -200.0;
                xMax = 260000.0;
            } else if (xDisplay == 3) {
                type = 4;
                scaleArg = "5";
                xMin = -20.0;
                xMax = 10000.0;
            } else {
                return null;
            }
            xScale = Scaling.getScale(type);
            xScaleArgument = Scaling.getScaleArgument(type, scaleArg);
            if (yDisplay == 0) {
                type = 1;
                yMin = 1.0;
                yMax = yChanMaximum;
            } else if (yDisplay == 1) {
                type = 2;
                yMin = 1.0;
                yMax = yChanMaximum;
            } else if (yDisplay == 2) {
                type = 4;
                scaleArg = "150";
                yMin = -200.0;
                yMax = 260000.0;
            } else if (yDisplay == 3) {
                type = 4;
                scaleArg = "5";
                yMin = -20.0;
                yMax = 10000.0;
            } else {
                return null;
            }
            yScale = Scaling.getScale(type);
            yScaleArgument = Scaling.getScaleArgument(type, scaleArg);
            if (Double.isNaN(xMin)) {
                xMin = 0.0;
            }
            if (Double.isNaN(xMax)) {
                xMax = xChanMaximum;
            }
            if (Double.isNaN(yMin)) {
                yMin = 0.0;
            }
            if (Double.isNaN(yMax)) {
                yMax = yChanMaximum;
            }
            int plotType = cs.getPlotType();
            int[][] bins = null;
            bins = PopulationL.getBinValues(xScale, yScale, xScaleArgument, yScaleArgument, cs.getNumXBins(), cs.getNumYBins(), xMin, xMax, yMin, yMax, xChanEvents, yChanEvents);
            g.translate(cs.getStartX(), cs.getStartY());
            if (xChanAllEvents != null) {
                int[][] bkgbins = PopulationL.getBinValues(xScale, yScale, xScaleArgument, yScaleArgument, cs.getNumXBins(), cs.getNumYBins(), xMin, xMax, yMin, yMax, xChanAllEvents, yChanAllEvents);
                double[][] bkgDensityValues = PopulationL.getTriweightKernelDensityValues(bkgbins, cs.getSmoothing() * 2.5);
                double[][] bkgSortedDensityValues = PopulationL.sortDensityValues(bkgDensityValues);
                Plot2D.drawBkgContours(bkgbins, xChanAllEvents.length, bkgDensityValues, bkgSortedDensityValues, g, cs);
            }
            if (plotType == 11) {
                Plot2D.drawDots(bins, g, cs.getOutlierColor(), cs.getPlotHeight());
            } else if (plotType == 12) {
                double[][] sortedBinValues = PopulationL.sortBinValues(bins);
                Plot2D.drawDensityDots(bins, eventCount, sortedBinValues, g, cs);
            } else if (plotType == 13) {
                densityValues = PopulationL.getTriweightKernelDensityValues(bins, cs.getSmoothing() * 2.5);
                sortedDensityValues = PopulationL.sortDensityValues(densityValues);
                Plot2D.drawDensityDots(bins, eventCount, sortedDensityValues, g, cs);
            } else if (plotType == 16) {
                densityValues = PopulationL.getTriweightKernelDensityValues(bins, cs.getSmoothing() * 0.5);
                sortedDensityValues = PopulationL.sortDensityValues(densityValues);
                Plot2D.drawDensityDots(bins, eventCount, sortedDensityValues, g, cs);
            } else {
                densityValues = PopulationL.getTriweightKernelDensityValues(bins, cs.getSmoothing() * 2.5);
                sortedDensityValues = PopulationL.sortDensityValues(densityValues);
                Plot2D.drawContours(bins, eventCount, densityValues, sortedDensityValues, g, cs, plotType == 15);
            }
            PlotUtilities.drawXAxis(g, xChanLabel, xScale, xScaleArgument, xMin, xMax, cs);
            PlotUtilities.drawYAxis(g, yChanLabel, yScale, yScaleArgument, yMin, yMax, cs);
            g.translate(-cs.getStartX(), -cs.getStartY());
        }
        if (cs.drawAnnotation()) {
            g.translate(cs.getStartX(), cs.getStartY());
            g.setColor(cs.getLineColor());
            g.drawRect(-2, -2, cs.getPlotWidth() + 2 + 2 - 1, cs.getPlotHeight() + 2 + 2 - 1);
            g.translate(-cs.getStartX(), -cs.getStartY());
        }
        g.dispose();
        return image;
    }

    private static void drawDots(int[][] bins, Graphics g, Color color, int plotHeight) {
        if (bins == null || bins.length <= 0 || g == null) {
            return;
        }
        int height = plotHeight - 1;
        g.setColor(color);
        for (int i = 0; i < bins.length; ++i) {
            for (int j = 0; j < bins[i].length; ++j) {
                if (bins[i][j] <= 0) continue;
                g.fillRect(i, height - j, 1, 1);
            }
        }
    }

    private static void drawDensityDots(int[][] binValues, int numEvents, double[][] sortedDensityValues, Graphics g, CanvasSettings cs) {
        if (binValues == null || binValues.length <= 0) {
            return;
        }
        if (sortedDensityValues == null || sortedDensityValues.length <= 0) {
            return;
        }
        int numLevels = (int)((100.0 - cs.getContourStartPercent()) / cs.getContourPercent()) + 1;
        int indexIncrement = (int)(cs.getContourPercent() / 100.0 * (double)(numEvents - 1));
        int index = (int)(cs.getContourStartPercent() / 100.0 * (double)(numEvents - 1));
        int startK = 0;
        int height = cs.getPlotHeight() - 1;
        UnidirectionalColorGradient colorgrad = new UnidirectionalColorGradient(0.0, numLevels - 1, cs.getColorSet());
        for (int i = 0; i < numLevels; ++i) {
            for (int k = startK; k < sortedDensityValues.length; ++k) {
                if ((index -= binValues[(int)sortedDensityValues[k][1]][(int)sortedDensityValues[k][2]]) > 0) continue;
                Plot2D.drawColoredDots(binValues, sortedDensityValues, k, g, height, colorgrad.getColor(i));
                if (i == 0) {
                    g.setColor(cs.getOutlierColor());
                    Plot2D.drawOutliers(binValues, sortedDensityValues, k, g, height, cs.getDotSize());
                }
                startK = k + 1;
                break;
            }
            index += indexIncrement;
        }
    }

    private static void drawColoredDots(int[][] binValues, double[][] sortedDensityValues, int firstIndex, Graphics g, int height, Color color) {
        if (binValues == null || binValues.length <= 0) {
            return;
        }
        if (sortedDensityValues == null || sortedDensityValues.length <= 0) {
            return;
        }
        g.setColor(color);
        for (int i = firstIndex; i < sortedDensityValues.length; ++i) {
            if (binValues[(int)sortedDensityValues[i][1]][(int)sortedDensityValues[i][2]] == 0) continue;
            g.fillRect((int)sortedDensityValues[i][1], (int)((double)height - sortedDensityValues[i][2]), 1, 1);
        }
    }

    private static void drawOutliers(int[][] binValues, double[][] sortedDensityValues, int lastIndex, Graphics g, int height, int lw) {
        if (binValues == null || binValues.length <= 0) {
            return;
        }
        if (sortedDensityValues == null || sortedDensityValues.length <= 0) {
            return;
        }
        for (int i = 0; i < lastIndex; ++i) {
            if (binValues[(int)sortedDensityValues[i][1]][(int)sortedDensityValues[i][2]] == 0) continue;
            g.fillOval((int)sortedDensityValues[i][1], (int)((double)height - sortedDensityValues[i][2]), lw, lw);
        }
    }

    private static void drawBkgContours(int[][] binValues, int numEvents, double[][] densityValues, double[][] sortedDensityValues, Graphics g, CanvasSettings cs) {
        if (binValues == null || binValues.length <= 0) {
            return;
        }
        if (densityValues == null || densityValues.length <= 0) {
            return;
        }
        if (sortedDensityValues == null || sortedDensityValues.length <= 0) {
            return;
        }
        int numLevels = (int)((100.0 - cs.getContourStartPercent()) / cs.getContourPercent()) + 1;
        int indexIncrement = (int)(cs.getContourPercent() / 100.0 * (double)(numEvents - 1));
        int index = (int)(cs.getContourStartPercent() / 100.0 * (double)(numEvents - 1));
        int startK = 0;
        int height = cs.getPlotHeight() - 1;
        g.setColor(Color.LIGHT_GRAY);
        for (int i = 0; i < numLevels; ++i) {
            for (int k = startK; k < sortedDensityValues.length; ++k) {
                if ((index -= binValues[(int)sortedDensityValues[k][1]][(int)sortedDensityValues[k][2]]) > 0) continue;
                Plot2D.drawColoredLevel(binValues, sortedDensityValues, k, g, height, cs.getContourColor());
                g.setColor(Color.LIGHT_GRAY);
                Plot2D.drawContourLevel(densityValues, sortedDensityValues[k][0], g, height);
                startK = k + 1;
                break;
            }
            index += indexIncrement;
        }
    }

    private static void drawContours(int[][] binValues, int numEvents, double[][] densityValues, double[][] sortedDensityValues, Graphics g, CanvasSettings cs, boolean shaded) {
        if (binValues == null || binValues.length <= 0) {
            return;
        }
        if (densityValues == null || densityValues.length <= 0) {
            return;
        }
        if (sortedDensityValues == null || sortedDensityValues.length <= 0) {
            return;
        }
        int numLevels = (int)((100.0 - cs.getContourStartPercent()) / cs.getContourPercent()) + 1;
        int indexIncrement = (int)(cs.getContourPercent() / 100.0 * (double)(numEvents - 1));
        int index = (int)(cs.getContourStartPercent() / 100.0 * (double)(numEvents - 1));
        int startK = 0;
        int height = cs.getPlotHeight() - 1;
        UnidirectionalColorGradient colorgrad = null;
        if (shaded) {
            colorgrad = new UnidirectionalColorGradient(0.0, numLevels - 1, cs.getColorSet());
        }
        g.setColor(cs.getOutlierColor());
        for (int i = 0; i < numLevels; ++i) {
            for (int k = startK; k < sortedDensityValues.length; ++k) {
                if ((index -= binValues[(int)sortedDensityValues[k][1]][(int)sortedDensityValues[k][2]]) > 0) continue;
                if (shaded) {
                    Plot2D.drawColoredLevel(binValues, sortedDensityValues, k, g, height, colorgrad.getColor(i));
                } else {
                    Plot2D.drawColoredLevel(binValues, sortedDensityValues, k, g, height, cs.getContourColor());
                    g.setColor(cs.getOutlierColor());
                }
                Plot2D.drawContourLevel(densityValues, sortedDensityValues[k][0], g, height);
                if (i == 0) {
                    Plot2D.drawOutliers(binValues, sortedDensityValues, k, g, height, cs.getDotSize());
                }
                startK = k + 1;
                break;
            }
            index += indexIncrement;
        }
    }

    private static void drawContourLevel(double[][] densityValues, double h, Graphics g, int height) {
        for (int i = 0; i < densityValues.length - 1; ++i) {
            for (int j = 0; j < densityValues[i].length - 1; ++j) {
                Plot2D.marchSquare(densityValues, i, j, h, g, height);
            }
        }
    }

    private static void marchSquare(double[][] densityValues, int i, int j, double h, Graphics g, int height) {
        int index = 0;
        if (densityValues[i][j] < h) {
            index |= 1;
        }
        if (densityValues[i + 1][j] < h) {
            index |= 2;
        }
        if (densityValues[i + 1][j + 1] < h) {
            index |= 4;
        }
        if (densityValues[i][j + 1] < h) {
            index |= 8;
        }
        if (index == 0) {
            return;
        }
        int edges = edgeTable2D[index];
        Point2D.Double[] lineIntersections = new Point2D.Double[4];
        if ((edges & 1) != 0) {
            lineIntersections[0] = Plot2D.linearInterpolate(h, densityValues[i][j], densityValues[i + 1][j], i, j, i + 1, j);
        }
        if ((edges & 2) != 0) {
            lineIntersections[1] = Plot2D.linearInterpolate(h, densityValues[i + 1][j], densityValues[i + 1][j + 1], i + 1, j, i + 1, j + 1);
        }
        if ((edges & 4) != 0) {
            lineIntersections[2] = Plot2D.linearInterpolate(h, densityValues[i + 1][j + 1], densityValues[i][j + 1], i + 1, j + 1, i, j + 1);
        }
        if ((edges & 8) != 0) {
            lineIntersections[3] = Plot2D.linearInterpolate(h, densityValues[i][j + 1], densityValues[i][j], i, j + 1, i, j);
        }
        int t = 0;
        while (lineTable[index][t] != -1) {
            g.drawLine((int)Math.round(lineIntersections[Plot2D.lineTable[index][t]].x), (int)Math.round((double)height - lineIntersections[Plot2D.lineTable[index][t]].y), (int)Math.round(lineIntersections[Plot2D.lineTable[index][t + 1]].x), (int)Math.round((double)height - lineIntersections[Plot2D.lineTable[index][t + 1]].y));
            t += 2;
        }
    }

    private static Point2D.Double linearInterpolate(double h, double fa, double fb, double ax, double ay, double bx, double by) {
        if (fa == fb) {
            return new Point2D.Double(ax, ay);
        }
        double s = (h - fa) / (fb - fa);
        return new Point2D.Double(ax + s * (bx - ax), ay + s * (by - ay));
    }

    private static void drawColoredLevel(int[][] binValues, double[][] sortedDensityValues, int firstIndex, Graphics g, int height, Color color) {
        g.setColor(color);
        for (int i = firstIndex; i < sortedDensityValues.length; ++i) {
            g.fillRect((int)sortedDensityValues[i][1], (int)((double)height - sortedDensityValues[i][2]), 1, 1);
        }
    }

    public static BufferedImage drawHeatmap(double[][] values, ColorGradient gradient) {
        int y;
        int x;
        int i;
        if (values == null || gradient == null || values.length <= 0 || values[0].length <= 0) {
            return null;
        }
        int rowCount = values.length;
        int columnCount = values[0].length;
        int size = 25;
        int width = columnCount * size;
        int height = rowCount * size;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        for (i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                x = j * size;
                y = i * size;
                if (Double.isNaN(values[i][j])) {
                    g.setColor(Color.red);
                    g.drawLine(x, y, x + size, y + size);
                    continue;
                }
                g.setColor(gradient.getColor(values[i][j]));
                g.fillRect(x, y, size, size);
            }
        }
        if (rowCount > 1 || columnCount > 1) {
            g.setColor(Color.black);
            for (i = 1; i < rowCount; ++i) {
                y = i * size;
                g.drawLine(0, y, width - 1, y);
            }
            for (i = 1; i < columnCount; ++i) {
                x = i * size;
                g.drawLine(x, 0, x, height - 1);
            }
            g.drawRect(0, 0, width - 1, height - 1);
        }
        g.dispose();
        return image;
    }

    private static void testHeatmap(String filename) {
        double[][] values = new double[][]{{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0}, {9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0}, {10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0}};
        BufferedImage image = Plot2D.drawHeatmap(values, new UnidirectionalColorGradient(0.0, 10.0, Color.black, Color.white));
        File file = null;
        file = filename == null || filename.length() <= 0 ? new File("heatmap.png") : new File(filename);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }

    private static void testHistogramOverlayLabels(String filename) {
        String[] labels = new String[]{"Label 1", "Label 2", "Label 3", "Label 4", "Label 5"};
        CanvasSettings cs = CanvasSettings.getCanvasSettings(0, 32, 0, 0, 1, 101, 1, false, true, true, true, true, false, 128, 1.0, 1.0, 10.0, 10.0, -1, 10000, 1);
        BufferedImage image = PlotUtilities.drawHistogramOverlayLabels(labels, cs);
        File file = null;
        file = filename == null || filename.length() <= 0 ? new File("labels.png") : new File(filename);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }

    private static void testColorGradient(String filename) {
        BidirectionalColorGradient gradient = BidirectionalColorGradient.getBidirectionalColorGradient(1, 5.0, 10.0, 15.0);
        BufferedImage image = PlotUtilities.drawColorGradient(gradient);
        File file = null;
        file = filename == null || filename.length() <= 0 ? new File("gradient.png") : new File(filename);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Plot2D.testHistogramOverlayLabels(args[0]);
        } else {
            Plot2D.testHistogramOverlayLabels(null);
        }
    }
}

