## ----style, eval=TRUE, echo=FALSE, results="asis"---------------------------------------
BiocStyle::latex()

## ----shinyMethylData, eval=FALSE--------------------------------------------------------
#  library(shinyMethyl)
#  library(shinyMethylData)
#  runShinyMethyl(summary.tcga.raw, summary.tcga.norm)

## ----minfidata,eval=TRUE,warning=FALSE,message=FALSE------------------------------------
library(minfiData)

## ----2stepapproach,eval=TRUE,message=FALSE,warning=FALSE--------------------------------
library(shinyMethyl)
summary <- shinySummarize(RGsetEx) 

## ----launching,eval=FALSE---------------------------------------------------------------
#  runShinyMethyl(summary)

## ----loadlibraries, eval=TRUE, results="hide",warning=FALSE,message=FALSE---------------
library(minfiData)
library(minfi)

## ----basedir,eval=FALSE-----------------------------------------------------------------
#  baseDir <- system.file("extdata", package = "minfiData")
#  # baseDir <- "/home/yourDirectoryPath"

## ----experimentsheet,eval=FALSE---------------------------------------------------------
#  targets <- read.450k.sheet(baseDir)
#  head(targets)

## ----rgsetconstruction,eval=FALSE-------------------------------------------------------
#  RGSet <- read.450k.exp(base = baseDir, targets = targets)

## ----phenotype, eval=FALSE--------------------------------------------------------------
#  pd <- pData(RGSet)
#  head(pd)

## ----summarize, eval=FALSE--------------------------------------------------------------
#  myShinyMethylSet <- shinySummarize(RGSet)

## ----sessionLaunching, eval=FALSE-------------------------------------------------------
#  runShinyMethyl(myShinyMethylSet)

## ----normalize, eval=FALSE--------------------------------------------------------------
#  GRSet.norm <- preprocessQuantile(RGSet)

## ----summarizeNorm,eval=FALSE-----------------------------------------------------------
#  summary   <- shinySummarize(RGSset)
#  summary.norm <- shinySummarize(GRSet.norm)

## ----runshiny,eval=FALSE----------------------------------------------------------------
#  runShinyMethyl(summary, summary.norm)

## ----eval=TRUE,warning=FALSE,message=FALSE----------------------------------------------
library(shinyMethyl)
library(shinyMethylData)
slotNames(summary.tcga.raw)

## ----pheno,eval=TRUE--------------------------------------------------------------------
head(summary.tcga.raw@phenotype)

## ----sessionInfo, results="asis", echo=FALSE, eval=TRUE---------------------------------
toLatex(sessionInfo())

