/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

import java.util.Comparator;
import java.util.TreeSet;

public class SortedROCSet
extends TreeSet<PredictionCount> {
    public SortedROCSet() {
        super(new ResultComparator());
    }

    public static class PredictionCount {
        double se;
        double fpr;

        public PredictionCount(double f, double s) {
            this.se = s;
            this.fpr = f;
        }

        public double getSe() {
            return this.se;
        }

        public double getFPR() {
            return this.fpr;
        }
    }

    public static class ResultComparator
    implements Comparator<PredictionCount> {
        @Override
        public int compare(PredictionCount lhs, PredictionCount rhs) {
            if (Double.isNaN(lhs.fpr) || Double.isNaN(lhs.se) || Double.isNaN(rhs.fpr) || Double.isNaN(rhs.se)) {
                return 0;
            }
            if (lhs.fpr == rhs.fpr) {
                if (lhs.se == rhs.se) {
                    return 0;
                }
                return lhs.se > rhs.se ? 1 : -1;
            }
            if (lhs.fpr > rhs.fpr) {
                return 1;
            }
            return -1;
        }
    }
}

