/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare.visitors;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.taxatree.VisitInfo;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.PrintStream;
import java.util.List;

public class EstimateSPrintVisitor
implements TreeVisitor<MCTaxon> {
    private PrintStream out;
    private List<MCSample> samples;
    private String rank;
    private int nodeCount = 0;

    public EstimateSPrintVisitor(PrintStream out, List<MCSample> samples, String rank, int nodeCount) {
        this.out = out;
        this.samples = samples;
        this.rank = rank;
        this.nodeCount = nodeCount;
        this.printHeader();
    }

    private void printHeader() {
        this.out.println("EstimateS File prepared by RDP MultiCompare Library Comparision Tool");
        this.out.println(this.nodeCount + "\t" + this.samples.size());
    }

    public boolean visitNode(VisitInfo<MCTaxon> info) {
        MCTaxon taxon = (MCTaxon)info.getTaxon();
        if (!taxon.getRank().equals(this.rank)) {
            return true;
        }
        StringBuffer sampleBuf = new StringBuffer();
        int seqCount = 0;
        for (MCSample sample : this.samples) {
            sampleBuf.append(taxon.getCount(sample) + "\t");
            seqCount += taxon.getCount(sample);
        }
        if (seqCount > 0) {
            this.out.println(sampleBuf);
        }
        return true;
    }
}

