## ----style, eval=TRUE, echo=FALSE, results='asis'---------------------------------------
BiocStyle::latex()

## ----env, echo=FALSE--------------------------------------------------------------------
suppressPackageStartupMessages(library("proteoQC"))
suppressPackageStartupMessages(library("R.utils"))

## ----showdata, eval=TRUE----------------------------------------------------------------
library("rpx")
px <- PXDataset("PXD000864")
px

## ----pxfiles----------------------------------------------------------------------------
head(pxfiles(px))
tail(pxfiles(px))

## ----mgfs, eval=TRUE--------------------------------------------------------------------
mgfs <- grep("mgf", pxfiles(px), value = TRUE)
mgfs <- grep("-0[5-6]-[1|2]", mgfs, value=TRUE)
mgfs

## ----downloadmgfs, eval=FALSE-----------------------------------------------------------
#  mgffiles <- pxget(px, mgfs)
#  library("R.utils")
#  mgffiles <- sapply(mgffiles, gunzip)

## ----timmgf, echo=FALSE, eval=FALSE-----------------------------------------------------
#  ## Generate the lightweight qc report,
#  ## trim the mgf files to 1/10 of their size.
#  
#  trimMgf <- function(f, m = 1/10, overwrite = FALSE) {
#      message("Reading ", f)
#      x <- readLines(f)
#      beg <- grep("BEGIN IONS", x)
#      end <- grep("END IONS", x)
#      n <- length(beg)
#      message("Sub-setting to ", m)
#      i <- sort(sample(n, floor(n * m)))
#      k <- unlist(mapply(seq, from = beg[i], to = end[i]))
#      if (overwrite) {
#          unlink(f)
#          message("Writing ", f)
#          writeLines(x[k], con = f)
#          return(f)
#      } else {
#          g <- sub(".mgf", "_small.mgf", f)
#          message("Writing ", g)
#          writeLines(x[k], con = g)
#          return(g)
#      }
#  }
#  
#  set.seed(1)
#  mgffiles <- sapply(mgffiles, trimMgf, overwrite = TRUE)

## ----downloadfasta, eval=FALSE----------------------------------------------------------
#  fas <- pxget(px, "TTE2010.zip")
#  fas <- unzip(fas)
#  fas

## ----makedesignfile, eval=FALSE, echo=FALSE---------------------------------------------
#  
#  ## code to regenerate the design file
#  sample <- rep(c("55","75"),each=4)
#  techrep <- rep(1:2, 4)
#  biorep <- rep(1, length(mgffiles))
#  frac <- rep((rep(5:6, each = 2)), 2)
#  des <- data.frame(file = mgffiles,
#                    sample = sample,
#                    bioRep = biorep, techRep = techrep,
#                    fraction = frac,
#                    row.names = NULL)
#  
#  write.table(des, sep = " ", row.names=FALSE,
#              quote = FALSE,
#              file = "../inst/extdata/PXD000864-design.txt")
#  

## ----design-----------------------------------------------------------------------------
design <- system.file("extdata/PXD000864-design.txt", package = "proteoQC")
design
read.table(design, header = TRUE)

## ----run, eval=FALSE, tidy=FALSE--------------------------------------------------------
#  qcres <- msQCpipe(spectralist = design,
#                    fasta = fas,
#                    outdir = "./qc",
#                    miss  = 0,
#                    enzyme = 1, varmod = 2, fixmod = 1,
#                    tol = 10, itol = 0.6, cpu = 2,
#                    mode = "identification")

## ----loadres----------------------------------------------------------------------------
zpqc <- system.file("extdata/qc.zip", package = "proteoQC")
unzip(zpqc)
qcres <- loadmsQCres("./qc")

## ----res--------------------------------------------------------------------------------
print(qcres)

## ----rep1, message = FALSE--------------------------------------------------------------
html <- reportHTML(qcres)

## ----rep2, message = FALSE--------------------------------------------------------------
html <- reportHTML("./qc")

## ----qczip, eval=FALSE, echo=FALSE------------------------------------------------------
#  ## Remove these files as they are really big
#  ## but this breaks reportHTML(qcres), though
#  unlink("./qc/database/target_decoy.fasta")
#  unlink("./qc/result/*_xtandem.xml")
#  unlink("../inst/extdata/qc.zip")
#  zip("../inst/extdata/qc.zip", "./qc")

## ----pg,fig.width=6,fig.height=4--------------------------------------------------------
pep.zip <- system.file("extdata/pep.zip", package = "proteoQC")
unzip(pep.zip)
proteinGroup(file = "pep.txt", outfile = "pg.txt")

## ----labelRatio-------------------------------------------------------------------------
mgf.zip <- system.file("extdata/mgf.zip", package = "proteoQC")
unzip(mgf.zip)
a <- labelRatio("test.mgf")

## ----sessioninfo, results='asis', echo=FALSE--------------------------------------------
toLatex(sessionInfo())

