/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.parser;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.waiting.WaitingHandler;
import com.compomics.util.protein.Header;
import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.ModificationMap;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.ProteinMap;
import de.proteinms.xtandemparser.xtandem.Spectrum;
import de.proteinms.xtandemparser.xtandem.SupportData;
import de.proteinms.xtandemparser.xtandem.XTandemFile;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.xml.sax.SAXException;

public class XTandemIdfileReader
extends ExperimentObject
implements IdfileReader {
    private XTandemFile xTandemFile = null;
    private ModificationMap modificationMap;
    private ProteinMap proteinMap;
    private PeptideMap peptideMap;

    public XTandemIdfileReader() {
    }

    public XTandemIdfileReader(File aFile) throws SAXException {
        if (!aFile.getName().endsWith("mods.xml") || !aFile.getName().endsWith("usermods.xml")) {
            this.xTandemFile = new XTandemFile(aFile.getPath());
            this.modificationMap = this.xTandemFile.getModificationMap();
            this.proteinMap = this.xTandemFile.getProteinMap();
            this.peptideMap = this.xTandemFile.getPeptideMap();
        }
    }

    public String getExtension() {
        return "t.xml";
    }

    public String getFileName() {
        File tempFile = new File(this.xTandemFile.getFileName());
        return tempFile.getName();
    }

    public HashSet<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, Exception {
        HashSet<SpectrumMatch> foundPeptides = new HashSet<SpectrumMatch>();
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressValue(this.xTandemFile.getSpectraNumber());
        }
        Iterator spectraIt = this.xTandemFile.getSpectraIterator();
        while (spectraIt.hasNext()) {
            String spectrumName;
            Spectrum currentSpectrum = (Spectrum)spectraIt.next();
            int spectrumId = currentSpectrum.getSpectrumId();
            int spectrumNumber = currentSpectrum.getSpectrumNumber();
            SupportData supportData = this.xTandemFile.getSupportData(spectrumNumber);
            String tempName = spectrumId + "";
            if (supportData.getFragIonSpectrumDescription() != null) {
                tempName = supportData.getFragIonSpectrumDescription();
            }
            if ((spectrumName = this.fixMgfTitle(tempName)).indexOf("RTINSECONDS=") != -1) {
                spectrumName = spectrumName.substring(0, spectrumName.indexOf("RTINSECONDS="));
            }
            spectrumName = spectrumName.trim();
            ArrayList<de.proteinms.xtandemparser.xtandem.Peptide> spectrumPeptides = this.peptideMap.getAllPeptides(currentSpectrum.getSpectrumNumber());
            if (spectrumPeptides.size() > 0) {
                String tempFile = this.xTandemFile.getInputParameters().getSpectrumPath();
                String filename = Util.getFileName((String)tempFile);
                Charge charge = new Charge(1, currentSpectrum.getPrecursorCharge());
                String spectrumKey = com.compomics.util.experiment.massspectrometry.Spectrum.getSpectrumKey((String)filename, (String)spectrumName);
                SpectrumMatch currentMatch = new SpectrumMatch(spectrumKey);
                currentMatch.setSpectrumNumber(Integer.valueOf(spectrumId));
                HashMap hitMap = new HashMap();
                for (de.proteinms.xtandemparser.xtandem.Peptide peptide : spectrumPeptides) {
                    for (Domain domain : peptide.getDomains()) {
                        if (!hitMap.containsKey(domain.getDomainExpect())) {
                            hitMap.put(domain.getDomainExpect(), new ArrayList());
                        }
                        ((ArrayList)hitMap.get(domain.getDomainExpect())).add(domain);
                    }
                }
                ArrayList eValues = new ArrayList(hitMap.keySet());
                Collections.sort(eValues);
                int rank = 1;
                for (Double eValue : eValues) {
                    int rankIncrease = 0;
                    for (Domain domain : (ArrayList)hitMap.get(eValue)) {
                        PeptideAssumption newAssumption = this.getPeptideAssumption(domain, charge.value, rank);
                        boolean found = false;
                        for (PeptideAssumption loadedAssumption : currentMatch.getAllAssumptions()) {
                            if (!loadedAssumption.getPeptide().isSameAs(newAssumption.getPeptide())) continue;
                            for (String protein : newAssumption.getPeptide().getParentProteins()) {
                                if (loadedAssumption.getPeptide().getParentProteins().contains(protein)) continue;
                                loadedAssumption.getPeptide().getParentProteins().add(protein);
                            }
                            for (String protein : loadedAssumption.getPeptide().getParentProteins()) {
                                if (newAssumption.getPeptide().getParentProteins().contains(protein)) continue;
                                newAssumption.getPeptide().getParentProteins().add(protein);
                            }
                            if (!loadedAssumption.getPeptide().sameModificationsAs(newAssumption.getPeptide())) continue;
                            found = true;
                        }
                        if (found) continue;
                        ++rankIncrease;
                        currentMatch.addHit(2, newAssumption);
                    }
                    rank += rankIncrease;
                }
                foundPeptides.add(currentMatch);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.increaseSecondaryProgressValue();
        }
        return foundPeptides;
    }

    private PeptideAssumption getPeptideAssumption(Domain domain, int charge, int rank) {
        String accession;
        ArrayList<String> proteins = new ArrayList<String>();
        String sequence = domain.getDomainSequence();
        String description = this.proteinMap.getProtein(domain.getProteinKey()).getDescription() != null ? this.proteinMap.getProtein(domain.getProteinKey()).getDescription() : this.proteinMap.getProtein(domain.getProteinKey()).getLabel();
        try {
            Header fastaHeader = Header.parseFromFASTA((String)description);
            accession = fastaHeader.getAccession();
            if (accession == null) {
                accession = fastaHeader.getRest();
            }
        }
        catch (Exception e) {
            accession = description;
        }
        if (accession == null) {
            JOptionPane.showMessageDialog(null, "Unable to extract the accession number from protein description: \n'" + description + "'" + "\n\nVerify your FASTA file!", "Unknown Protein!", 0);
            throw new IllegalArgumentException("Unable to extract the accession number from protein description: \n'" + description + "'.\n" + "Please verify your FASTA file!");
        }
        proteins.add(accession);
        ArrayList<ModificationMatch> foundModifications = new ArrayList<ModificationMatch>();
        ArrayList<Modification> foundVariableModifications = this.modificationMap.getVariableModifications(domain.getDomainKey());
        for (Modification currentModification : foundVariableModifications) {
            int location = new Integer(currentModification.getLocation()) - domain.getDomainStart() + 1;
            foundModifications.add(new ModificationMatch(currentModification.getName(), true, location));
        }
        Peptide peptide = new Peptide(sequence, proteins, foundModifications);
        return new PeptideAssumption(peptide, rank, 2, new Charge(1, charge), domain.getDomainExpect(), this.getFileName());
    }

    private String fixMgfTitle(String spectrumTitle) {
        try {
            spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("An exception was thrown when trying to decode an mgf tile!");
            e.printStackTrace();
        }
        return spectrumTitle;
    }

    public void close() throws IOException {
        this.xTandemFile = null;
    }
}

