/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl254;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.converter.impl254.InteractorConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.ExperimentalInteractor;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml254.jaxb.ExperimentRefList;

public class ExperimentalInteractorConverter {
    private InteractorConverter interactorConverter = new InteractorConverter();
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.interactorConverter.setDAOFactory(factory);
        this.experimentDescriptionConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve interactor and experiment id.");
        }
    }

    public ExperimentalInteractor fromJaxb(psidev.psi.mi.xml254.jaxb.ExperimentalInteractor jExperimentalInteractor) throws ConverterException {
        if (jExperimentalInteractor == null) {
            throw new IllegalArgumentException("You must give a non null JAXB ExperimentalInteractor.");
        }
        this.checkDependencies();
        ExperimentalInteractor mExperimentalInteractor = new ExperimentalInteractor();
        if (jExperimentalInteractor.getExperimentRefList() != null) {
            PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
            for (Integer jExperimentId : jExperimentalInteractor.getExperimentRefList().getExperimentReves()) {
                ExperimentDescription experiment = experimentDAO.retreive(jExperimentId);
                if (experiment == null) {
                    mExperimentalInteractor.getExperimentRefs().add(new ExperimentRef(jExperimentId));
                    continue;
                }
                mExperimentalInteractor.getExperiments().add(experiment);
            }
        }
        Interactor interactor = null;
        if (jExperimentalInteractor.getInteractorRef() != null) {
            PsiDAO<Interactor> interactorDAO = this.factory.getInteractorDAO();
            interactor = interactorDAO.retreive(jExperimentalInteractor.getInteractorRef());
        } else if (jExperimentalInteractor.getInteractor() != null) {
            interactor = this.interactorConverter.fromJaxb(jExperimentalInteractor.getInteractor());
        } else {
            throw new ConverterException("neither an interactor ref or an interactor were provided.");
        }
        mExperimentalInteractor.setInteractor(interactor);
        return mExperimentalInteractor;
    }

    public psidev.psi.mi.xml254.jaxb.ExperimentalInteractor toJaxb(ExperimentalInteractor mExperimentalInteractor) throws ConverterException {
        if (mExperimentalInteractor == null) {
            throw new IllegalArgumentException("You must give a non null model ExperimentalInteractor.");
        }
        this.checkDependencies();
        psidev.psi.mi.xml254.jaxb.ExperimentalInteractor jExperimentalInteractor = new psidev.psi.mi.xml254.jaxb.ExperimentalInteractor();
        if (mExperimentalInteractor.hasExperiments()) {
            if (jExperimentalInteractor.getExperimentRefList() == null) {
                jExperimentalInteractor.setExperimentRefList(new ExperimentRefList());
            }
            for (ExperimentDescription experimentDescription : mExperimentalInteractor.getExperiments()) {
                jExperimentalInteractor.getExperimentRefList().getExperimentReves().add(experimentDescription.getId());
            }
        } else if (mExperimentalInteractor.hasExperimentRefs()) {
            if (jExperimentalInteractor.getExperimentRefList() == null) {
                jExperimentalInteractor.setExperimentRefList(new ExperimentRefList());
            }
            for (ExperimentRef experimentDescription : mExperimentalInteractor.getExperimentRefs()) {
                jExperimentalInteractor.getExperimentRefList().getExperimentReves().add(experimentDescription.getRef());
            }
        }
        jExperimentalInteractor.setInteractorRef(mExperimentalInteractor.getInteractor().getId());
        return jExperimentalInteractor;
    }
}

