/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.PsimiXmlVersion;
import psidev.psi.mi.xml.io.impl.PsimiXmlReader253;
import psidev.psi.mi.xml.io.impl.PsimiXmlReader254;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.util.PsimiXmlVersionDetector;

public class PsimiXmlReader
implements psidev.psi.mi.xml.io.PsimiXmlReader {
    private psidev.psi.mi.xml.io.PsimiXmlReader reader;
    private PsimiXmlVersion version;

    public PsimiXmlReader() {
    }

    public PsimiXmlReader(PsimiXmlVersion version2) {
        this();
        this.version = version2;
    }

    public EntrySet read(String s) throws PsimiXmlReaderException {
        return this.read(new StringReader(s));
    }

    public EntrySet read(File file) throws PsimiXmlReaderException {
        try {
            return this.read(new FileReader(file));
        }
        catch (FileNotFoundException e2) {
            throw new PsimiXmlReaderException("File not found: " + file, e2);
        }
    }

    public EntrySet read(InputStream is) throws PsimiXmlReaderException {
        return this.read(new InputStreamReader(is));
    }

    public EntrySet read(URL url) throws PsimiXmlReaderException {
        try {
            return this.read(url.openStream());
        }
        catch (IOException e2) {
            throw new PsimiXmlReaderException("Problem reading URL: " + url, e2);
        }
    }

    public EntrySet read(Reader inputReader) throws PsimiXmlReaderException {
        PushbackReader pReader = new PushbackReader(inputReader, 512);
        this.initReader(pReader);
        return this.reader.read(pReader);
    }

    private void initReader(PushbackReader reader) throws PsimiXmlReaderException {
        if (this.version == null) {
            PsimiXmlVersionDetector detector = new PsimiXmlVersionDetector();
            try {
                this.version = detector.detectVersion(reader);
            }
            catch (IOException e2) {
                throw new PsimiXmlReaderException("Problem detecting version", e2);
            }
        }
        switch (this.version) {
            case VERSION_254: {
                this.reader = new PsimiXmlReader254();
                break;
            }
            case VERSION_253: {
                this.reader = new PsimiXmlReader253();
                break;
            }
            case VERSION_25_UNDEFINED: {
                this.reader = new PsimiXmlReader253();
            }
        }
    }
}

