/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.biopax.paxtools.model.BioPAXLevel;
import org.mskcc.psibiopax.converter.BioPAXMarshaller;
import org.mskcc.psibiopax.converter.EntryMapper;
import org.mskcc.psibiopax.converter.PSIMIConverter;
import psidev.psi.mi.tab.PsimiTabException;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.converter.tab2xml.Tab2Xml;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;

public class PSIMIBioPAXConverter
implements PSIMIConverter {
    private final BioPAXLevel bpLevel;
    private final String xmlBase;
    protected boolean conversionIsComplete;

    public PSIMIBioPAXConverter(BioPAXLevel bpLevel) {
        this.bpLevel = bpLevel;
        this.xmlBase = "";
    }

    public PSIMIBioPAXConverter(BioPAXLevel bpLevel, String xmlBase) {
        this.bpLevel = bpLevel;
        this.xmlBase = xmlBase;
    }

    @Override
    public boolean convert(InputStream inputStream, OutputStream outputStream) throws IOException, PsimiXmlReaderException {
        if (inputStream == null || outputStream == null) {
            throw new IllegalArgumentException("convert(): one or more null arguments.");
        }
        PsimiXmlReader reader = new PsimiXmlReader();
        EntrySet entrySet = reader.read(inputStream);
        inputStream.close();
        return this.convert(entrySet, outputStream);
    }

    @Override
    public boolean convertTab(InputStream inputStream, OutputStream outputStream) throws IOException, PsimiTabException {
        EntrySet entrySet;
        if (inputStream == null || outputStream == null) {
            throw new IllegalArgumentException("convertTab(): one or more null arguments.");
        }
        PsimiTabReader reader = new PsimiTabReader();
        Collection<BinaryInteraction> interactions = reader.read(inputStream);
        Tab2Xml tab2Xml = new Tab2Xml();
        try {
            entrySet = tab2Xml.convert(interactions);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (XmlConversionException e3) {
            throw new RuntimeException(e3);
        }
        boolean result = this.convert(entrySet, outputStream);
        inputStream.close();
        return result;
    }

    @Override
    public boolean convert(EntrySet entrySet, OutputStream outputStream) {
        if (entrySet == null || outputStream == null) {
            throw new IllegalArgumentException("convert: one or more null arguments.");
        }
        if (entrySet.getLevel() != 2) {
            throw new IllegalArgumentException("convert: only PSI-MI Level 2.5 is supported.");
        }
        BioPAXMarshaller biopaxMarshaller = new BioPAXMarshaller(this, outputStream);
        ExecutorService exec = Executors.newCachedThreadPool();
        int i = 0;
        for (Entry entry : entrySet.getEntries()) {
            String xmlBasePart = entry.hasSource() && entry.getSource().hasNames() && entry.getSource().getNames().hasShortLabel() ? entry.getSource().getNames().getShortLabel() : String.valueOf(++i);
            try {
                xmlBasePart = URLEncoder.encode(xmlBasePart, "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                xmlBasePart = URLEncoder.encode(xmlBasePart);
            }
            exec.execute(new EntryMapper(this.bpLevel, this.xmlBase + xmlBasePart + "_", biopaxMarshaller, entry));
        }
        exec.shutdown();
        try {
            exec.awaitTermination(86400L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e3) {
            throw new RuntimeException("Interrupted!", e3);
        }
        entrySet.getEntries().clear();
        System.gc();
        biopaxMarshaller.marshallData();
        return true;
    }

    public BioPAXLevel getBpLevel() {
        return this.bpLevel;
    }

    public String getXmlBase() {
        return this.xmlBase;
    }
}

