/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.util.PointD;

public class SbgnProcessNode
extends SbgnPDNode {
    boolean isDebugON = false;
    public boolean isHighlighted = false;
    protected SbgnPDNode parentCompound;
    private SbgnPDNode inputPort;
    private SbgnPDNode outputPort;
    int rotationPriority = 0;
    public double idealEdgeLength = 0.0;
    ArrayList<SbgnPDNode> inputNeighborNodeList = new ArrayList();
    ArrayList<SbgnPDNode> outputNeighborNodeList = new ArrayList();
    ArrayList<SbgnPDEdge> inputNeighborEdgeList = new ArrayList();
    ArrayList<SbgnPDEdge> outputNeighborEdgeList = new ArrayList();
    protected double netRotationalForce = 0.0;
    protected Orientation orientation;

    public SbgnProcessNode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
    }

    public SbgnProcessNode(LGraphManager gm, Point loc, Dimension size, LNode vNode, String type) {
        super(gm, loc, size, vNode, type);
    }

    public void copyNode(SbgnProcessNode s, LGraphManager graphManager) {
        this.type = s.type;
        this.label = s.label;
        this.isHighlighted = s.isHighlighted;
        this.parentCompound = s.parentCompound;
        this.setInputPort(s.getInputPort());
        this.setOutputPort(s.getOutputPort());
        this.setCenter(s.getCenterX(), s.getCenterY());
        this.setChild(s.getChild());
        this.setHeight(s.getHeight());
        this.setLocation(s.getLocation().x, s.getLocation().y);
        this.setNext(s.getNext());
        this.setOwner(s.getOwner());
        this.setPred1(s.getPred1());
        this.setPred2(s.getPred2());
        this.setWidth(s.getWidth());
    }

    public void copyFromSBGNPDNode(SbgnPDNode s, LGraphManager graphManager) {
        this.type = s.type;
        this.label = s.label;
        this.setCenter(s.getCenterX(), s.getCenterY());
        this.setChild(s.getChild());
        this.setHeight(s.getHeight());
        this.setLocation(s.getLocation().x, s.getLocation().y);
        this.setNext(s.getNext());
        this.setOwner(s.getOwner());
        this.setPred1(s.getPred1());
        this.setPred2(s.getPred2());
        this.setWidth(s.getWidth());
        for (Object o : s.getEdges()) {
            SbgnPDEdge edge = (SbgnPDEdge)o;
            SbgnPDEdge newEdge = new SbgnPDEdge((SbgnPDNode)edge.getSource(), (SbgnPDNode)edge.getTarget(), null, edge.type);
            newEdge.copy(edge);
            if (edge.getSource().equals(s)) {
                newEdge.setSource(this);
            } else if (edge.getTarget().equals(s)) {
                newEdge.setTarget(this);
            }
            graphManager.add(newEdge, newEdge.getSource(), newEdge.getTarget());
        }
    }

    public void setConnectedNodes(SbgnPDNode parentCompound, SbgnPDNode inputPort, SbgnPDNode outputPort) {
        this.parentCompound = parentCompound;
        this.parentCompound.isDummyCompound = true;
        this.setInputPort(inputPort);
        this.setOutputPort(outputPort);
        this.orientation = Orientation.LEFT_TO_RIGHT;
        outputPort.setCenter(this.getCenterX() + 10.0, this.getCenterY());
        inputPort.setCenter(this.getCenterX() - 10.0, this.getCenterY());
    }

    public boolean checkRotationAvailability() {
        this.netRotationalForce /= (double)(2 * (this.inputNeighborNodeList.size() + this.outputNeighborNodeList.size()));
        this.rotationPriority = this.isSwapAvailable() ? 2 : (Math.abs(this.netRotationalForce) > 70.0 ? 1 : 0);
        return this.rotationPriority != 0;
    }

    public void applyRotation() {
        if (this.isHighlighted && this.isDebugON) {
            System.out.println("****VALUES for " + this.label + " ****");
            System.out.println("netRotationalForce: " + this.netRotationalForce);
            System.out.println("prev orientation: " + (Object)((Object)this.orientation));
        }
        if (this.rotationPriority == 1) {
            if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
                if (this.netRotationalForce > 70.0) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.RIGHT_TO_LEFT;
                } else if (this.netRotationalForce < -70.0) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.LEFT_TO_RIGHT;
                }
            } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
                if (this.netRotationalForce < -70.0) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.LEFT_TO_RIGHT;
                } else if (this.netRotationalForce > 70.0) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.RIGHT_TO_LEFT;
                }
            } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
                if (this.netRotationalForce > 70.0) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.BOTTOM_TO_TOP;
                } else if (this.netRotationalForce < -70.0) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.TOP_TO_BOTTOM;
                }
            } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
                if (this.netRotationalForce < -70.0) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.BOTTOM_TO_TOP;
                } else if (this.netRotationalForce > 70.0) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.TOP_TO_BOTTOM;
                }
            }
        } else if (this.rotationPriority == 2) {
            if (this.isHighlighted && this.isDebugON) {
                System.out.println("SWAPPED");
            }
            PointD tempCenter = this.inputPort.getCenter();
            this.inputPort.setCenter(this.getOutputPort().getCenterX(), this.outputPort.getCenterY());
            this.outputPort.setCenter(tempCenter.x, tempCenter.y);
            if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
                this.orientation = Orientation.BOTTOM_TO_TOP;
            } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
                this.orientation = Orientation.TOP_TO_BOTTOM;
            } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
                this.orientation = Orientation.RIGHT_TO_LEFT;
            } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
                this.orientation = Orientation.LEFT_TO_RIGHT;
            }
        }
        this.calculateRotationalForces(this.idealEdgeLength);
        this.netRotationalForce = 0.0;
    }

    private boolean isSwapAvailable() {
        double obtuseAngleCnt = 0.0;
        double acuteAngleCnt = 0.0;
        for (SbgnPDEdge edge : this.inputNeighborEdgeList) {
            if (Math.abs(edge.correspondingAngle) > 90) {
                obtuseAngleCnt += 1.0;
                continue;
            }
            acuteAngleCnt += 1.0;
        }
        for (SbgnPDEdge edge : this.outputNeighborEdgeList) {
            if (Math.abs(edge.correspondingAngle) > 90) {
                obtuseAngleCnt += 1.0;
                continue;
            }
            acuteAngleCnt += 1.0;
        }
        return obtuseAngleCnt / (obtuseAngleCnt + acuteAngleCnt) > 0.5;
    }

    private void rotateCompound(int rotationDegree) {
        if (this.isHighlighted && this.isDebugON) {
            System.out.println("ROTATED");
        }
        this.rotateNode(this.getCenter(), rotationDegree);
        this.inputPort.rotateNode(this.getCenter(), rotationDegree);
        this.outputPort.rotateNode(this.getCenter(), rotationDegree);
        this.parentCompound.updateBounds();
        if (this.isHighlighted && this.isDebugON) {
            System.out.println("new Orientation: " + (Object)((Object)this.orientation));
        }
    }

    public void transferForces() {
        this.parentCompound.springForceX += this.springForceX + this.inputPort.springForceX + this.outputPort.springForceX;
        this.parentCompound.springForceY += this.springForceY + this.inputPort.springForceY + this.outputPort.springForceY;
    }

    public double calculateRotationalForces(double idealEdgeLength) {
        double result;
        int nodeIndex;
        this.idealEdgeLength = idealEdgeLength;
        double inputRotSum = 0.0;
        double outputRotSum = 0.0;
        double count = 0.0;
        if (this.inputNeighborNodeList.size() == 0 && this.outputNeighborNodeList.size() == 0) {
            SbgnPDEdge edge;
            for (Object o : this.inputPort.getEdges()) {
                edge = (SbgnPDEdge)o;
                if (edge.type.equals("rigid edge")) continue;
                this.inputNeighborNodeList.add((SbgnPDNode)edge.getSource());
                this.inputNeighborEdgeList.add(edge);
            }
            for (Object o : this.outputPort.getEdges()) {
                edge = (SbgnPDEdge)o;
                if (edge.type.equals("rigid edge")) continue;
                this.outputNeighborNodeList.add((SbgnPDNode)edge.getTarget());
                this.outputNeighborEdgeList.add(edge);
            }
        }
        PointD inputPortTarget = this.findPortTargetPoint(true, idealEdgeLength);
        PointD outputPortTarget = this.findPortTargetPoint(false, idealEdgeLength);
        for (nodeIndex = 0; nodeIndex < this.inputNeighborNodeList.size(); ++nodeIndex) {
            result = this.calculateRotationalForce(true, nodeIndex, inputPortTarget);
            if (Math.abs(result) < 100.0) {
                count += 1.0;
            }
            inputRotSum += result;
        }
        for (nodeIndex = 0; nodeIndex < this.outputNeighborNodeList.size(); ++nodeIndex) {
            result = this.calculateRotationalForce(false, nodeIndex, outputPortTarget);
            if (Math.abs(result) < 100.0) {
                count += 1.0;
            }
            outputRotSum += result;
        }
        this.netRotationalForce += inputRotSum - outputRotSum;
        return count;
    }

    private double calculateRotationalForce(boolean isInputPort, int nodeIndex, PointD targetPoint) {
        double angleValue = 0.0;
        SbgnPDNode node = isInputPort ? this.inputNeighborNodeList.get(nodeIndex) : this.outputNeighborNodeList.get(nodeIndex);
        PointD centerPoint = isInputPort ? this.inputPort.getCenter() : this.outputPort.getCenter();
        PointD point1 = new PointD(targetPoint.x - centerPoint.x, targetPoint.y - centerPoint.y);
        PointD point2 = new PointD(node.getCenterX() - centerPoint.x, node.getCenterY() - centerPoint.y);
        if (Math.abs(point1.x) < 0.0) {
            point1.x = 1.0E-4;
        }
        if (Math.abs(point1.y) < 0.0) {
            point1.y = 1.0E-4;
        }
        angleValue = (point1.x * point2.x + point1.y * point2.y) / (Math.sqrt(point1.x * point1.x + point1.y * point1.y) * Math.sqrt(point2.x * point2.x + point2.y * point2.y));
        double angle = Math.abs(Math.toDegrees(Math.acos(angleValue)));
        angle = isInputPort ? (angle *= (double)this.isLeft(targetPoint, centerPoint, node.getCenter(), "input_port")) : (angle *= (double)this.isLeft(targetPoint, centerPoint, node.getCenter(), "output_port"));
        if (isInputPort) {
            this.inputNeighborEdgeList.get((int)nodeIndex).correspondingAngle = (int)angle;
        } else {
            this.outputNeighborEdgeList.get((int)nodeIndex).correspondingAngle = (int)angle;
        }
        if (Math.abs(angle) < 100.0) {
            if (isInputPort) {
                this.inputNeighborEdgeList.get((int)nodeIndex).isProperlyOriented = true;
            } else {
                this.outputNeighborEdgeList.get((int)nodeIndex).isProperlyOriented = true;
            }
            return angle;
        }
        if (isInputPort) {
            this.inputNeighborEdgeList.get((int)nodeIndex).isProperlyOriented = false;
        } else {
            this.outputNeighborEdgeList.get((int)nodeIndex).isProperlyOriented = false;
        }
        return angle;
    }

    public int isLeft(PointD a, PointD b, PointD c, String type) {
        if ((b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0) {
            if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
                if (type.equals("input_port")) {
                    return -1;
                }
                if (type.equals("output_port")) {
                    return 1;
                }
            } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
                if (type.equals("input_port")) {
                    return 1;
                }
                if (type.equals("output_port")) {
                    return -1;
                }
            } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
                if (type.equals("input_port")) {
                    return 1;
                }
                if (type.equals("output_port")) {
                    return -1;
                }
            } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
                if (type.equals("input_port")) {
                    return -1;
                }
                if (type.equals("output_port")) {
                    return 1;
                }
            }
        } else if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
            if (type.equals("input_port")) {
                return 1;
            }
            if (type.equals("output_port")) {
                return -1;
            }
        } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
            if (type.equals("input_port")) {
                return -1;
            }
            if (type.equals("output_port")) {
                return 1;
            }
        } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
            if (type.equals("input_port")) {
                return -1;
            }
            if (type.equals("output_port")) {
                return 1;
            }
        } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
            if (type.equals("input_port")) {
                return 1;
            }
            if (type.equals("output_port")) {
                return -1;
            }
        }
        return 0;
    }

    private PointD findPortTargetPoint(boolean isInputPort, double idealEdgeLength) {
        if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX() - idealEdgeLength, this.inputPort.getCenterY());
            }
            return new PointD(this.outputPort.getCenterX() + idealEdgeLength, this.outputPort.getCenterY());
        }
        if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX() + idealEdgeLength, this.inputPort.getCenterY());
            }
            return new PointD(this.outputPort.getCenterX() - idealEdgeLength, this.outputPort.getCenterY());
        }
        if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX(), this.inputPort.getCenterY() - idealEdgeLength);
            }
            return new PointD(this.outputPort.getCenterX(), this.outputPort.getCenterY() + idealEdgeLength);
        }
        if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX(), this.inputPort.getCenterY() + idealEdgeLength);
            }
            return new PointD(this.outputPort.getCenterX(), this.outputPort.getCenterY() - idealEdgeLength);
        }
        return null;
    }

    public boolean isVertical() {
        return this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM) || this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP);
    }

    public boolean isHorizontal() {
        return this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT) || this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT);
    }

    public SbgnPDNode getParentCompound() {
        return this.parentCompound;
    }

    public SbgnPDNode getInputPort() {
        return this.inputPort;
    }

    public void setInputPort(SbgnPDNode inputPort) {
        this.inputPort = inputPort;
    }

    public SbgnPDNode getOutputPort() {
        return this.outputPort;
    }

    public void setOutputPort(SbgnPDNode outputPort) {
        this.outputPort = outputPort;
    }

    public static enum Orientation {
        BOTTOM_TO_TOP,
        TOP_TO_BOTTOM,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

