/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.EquivalenceGrouper;

public class SetEquivalenceChecker {
    public static <T extends BioPAXElement> boolean isEquivalent(Set<? extends T> set1, Set<? extends T> set2) {
        int size;
        if (set1 != null && !set1.isEmpty() && set2 != null && !set2.isEmpty() && (size = set1.size()) == set2.size()) {
            EquivalenceGrouper<T> grouper = new EquivalenceGrouper<T>();
            grouper.addAll(set1);
            if (grouper.getBuckets().size() == size) {
                grouper.addAll(set2);
                return grouper.getBuckets().size() == size;
            }
        }
        return set1 == null && set2 == null || set1 != null && set1.isEmpty() && set2 != null && set2.isEmpty();
    }

    public static boolean containsEquivalent(Set<? extends BioPAXElement> set, BioPAXElement query2) {
        if (set != null && query2 != null) {
            for (BioPAXElement bioPAXElement : set) {
                if (!query2.isEquivalent(bioPAXElement)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends BioPAXElement> Set<T> findEquivalentIntersection(Set<? extends T> set1, Set<? extends T> set2) {
        HashSet<BioPAXElement> value = new HashSet<BioPAXElement>();
        if (set1 != null && !set1.isEmpty() && set2 != null && !set2.isEmpty()) {
            EquivalenceGrouper<T> grouper = new EquivalenceGrouper<T>();
            grouper.addAll(set1);
            if (grouper.getBuckets().size() < set1.size()) {
                throw new IllegalArgumentException("There should not be equivalent elements in a set");
            }
            grouper.addAll(set2);
            for (List ts : grouper.getBuckets()) {
                if (ts.size() <= 1) continue;
                for (BioPAXElement t : ts) {
                    if (!set1.contains(t)) continue;
                    value.add(t);
                }
            }
        }
        return value;
    }

    public static <T extends BioPAXElement> boolean hasEquivalentIntersection(Set<? extends T> set1, Set<? extends T> set2) {
        if (set1 != null && !set1.isEmpty() && set2 != null && !set2.isEmpty()) {
            EquivalenceGrouper<T> grouper = new EquivalenceGrouper<T>();
            grouper.addAll(set1);
            if (grouper.getBuckets().size() == set1.size()) {
                grouper.addAll(set2);
                return grouper.getBuckets().size() < set1.size() + set2.size();
            }
            throw new IllegalArgumentException("There should not be equivalent elements in a set");
        }
        return true;
    }
}

