/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.query.algorithm.CommonStreamQuery;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.algorithm.LimitType;
import org.biopax.paxtools.query.algorithm.NeighborhoodQuery;
import org.biopax.paxtools.query.algorithm.PathsBetweenQuery;
import org.biopax.paxtools.query.algorithm.PathsFromToQuery;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.paxtools.query.wrapperL3.GraphL3;

public class QueryExecuter {
    public static Set<BioPAXElement> runNeighborhood(Set<BioPAXElement> sourceSet, Model model, int limit, Direction direction, Filter ... filters) {
        if (model.getLevel() != BioPAXLevel.L3) {
            return Collections.emptySet();
        }
        GraphL3 graph = new GraphL3(model, filters);
        Set<Node> source = QueryExecuter.prepareSingleNodeSet(sourceSet, graph);
        if (sourceSet.isEmpty()) {
            return Collections.emptySet();
        }
        NeighborhoodQuery query2 = new NeighborhoodQuery(source, direction, limit);
        Set<GraphObject> resultWrappers = query2.run();
        return QueryExecuter.convertQueryResult(resultWrappers, graph);
    }

    public static Set<BioPAXElement> runPathsBetween(Set<BioPAXElement> sourceSet, Model model, int limit, Filter ... filters) {
        if (model.getLevel() != BioPAXLevel.L3) {
            return Collections.emptySet();
        }
        GraphL3 graph = new GraphL3(model, filters);
        Collection<Set<Node>> sourceWrappers = QueryExecuter.prepareNodeSets(sourceSet, graph);
        if (sourceSet.size() < 2) {
            return Collections.emptySet();
        }
        PathsBetweenQuery query2 = new PathsBetweenQuery(sourceWrappers, limit);
        Set<GraphObject> resultWrappers = query2.run();
        return QueryExecuter.convertQueryResult(resultWrappers, graph);
    }

    public static Set<BioPAXElement> runGOI(Set<BioPAXElement> sourceSet, Model model, int limit, Filter ... filters) {
        return QueryExecuter.runPathsFromTo(sourceSet, sourceSet, model, LimitType.NORMAL, limit, filters);
    }

    public static Set<BioPAXElement> runPathsFromTo(Set<BioPAXElement> sourceSet, Set<BioPAXElement> targetSet, Model model, LimitType limitType, int limit, Filter ... filters) {
        if (model.getLevel() != BioPAXLevel.L3) {
            return Collections.emptySet();
        }
        GraphL3 graph = new GraphL3(model, filters);
        Set<Node> source = QueryExecuter.prepareSingleNodeSet(sourceSet, graph);
        Set<Node> target = QueryExecuter.prepareSingleNodeSet(targetSet, graph);
        PathsFromToQuery query2 = new PathsFromToQuery(source, target, limitType, limit, true);
        Set<GraphObject> resultWrappers = query2.run();
        return QueryExecuter.convertQueryResult(resultWrappers, graph);
    }

    public static Set<BioPAXElement> runCommonStream(Set<BioPAXElement> sourceSet, Model model, Direction direction, int limit, Filter ... filters) {
        if (model.getLevel() != BioPAXLevel.L3) {
            return Collections.emptySet();
        }
        GraphL3 graph = new GraphL3(model, filters);
        Collection<Set<Node>> source = QueryExecuter.prepareNodeSets(sourceSet, graph);
        if (sourceSet.size() < 2) {
            return Collections.emptySet();
        }
        CommonStreamQuery query2 = new CommonStreamQuery(source, direction, limit);
        Set<GraphObject> resultWrappers = query2.run();
        return QueryExecuter.convertQueryResult(resultWrappers, graph);
    }

    public static Set<BioPAXElement> runCommonStreamWithPOI(Set<BioPAXElement> sourceSet, Model model, Direction direction, int limit, Filter ... filters) {
        if (model.getLevel() != BioPAXLevel.L3) {
            return Collections.emptySet();
        }
        GraphL3 graph = new GraphL3(model, filters);
        Collection<Set<Node>> sourceSets = QueryExecuter.prepareNodeSets(sourceSet, graph);
        if (sourceSet.size() < 2) {
            return Collections.emptySet();
        }
        CommonStreamQuery commStream = new CommonStreamQuery(sourceSets, direction, limit);
        Set<GraphObject> resultWrappers = commStream.run();
        if (resultWrappers.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Node> target = new HashSet<Node>();
        for (GraphObject go : resultWrappers) {
            if (!(go instanceof Node)) continue;
            target.add((Node)go);
        }
        HashSet<Node> source = new HashSet<Node>();
        for (Set<Node> set : sourceSets) {
            source.addAll(set);
        }
        PathsFromToQuery poi = direction == Direction.DOWNSTREAM ? new PathsFromToQuery(source, target, LimitType.NORMAL, limit, true) : new PathsFromToQuery(target, source, LimitType.NORMAL, limit, true);
        resultWrappers = poi.run();
        return QueryExecuter.convertQueryResult(resultWrappers, graph);
    }

    private static HashSet<BioPAXElement> convertQueryResult(Set<GraphObject> resultWrappers, Graph graph) {
        Set<Object> result = graph.getWrappedSet(resultWrappers);
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (Object o : result) {
            set.add((BioPAXElement)o);
        }
        return set;
    }

    public static Set<Node> prepareSingleNodeSet(Set<BioPAXElement> elements, Graph graph) {
        Map<BioPAXElement, Set<PhysicalEntity>> map = QueryExecuter.getRelatedPhysicalEntityMap(elements);
        HashSet<PhysicalEntity> pes = new HashSet<PhysicalEntity>();
        for (Set<PhysicalEntity> valueSet : map.values()) {
            pes.addAll(valueSet);
        }
        Set<Node> nodes = graph.getWrapperSet(pes);
        Set<Node> inters = QueryExecuter.getSeedInteractions(elements, graph);
        nodes.addAll(inters);
        return nodes;
    }

    private static Collection<Set<Node>> prepareNodeSets(Set<BioPAXElement> elements, Graph graph) {
        HashSet<Set<Node>> sets = new HashSet<Set<Node>>();
        Map<BioPAXElement, Set<PhysicalEntity>> map = QueryExecuter.getRelatedPhysicalEntityMap(elements);
        for (Set<PhysicalEntity> pes : map.values()) {
            Set<Node> set = graph.getWrapperSet(pes);
            if (set.isEmpty()) continue;
            sets.add(set);
        }
        Set<Node> inters = QueryExecuter.getSeedInteractions(elements, graph);
        for (Node node : inters) {
            sets.add(Collections.singleton(node));
        }
        return sets;
    }

    public static Map<BioPAXElement, Set<PhysicalEntity>> getRelatedPhysicalEntityMap(Collection<BioPAXElement> elements) {
        QueryExecuter.replaceXrefsWithRelatedER(elements);
        HashMap<BioPAXElement, Set<PhysicalEntity>> map = new HashMap<BioPAXElement, Set<PhysicalEntity>>();
        for (BioPAXElement ele : elements) {
            Set<PhysicalEntity> ents = QueryExecuter.getRelatedPhysicalEntities(ele, null);
            if (ents.isEmpty()) continue;
            map.put(ele, ents);
        }
        return map;
    }

    protected static void replaceXrefsWithRelatedER(Collection<BioPAXElement> elements) {
        HashSet<EntityReference> ers = new HashSet<EntityReference>();
        HashSet<Xref> xrefs = new HashSet<Xref>();
        for (BioPAXElement element : elements) {
            if (!(element instanceof Xref)) continue;
            xrefs.add((Xref)element);
            for (XReferrable able : ((Xref)element).getXrefOf()) {
                if (!(able instanceof EntityReference)) continue;
                ers.add((EntityReference)able);
            }
        }
        elements.removeAll(xrefs);
        for (EntityReference er : ers) {
            if (elements.contains(er)) continue;
            elements.add(er);
        }
    }

    public static Set<PhysicalEntity> getRelatedPhysicalEntities(BioPAXElement element, Set<PhysicalEntity> pes) {
        block10: {
            block11: {
                block9: {
                    if (pes == null) {
                        pes = new HashSet<PhysicalEntity>();
                    }
                    if (!(element instanceof Complex)) break block9;
                    Complex cpx = (Complex)element;
                    if (pes.contains(cpx)) break block10;
                    pes.add(cpx);
                    for (Complex parent : cpx.getComponentOf()) {
                        QueryExecuter.getRelatedPhysicalEntities(parent, pes);
                    }
                    QueryExecuter.addEquivalentsComplexes(cpx, pes);
                    break block10;
                }
                if (!(element instanceof PhysicalEntity)) break block11;
                PhysicalEntity pe = (PhysicalEntity)element;
                if (pes.contains(pe)) break block10;
                pes.add(pe);
                for (Complex cmp : pe.getComponentOf()) {
                    QueryExecuter.getRelatedPhysicalEntities(cmp, pes);
                }
                QueryExecuter.addEquivalentsComplexes(pe, pes);
                break block10;
            }
            if (element instanceof Xref) {
                for (XReferrable xrable : ((Xref)element).getXrefOf()) {
                    QueryExecuter.getRelatedPhysicalEntities(xrable, pes);
                }
            } else if (element instanceof EntityReference) {
                EntityReference er = (EntityReference)element;
                for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                    QueryExecuter.getRelatedPhysicalEntities(spe, pes);
                }
                for (EntityReference parentER : er.getMemberEntityReferenceOf()) {
                    QueryExecuter.getRelatedPhysicalEntities(parentER, pes);
                }
            }
        }
        return pes;
    }

    private static void addEquivalentsComplexes(PhysicalEntity pe, Set<PhysicalEntity> pes) {
        QueryExecuter.addEquivalentsComplexes(pe, true, pes);
        QueryExecuter.addEquivalentsComplexes(pe, false, pes);
    }

    private static void addEquivalentsComplexes(PhysicalEntity pe, boolean outer, Set<PhysicalEntity> pes) {
        Set<PhysicalEntity> set = outer ? pe.getMemberPhysicalEntityOf() : pe.getMemberPhysicalEntity();
        for (PhysicalEntity related : set) {
            for (Complex cmp : related.getComponentOf()) {
                QueryExecuter.getRelatedPhysicalEntities(cmp, pes);
            }
            QueryExecuter.addEquivalentsComplexes(related, outer, pes);
        }
    }

    public static Set<Node> getSeedInteractions(Collection<BioPAXElement> elements, Graph graph) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (BioPAXElement ele : elements) {
            GraphObject go;
            if (!(ele instanceof Conversion) && !(ele instanceof TemplateReaction) && !(ele instanceof Control) || !((go = graph.getGraphObject(ele)) instanceof Node)) continue;
            nodes.add((Node)go);
        }
        return nodes;
    }
}

