/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.io.sif.level3.ChangeType;
import org.biopax.paxtools.io.sif.level3.Simplify;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;

public class PEStateChange {
    Map<EntityFeature, ChangeType> deltaFeatures;
    HashMap<Control, Boolean> deltaControls = new HashMap();
    SimplePhysicalEntity left;
    SimplePhysicalEntity right;
    Conversion conv;
    private PhysicalEntity leftRoot;
    private PhysicalEntity rightRoot;
    static PathAccessor controllers = new PathAccessor("Conversion/controlledOf/controller");

    public PEStateChange(SimplePhysicalEntity left, SimplePhysicalEntity right, PhysicalEntity leftRoot, PhysicalEntity rightRoot, BioPAXElement element, Conversion conv) {
        this.left = left;
        this.right = right;
        this.leftRoot = leftRoot;
        this.rightRoot = rightRoot;
        this.conv = conv;
        this.deltaFeatures = ChangeType.getDeltaFeatures(left, right, leftRoot, rightRoot);
        this.calculateDeltaControls();
    }

    public String toString() {
        return this.left.getStandardName() + "--" + this.right.getDisplayName() + "(" + this.deltaFeatures + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PEStateChange)) {
            return false;
        }
        PEStateChange that = (PEStateChange)o;
        if (this.conv != null ? !this.conv.equals(that.conv) : that.conv != null) {
            return false;
        }
        if (this.deltaFeatures != null ? !this.deltaFeatures.equals(that.deltaFeatures) : that.deltaFeatures != null) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public Map<EntityFeature, ChangeType> getDeltaFeatures() {
        return this.deltaFeatures;
    }

    public Conversion getConv() {
        return this.conv;
    }

    public SimplePhysicalEntity getLeft() {
        return this.left;
    }

    public SimplePhysicalEntity getRight() {
        return this.right;
    }

    public SimplePhysicalEntity changedFrom(SimplePhysicalEntity source) {
        if (this.left == source) {
            return this.getFlow(true, true);
        }
        if (this.right == source) {
            return this.getFlow(false, false);
        }
        return null;
    }

    public SimplePhysicalEntity changedInto(SimplePhysicalEntity source) {
        if (this.left == source) {
            return this.getFlow(true, false);
        }
        if (this.right == source) {
            return this.getFlow(false, true);
        }
        return null;
    }

    private SimplePhysicalEntity getFlow(boolean onLeft, boolean forward) {
        boolean flow = this.canFlow(onLeft, forward);
        return flow ? (onLeft ? this.right : this.left) : null;
    }

    private boolean canFlow(boolean targetSide, boolean forward) {
        boolean flow = true;
        ConversionDirectionType cd = this.conv.getConversionDirection();
        if (cd != null) {
            switch (cd) {
                case LEFT_TO_RIGHT: {
                    flow = !(targetSide ^ forward);
                    break;
                }
                case RIGHT_TO_LEFT: {
                    flow = targetSide ^ forward;
                    break;
                }
                default: {
                    flow = true;
                }
            }
        }
        return flow;
    }

    public int hashCode() {
        int result = this.deltaFeatures != null ? this.deltaFeatures.hashCode() : 0;
        result = 31 * result + (this.conv != null ? this.conv.hashCode() : 0);
        result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public PhysicalEntity getLeftRoot() {
        return this.leftRoot;
    }

    public PhysicalEntity getRightRoot() {
        return this.rightRoot;
    }

    public Map<Control, Boolean> getDeltaControls() {
        return this.deltaControls;
    }

    private void calculateDeltaControls() {
        Set<Control> right;
        Set<Control> left = this.leftRoot == null ? null : this.getLeftRoot().getControllerOf();
        Set<Control> set = right = this.rightRoot == null ? null : this.getRightRoot().getControllerOf();
        if (left != null) {
            for (Control control2 : left) {
                this.deltaControls.put(control2, true);
            }
        }
        if (right != null) {
            for (Control control2 : right) {
                if (this.deltaControls.containsKey(control2)) {
                    this.deltaControls.remove(control2);
                    continue;
                }
                this.deltaControls.put(control2, false);
            }
        }
    }

    public String getControllersAsString() {
        Set valueFromBean = controllers.getValueFromBean(this.conv);
        StringBuilder value = new StringBuilder();
        for (Object o : valueFromBean) {
            Controller controller = (Controller)o;
            value.append(controller.getName()).append("[");
            this.appendXrefs(controller, value);
            value.append("] ");
        }
        return value.toString();
    }

    private void appendXrefs(Controller controller, StringBuilder builder) {
        HashSet<SimplePhysicalEntity> simple = new HashSet<SimplePhysicalEntity>();
        if (controller instanceof PhysicalEntity) {
            Simplify.getSimpleMembers((PhysicalEntity)controller, simple);
            for (SimplePhysicalEntity spe : simple) {
                builder.append("(").append(spe.getEntityReference().getXref()).append(")");
            }
        }
    }
}

