/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.converter.psi;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.ExperimentalForm;
import org.biopax.paxtools.model.level3.ExperimentalFormVocabulary;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.GeneticInteraction;
import org.biopax.paxtools.model.level3.InteractionVocabulary;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.Score;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SequenceInterval;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.TissueVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Availability;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml.model.Interval;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Range;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.model.Unit;

class EntryMapper {
    private static final Log LOG = LogFactory.getLog(EntryMapper.class);
    private static final ArrayList<String> GENETIC_INTERACTIONS = new ArrayList();
    private static final String BIOGRID_EVIDENCE_CODE = "BioGRID Evidence Code";
    private static final String IDENTIFIERS_ORG = "http://identifiers.org/";
    private final Model bpModel;
    private final String xmlBase;
    private long counter;
    private final boolean forceInteractionToComplex;
    private final Map<Participant, Entity> participantMap;

    public EntryMapper(Model model, boolean forceInteractionToComplex) {
        this.bpModel = model;
        this.xmlBase = model.getXmlBase();
        this.counter = System.currentTimeMillis();
        this.forceInteractionToComplex = forceInteractionToComplex;
        this.participantMap = new HashMap<Participant, Entity>();
    }

    public void run(Entry entry) {
        HashSet<String> avail = new HashSet<String>();
        if (entry.hasAvailabilities()) {
            for (Availability a : entry.getAvailabilities()) {
                if (!a.hasValue()) continue;
                avail.add(a.getValue());
            }
        }
        Provenance pro = this.createProvenance(entry.getSource());
        HashSet<Interaction> participantInteractions = new HashSet<Interaction>();
        for (Interaction interaction2 : entry.getInteractions()) {
            for (Participant participant : interaction2.getParticipants()) {
                if (!participant.hasInteraction()) continue;
                participantInteractions.add(participant.getInteraction());
            }
        }
        for (Interaction interaction2 : entry.getInteractions()) {
            if (participantInteractions.contains(interaction2)) continue;
            this.processInteraction(interaction2, avail, pro, false);
        }
    }

    private Provenance createProvenance(Source source) {
        String sourceUri;
        Provenance pro = null;
        String name = null;
        PublicationXref px = null;
        UnificationXref ux = null;
        if (source.hasNames()) {
            name = this.getName(source.getNames());
        }
        if (source.hasXref()) {
            ux = this.getPrimaryUnificationXref(source.getXref());
            if (name == null) {
                name = ux.getDb() + "_" + ux.getId();
            }
        }
        if (source.hasBibref()) {
            px = this.getPublicationXref(source.getBibref().getXref());
            if (name == null) {
                name = px.getDb() + "_" + px.getId();
            }
        }
        String ver = null;
        if (source.hasReleaseDate()) {
            ver = source.getRelease();
            if (name == null) {
                name = ver;
            }
        }
        if ((pro = (Provenance)this.bpModel.getByID(sourceUri = name != null ? this.xmlBase + "Provenance_" + this.encode(name) : this.genUri(Provenance.class, this.bpModel))) == null) {
            pro = this.bpModel.addNew(Provenance.class, sourceUri);
            if (name != null) {
                pro.setDisplayName(name);
            }
            if (px != null) {
                pro.addXref(px);
            }
            if (ux != null) {
                pro.addXref(ux);
            }
            if (source.hasAttributes()) {
                for (Attribute attr : source.getAttributes()) {
                    pro.addComment(attr.toString());
                }
            }
            if (ver != null) {
                pro.addComment("Release Date: " + ver);
            }
        }
        return pro;
    }

    private Entity processInteraction(Interaction interaction2, Set<String> avail, Provenance pro, boolean isComplex) {
        Entity bpEntity = null;
        String name = null;
        String shortName = null;
        if (interaction2.hasNames()) {
            Names names = interaction2.getNames();
            name = names.hasFullName() ? names.getFullName() : "";
            shortName = names.hasShortLabel() ? names.getShortLabel() : "";
        }
        HashSet<Entity> bpParticipants = new HashSet<Entity>();
        for (Participant participant : interaction2.getParticipants()) {
            Entity entity2 = this.createParticipant(participant, interaction2, avail, pro);
            if (entity2 == null) continue;
            bpParticipants.add(entity2);
            this.participantMap.put(participant, entity2);
        }
        HashSet<InteractionVocabulary> interactionVocabularies = new HashSet<InteractionVocabulary>();
        if (interaction2.hasInteractionTypes()) {
            for (CvType cvType : interaction2.getInteractionTypes()) {
                InteractionVocabulary cv = this.findOrCreateControlledVocabulary(cvType, InteractionVocabulary.class);
                if (cv == null) continue;
                interactionVocabularies.add(cv);
            }
        }
        boolean isGeneticInteraction = false;
        if (interaction2.hasAttributes()) {
            for (Attribute attribute : interaction2.getAttributes()) {
                String value;
                if (!attribute.getName().equalsIgnoreCase(BIOGRID_EVIDENCE_CODE) || !GENETIC_INTERACTIONS.contains(value = attribute.hasValue() ? attribute.getValue().toLowerCase() : "")) continue;
                isGeneticInteraction = true;
            }
        }
        HashSet<Evidence> hashSet = new HashSet<Evidence>();
        if (interaction2.hasExperiments()) {
            for (ExperimentDescription experimentDescription : interaction2.getExperiments()) {
                hashSet.add(this.createEvidence(interaction2, experimentDescription));
            }
        }
        if (!isGeneticInteraction) {
            isGeneticInteraction = this.isGeneticInteraction(hashSet);
        }
        HashSet<Class<? extends BioPAXElement>> participantTypes = new HashSet<Class<? extends BioPAXElement>>();
        for (Entity p : bpParticipants) {
            participantTypes.add(p.getModelInterface());
        }
        if (participantTypes.size() > 1 && participantTypes.contains(Gene.class)) {
            isGeneticInteraction = false;
            LOG.warn("Skipped a gene-notgene interaction; psimi-id=" + interaction2.getId() + ", name(s): " + shortName + " " + name + "; participants: " + participantTypes);
            return null;
        }
        bpEntity = (isComplex || this.forceInteractionToComplex) && !isGeneticInteraction ? this.createComplex(bpParticipants, hashSet) : (isGeneticInteraction ? this.createGeneticInteraction(bpParticipants, hashSet, interactionVocabularies) : this.createMolecularInteraction(bpParticipants, hashSet, interactionVocabularies));
        this.addAvailabilityAndProvenance(bpEntity, avail, pro);
        if (name != null) {
            bpEntity.setStandardName(name);
        }
        if (shortName != null) {
            bpEntity.setDisplayName(shortName);
        }
        HashSet<Xref> bpXrefs = new HashSet<Xref>();
        if (interaction2.hasXref()) {
            bpXrefs.addAll(this.getXrefs(interaction2.getXref()));
        }
        for (Xref bpXref : bpXrefs) {
            bpEntity.addXref(bpXref);
        }
        return bpEntity;
    }

    private void addAvailabilityAndProvenance(Entity bpEntity, Set<String> avail, Provenance pro) {
        if (pro != null) {
            bpEntity.addDataSource(pro);
        }
        if (avail != null) {
            for (String a : avail) {
                bpEntity.addAvailability(a);
            }
        }
    }

    private Entity createParticipant(Participant participant, Interaction interaction2, Set<String> avail, Provenance pro) {
        Entity entity2;
        UnificationXref primaryXrefOfInteractor;
        Interactor interactor = null;
        if (participant.hasInteractor()) {
            interactor = participant.getInteractor();
        } else if (participant.hasInteraction()) {
            Complex c = (Complex)this.processInteraction(participant.getInteraction(), avail, pro, true);
            return c;
        }
        if (interactor == null) {
            LOG.error("EntryMapper.createParticipant(): interactor cannot be found; participant: " + participant.toString());
            return null;
        }
        String physicalEntityType = null;
        InteractorType interactorType = interactor.getInteractorType();
        if (interactorType != null && interactorType.hasNames()) {
            physicalEntityType = this.getName(interactorType.getNames());
        }
        String name = null;
        String shortName = null;
        HashSet<String> synonyms = new HashSet<String>();
        Names psiNames = interactor.getNames();
        if (psiNames != null) {
            name = psiNames.hasFullName() ? psiNames.getFullName() : null;
            String string = shortName = psiNames.hasShortLabel() ? psiNames.getShortLabel() : null;
            if (psiNames.hasAliases()) {
                for (Alias alias : psiNames.getAliases()) {
                    if (!alias.hasValue()) continue;
                    synonyms.add(alias.getValue());
                }
            }
        }
        Set<Xref> bpXrefsOfInteractor = this.getXrefs(interactor.getXref());
        CellularLocationVocabulary cellularLocation = null;
        if (interactor.hasOrganism() && interactor.getOrganism().hasCompartment()) {
            cellularLocation = this.findOrCreateControlledVocabulary(interactor.getOrganism().getCompartment(), CellularLocationVocabulary.class);
        }
        EntityReference entityReference = null;
        Class entityClass = Protein.class;
        Class entityReferenceClass = ProteinReference.class;
        if ("small molecule".equalsIgnoreCase(physicalEntityType)) {
            entityClass = SmallMolecule.class;
            entityReferenceClass = SmallMoleculeReference.class;
        } else if ("dna".equalsIgnoreCase(physicalEntityType)) {
            entityClass = Dna.class;
            entityReferenceClass = DnaReference.class;
        } else if ("rna".equalsIgnoreCase(physicalEntityType)) {
            entityClass = Rna.class;
            entityReferenceClass = RnaReference.class;
        } else if ("gene".equalsIgnoreCase(physicalEntityType)) {
            entityClass = Gene.class;
            entityReferenceClass = null;
        }
        String baseUri = this.xmlBase;
        if (entityReferenceClass != null) {
            baseUri = baseUri + entityReferenceClass.getSimpleName() + "_";
        }
        baseUri = (primaryXrefOfInteractor = this.getPrimaryUnificationXref(interactor.getXref())) != null ? baseUri + this.encode(primaryXrefOfInteractor.getDb() + "_" + primaryXrefOfInteractor.getId()) : baseUri + "_" + this.counter++;
        String entityUri = baseUri + "_" + entityClass.getSimpleName();
        if (cellularLocation != null) {
            entityUri = entityUri + "_" + this.encode(cellularLocation.getTerm().iterator().next());
        }
        if ((entity2 = (Entity)this.bpModel.getByID(entityUri)) != null) {
            this.addAvailabilityAndProvenance(entity2, avail, pro);
            return entity2;
        }
        entity2 = (Entity)this.bpModel.addNew(entityClass, entityUri);
        this.addAvailabilityAndProvenance(entity2, avail, pro);
        if (name != null) {
            if (name.length() > 50 && shortName != null) {
                entity2.addComment(name);
            } else {
                entity2.setStandardName(name);
            }
        }
        if (shortName != null) {
            entity2.setDisplayName(shortName);
        }
        if (cellularLocation != null && entity2 instanceof PhysicalEntity) {
            ((PhysicalEntity)entity2).setCellularLocation(cellularLocation);
        }
        if (entityReferenceClass != null) {
            EntityReference er = (EntityReference)this.bpModel.getByID(baseUri);
            if (er != null) {
                entityReference = er;
            } else {
                entityReference = (EntityReference)this.bpModel.addNew(entityReferenceClass, baseUri);
                if (name != null) {
                    if (name.length() > 50 && (shortName != null || synonyms != null && !synonyms.isEmpty())) {
                        entityReference.addComment(name);
                    } else {
                        entityReference.setStandardName(name);
                    }
                }
                if (shortName != null) {
                    entityReference.setDisplayName(shortName);
                }
                if (synonyms != null) {
                    for (String synonym : synonyms) {
                        entityReference.addName(synonym);
                    }
                }
                if (bpXrefsOfInteractor != null) {
                    for (Xref xref2 : bpXrefsOfInteractor) {
                        entityReference.addXref(xref2);
                    }
                }
                if (entityReference instanceof SequenceEntityReference) {
                    SequenceEntityReference ser = (SequenceEntityReference)entityReference;
                    ser.setOrganism(this.getBioSource(interactor.getOrganism()));
                    ser.setSequence(interactor.getSequence());
                }
            }
            ((SimplePhysicalEntity)entity2).setEntityReference(entityReference);
        } else {
            assert (entity2 instanceof Gene) : "Must be Gene instead: " + entity2.getModelInterface().getSimpleName();
            if (synonyms != null) {
                for (String synonym : synonyms) {
                    entity2.addName(synonym);
                }
            }
            if (bpXrefsOfInteractor != null) {
                for (Xref xref3 : bpXrefsOfInteractor) {
                    entity2.addXref(xref3);
                }
            }
            ((Gene)entity2).setOrganism(this.getBioSource(interactor.getOrganism()));
        }
        return entity2;
    }

    private void addFeatures(ExperimentalForm ef, Collection<Feature> psiFeatureList) {
        if (psiFeatureList == null || psiFeatureList.isEmpty()) {
            return;
        }
        for (Feature psiFeature : psiFeatureList) {
            Class<ModificationFeature> featureClass;
            ModificationFeature feature;
            if (psiFeature == null || (feature = this.getFeature(featureClass = ModificationFeature.class, psiFeature)) == null) continue;
            ef.addExperimentalFeature(feature);
        }
    }

    private Set<SequenceInterval> getSequenceLocation(Collection<Range> rangeList) {
        HashSet<SequenceInterval> toReturn = new HashSet<SequenceInterval>();
        for (Range range : rangeList) {
            Interval endInterval;
            Interval beginInterval = range.hasBeginInterval() ? range.getBeginInterval() : null;
            Interval interval = endInterval = range.hasEndInterval() ? range.getEndInterval() : null;
            if (beginInterval == null) continue;
            toReturn.add(this.getSequenceLocation(beginInterval.getBegin(), beginInterval.getEnd()));
            if (endInterval == null) continue;
            toReturn.add(this.getSequenceLocation(endInterval.getBegin(), endInterval.getEnd()));
        }
        return toReturn;
    }

    private BioSource getBioSource(Organism organism) {
        BioSource toReturn;
        if (organism == null) {
            return null;
        }
        CellVocabulary cellType = this.findOrCreateControlledVocabulary(organism.getCellType(), CellVocabulary.class);
        TissueVocabulary tissue = this.findOrCreateControlledVocabulary(organism.getTissue(), TissueVocabulary.class);
        String ncbiId = Integer.toString(organism.getNcbiTaxId());
        String uri = this.xmlBase + "BioSource_" + "taxonomy_" + ncbiId;
        if (tissue != null && !tissue.getTerm().isEmpty()) {
            uri = uri + "_" + this.encode(tissue.getTerm().iterator().next());
        }
        if (cellType != null && !cellType.getTerm().isEmpty()) {
            uri = uri + "_" + this.encode(cellType.getTerm().iterator().next());
        }
        if ((toReturn = (BioSource)this.bpModel.getByID(uri)) != null) {
            return toReturn;
        }
        toReturn = this.bpModel.addNew(BioSource.class, uri);
        String taxonXrefUri = this.xmlBase + "UX_taxonomy_" + ncbiId;
        UnificationXref taxonXref = (UnificationXref)this.bpModel.getByID(taxonXrefUri);
        if (taxonXref == null) {
            taxonXref = this.bpModel.addNew(UnificationXref.class, taxonXrefUri);
            taxonXref.setDb("Taxonomy");
            taxonXref.setId(ncbiId);
        }
        toReturn.addXref(taxonXref);
        if (cellType != null) {
            toReturn.setCellType(cellType);
        }
        if (tissue != null) {
            toReturn.setTissue(tissue);
        }
        if (organism.hasNames()) {
            toReturn.setStandardName(this.getName(organism.getNames()));
        }
        return toReturn;
    }

    private <T extends ControlledVocabulary> T findOrCreateControlledVocabulary(CvType cvType, Class<T> bpCvClass) {
        if (cvType == null) {
            return null;
        }
        String term = null;
        if (cvType.hasNames()) {
            term = this.getName(cvType.getNames());
        }
        UnificationXref bpXref = this.getPrimaryUnificationXref(cvType.getXref());
        T toReturn = this.findOrCreateControlledVocabulary(term, bpXref, bpCvClass);
        return toReturn;
    }

    private <T extends ControlledVocabulary> T findOrCreateControlledVocabulary(String term, UnificationXref bpXref, Class<T> bpCvClass) {
        String uri = this.xmlBase + bpCvClass.getSimpleName() + "_" + this.encode(term != null && !term.isEmpty() ? term : bpXref.getDb() + "_" + bpXref.getId());
        ControlledVocabulary toReturn = (ControlledVocabulary)this.bpModel.getByID(uri);
        if (toReturn != null) {
            return (T)toReturn;
        }
        toReturn = (ControlledVocabulary)this.bpModel.addNew(bpCvClass, uri);
        if (term != null) {
            toReturn.addTerm(term);
        }
        toReturn.addXref(bpXref);
        return (T)toReturn;
    }

    private Set<Xref> getXrefs(psidev.psi.mi.xml.model.Xref psiXREF) {
        HashSet<Xref> toReturn = new HashSet<Xref>();
        if (psiXREF == null) {
            return toReturn;
        }
        ArrayList<DbReference> psiDBRefList = new ArrayList<DbReference>();
        psiDBRefList.add(psiXREF.getPrimaryRef());
        if (psiXREF.hasSecondaryRef()) {
            psiDBRefList.addAll(psiXREF.getSecondaryRef());
        }
        for (DbReference psiDBRef : psiDBRefList) {
            if (psiDBRef == null) continue;
            String refType = psiDBRef.hasRefType() ? psiDBRef.getRefType() : null;
            String refTypeAc = psiDBRef.hasRefTypeAc() ? psiDBRef.getRefTypeAc() : null;
            String psiDBRefId = psiDBRef.getId();
            String psiDBRefDb = psiDBRef.getDb();
            for (String dbRefId : psiDBRefId.split(",")) {
                Xref bpXref = null;
                bpXref = "identity".equals(refType) || "identical object".equals(refType) ? this.unificationXref(psiDBRefDb, dbRefId) : ("secondary-ac".equals(refType) ? this.unificationXref(psiDBRefDb, dbRefId) : (!"pubmed".equalsIgnoreCase(psiDBRefDb) ? this.relationshipXref(psiDBRefDb, dbRefId, refType, refTypeAc) : this.publicationXref(psiDBRefDb, dbRefId)));
                if (bpXref == null) continue;
                toReturn.add(bpXref);
            }
        }
        return toReturn;
    }

    private UnificationXref getPrimaryUnificationXref(psidev.psi.mi.xml.model.Xref psiXref) {
        if (psiXref == null || psiXref.getPrimaryRef() == null) {
            return null;
        }
        DbReference psiDBRef = psiXref.getPrimaryRef();
        UnificationXref toReturn = null;
        String refType = psiDBRef.hasRefType() ? psiDBRef.getRefType() : null;
        String psiDBRefId = psiDBRef.getId();
        if (refType == null || "identity".equals(refType) || "identical object".equals(refType)) {
            toReturn = this.unificationXref(psiDBRef.getDb(), psiDBRefId);
        }
        return toReturn;
    }

    private UnificationXref unificationXref(String db, String id) {
        String xuri = this.xmlBase + "UX_" + this.encode(db.toLowerCase() + "_" + id);
        UnificationXref x = (UnificationXref)this.bpModel.getByID(xuri);
        if (x == null) {
            x = this.bpModel.addNew(UnificationXref.class, xuri);
            x.setDb(db);
            x.setId(id);
        }
        return x;
    }

    private PublicationXref publicationXref(String db, String id) {
        String xuri = this.xmlBase + "PX_" + this.encode(db.toLowerCase() + "_" + id);
        PublicationXref x = (PublicationXref)this.bpModel.getByID(xuri);
        if (x == null) {
            x = this.bpModel.addNew(PublicationXref.class, xuri);
            x.setDb(db);
            x.setId(id);
        }
        return x;
    }

    private PublicationXref getPublicationXref(psidev.psi.mi.xml.model.Xref psiXREF) {
        if (psiXREF == null) {
            return null;
        }
        DbReference psiDBRef = psiXREF.getPrimaryRef();
        if (psiDBRef == null) {
            return null;
        }
        return this.publicationXref(psiDBRef.getDb(), psiDBRef.getId());
    }

    private String encode(String id) {
        try {
            return URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return URLEncoder.encode(id);
        }
    }

    private Set<EvidenceCodeVocabulary> getEvidenceCodes(ExperimentDescription experimentDescription) {
        HashSet<EvidenceCodeVocabulary> toReturn = new HashSet<EvidenceCodeVocabulary>();
        HashSet<CvType> cvTypeSet = new HashSet<CvType>(3);
        cvTypeSet.add(experimentDescription.getInteractionDetectionMethod());
        cvTypeSet.add(experimentDescription.getParticipantIdentificationMethod());
        cvTypeSet.add(experimentDescription.getFeatureDetectionMethod());
        for (CvType cvtype : cvTypeSet) {
            EvidenceCodeVocabulary ecv = this.findOrCreateControlledVocabulary(cvtype, EvidenceCodeVocabulary.class);
            if (ecv == null) continue;
            toReturn.add(ecv);
        }
        return toReturn;
    }

    private Score getScoreOrConfidence(Confidence psiConfidence) {
        String unitName;
        if (psiConfidence == null) {
            return null;
        }
        String value = psiConfidence.getValue();
        Unit ocv = psiConfidence.getUnit();
        HashSet<Xref> bpXrefs = new HashSet<Xref>();
        if (ocv != null && ocv.getXref() != null) {
            bpXrefs.addAll(this.getXrefs(ocv.getXref()));
        }
        HashSet<String> comments = new HashSet<String>();
        if (ocv != null && ocv.getNames() != null && (unitName = this.getName(ocv.getNames())) != null) {
            comments.add(unitName);
        }
        if (ocv.hasAttributes()) {
            comments.addAll(this.getAttributes(ocv.getAttributes()));
        }
        Score ret = this.createScore(value, bpXrefs, comments);
        return ret;
    }

    private Set<String> getAttributes(Collection<Attribute> attributes) {
        HashSet<String> toReturn = new HashSet<String>();
        for (Attribute attribute : attributes) {
            String name;
            String attributeStr = "";
            if (attribute.hasValue()) {
                attributeStr = attribute.getValue();
            }
            String string = attributeStr = (name = attribute.getName()) != null ? (attributeStr = attributeStr + " " + name) : attributeStr;
            if (attribute.hasNameAc()) {
                attributeStr = attributeStr + " " + attribute.getNameAc();
            }
            if (attributeStr.length() <= 0) continue;
            toReturn.add(attributeStr);
        }
        return toReturn;
    }

    private Set<ExperimentalForm> getExperimentalForms(Interaction interaction2, ExperimentDescription experimentDescription) {
        HashSet<ExperimentalForm> experimentalForms = new HashSet<ExperimentalForm>();
        for (Participant participant : interaction2.getParticipants()) {
            Entity bpParticipant = this.participantMap.get(participant);
            assert (bpParticipant != null) : "participantMap has now entry for a psimi participant key";
            if (!participant.hasExperimentalRoles()) continue;
            for (ExperimentalRole experimentalRole : participant.getExperimentalRoles()) {
                if (experimentalRole.hasExperiments() && !experimentalRole.getExperiments().contains(experimentDescription)) continue;
                ExperimentalFormVocabulary efv = this.findOrCreateControlledVocabulary(experimentalRole, ExperimentalFormVocabulary.class);
                String efUri = this.genUri(ExperimentalForm.class, this.bpModel) + "_e" + experimentDescription.getId() + "_i" + interaction2.getId();
                ExperimentalForm experimentalForm2 = this.bpModel.addNew(ExperimentalForm.class, efUri);
                experimentalForm2.addExperimentalFormDescription(efv);
                experimentalForm2.setExperimentalFormEntity(bpParticipant);
                experimentalForms.add(experimentalForm2);
                this.addFeatures(experimentalForm2, participant.getFeatures());
            }
        }
        return experimentalForms;
    }

    private String getName(Names name) {
        if (name.hasFullName()) {
            return name.getFullName();
        }
        if (name.hasShortLabel()) {
            return name.getShortLabel();
        }
        return null;
    }

    private RelationshipXref relationshipXref(String db, String id, String refType, String refTypeAc) {
        String uri = this.xmlBase + "RX_";
        uri = refType != null && !refType.isEmpty() ? uri + this.encode(db.toLowerCase() + "_" + id + "_" + refType) : uri + this.encode(db.toLowerCase() + "_" + id);
        RelationshipXref x = (RelationshipXref)this.bpModel.getByID(uri);
        if (x == null) {
            x = this.bpModel.addNew(RelationshipXref.class, uri);
            x.setDb(db);
            x.setId(id);
            if (refType != null) {
                String cvUri = refTypeAc != null ? "http://identifiers.org/psimi/" + refTypeAc : this.xmlBase + "RTV_" + this.encode(refType);
                RelationshipTypeVocabulary rtv = (RelationshipTypeVocabulary)this.bpModel.getByID(cvUri);
                if (rtv == null) {
                    rtv = this.bpModel.addNew(RelationshipTypeVocabulary.class, cvUri);
                    rtv.addTerm(refType);
                    if (refTypeAc != null && !refTypeAc.isEmpty()) {
                        UnificationXref cvx = this.bpModel.addNew(UnificationXref.class, this.genUri(UnificationXref.class, this.bpModel));
                        cvx.setDb("PSI-MI");
                        cvx.setId(refTypeAc);
                        rtv.addXref(cvx);
                    }
                }
                x.setRelationshipType(rtv);
            }
        }
        return x;
    }

    private Evidence createEvidence(Interaction interaction2, ExperimentDescription experimentDescription) {
        Set<EvidenceCodeVocabulary> evidenceCodes;
        Set<ExperimentalForm> experimentalForms;
        PublicationXref px;
        String evUri = this.genUri(Evidence.class, this.bpModel) + "_i" + interaction2.getId() + "_e" + experimentDescription.getId();
        Evidence evidence2 = this.bpModel.addNew(Evidence.class, evUri);
        if (experimentDescription.hasXref()) {
            for (Xref xref2 : this.getXrefs(experimentDescription.getXref())) {
                evidence2.addXref(xref2);
            }
        }
        if (experimentDescription.getBibref() != null && (px = this.getPublicationXref(experimentDescription.getBibref().getXref())) != null) {
            evidence2.addXref(px);
        }
        if (experimentDescription.hasNames()) {
            Names names = experimentDescription.getNames();
            if (names.hasFullName()) {
                evidence2.addComment(names.getFullName().trim());
            }
            if (names.hasShortLabel()) {
                evidence2.addComment(names.getShortLabel().trim());
            }
        }
        if (experimentDescription.hasAttributes()) {
            for (String attr : this.getAttributes(experimentDescription.getAttributes())) {
                evidence2.addComment(attr.trim());
            }
        }
        if (experimentDescription.hasHostOrganisms()) {
            for (Organism organism : experimentDescription.getHostOrganisms()) {
                evidence2.addComment("Host " + organism.toString());
            }
        }
        if (experimentDescription.hasConfidences()) {
            for (Confidence psiConfidence : experimentDescription.getConfidences()) {
                Score bpScoreOrConfidence = this.getScoreOrConfidence(psiConfidence);
                if (bpScoreOrConfidence == null) continue;
                evidence2.addConfidence(bpScoreOrConfidence);
            }
        }
        if ((experimentalForms = this.getExperimentalForms(interaction2, experimentDescription)) != null && !experimentalForms.isEmpty()) {
            for (ExperimentalForm experimentalForm2 : experimentalForms) {
                evidence2.addExperimentalForm(experimentalForm2);
            }
        }
        if ((evidenceCodes = this.getEvidenceCodes(experimentDescription)) != null) {
            for (EvidenceCodeVocabulary ecv : evidenceCodes) {
                evidence2.addEvidenceCode(ecv);
            }
        }
        return evidence2;
    }

    private Score createScore(String value, Set<? extends Xref> bpXrefs, Set<String> comments) {
        Score bpScore = this.bpModel.addNew(Score.class, this.genUri(Score.class, this.bpModel));
        if (value != null) {
            bpScore.setValue(value);
        }
        if (bpXrefs != null && !bpXrefs.isEmpty()) {
            for (Xref xref2 : bpXrefs) {
                bpScore.addXref(xref2);
            }
        }
        if (comments != null && !comments.isEmpty()) {
            for (String string : comments) {
                bpScore.addComment(string);
            }
        }
        return bpScore;
    }

    private MolecularInteraction createMolecularInteraction(Set<? extends Entity> participants, Set<Evidence> bpEvidence, Set<InteractionVocabulary> interactionVocabularies) {
        MolecularInteraction toReturn = this.bpModel.addNew(MolecularInteraction.class, this.genUri(MolecularInteraction.class, this.bpModel));
        if (participants != null && !participants.isEmpty()) {
            for (Entity entity2 : participants) {
                toReturn.addParticipant((PhysicalEntity)entity2);
            }
        }
        if (bpEvidence != null && !bpEvidence.isEmpty()) {
            for (Evidence evidence2 : bpEvidence) {
                toReturn.addEvidence(evidence2);
            }
        }
        for (InteractionVocabulary interactionVocabulary : interactionVocabularies) {
            toReturn.addInteractionType(interactionVocabulary);
        }
        return toReturn;
    }

    private GeneticInteraction createGeneticInteraction(Set<? extends Entity> participants, Set<Evidence> bpEvidence, Set<InteractionVocabulary> interactionVocabularies) {
        GeneticInteraction toReturn = this.bpModel.addNew(GeneticInteraction.class, this.genUri(GeneticInteraction.class, this.bpModel));
        if (participants != null && !participants.isEmpty()) {
            for (Entity entity2 : participants) {
                toReturn.addParticipant((Gene)entity2);
            }
        }
        if (bpEvidence != null && !bpEvidence.isEmpty()) {
            for (Evidence evidence2 : bpEvidence) {
                toReturn.addEvidence(evidence2);
            }
        }
        for (InteractionVocabulary interactionVocabulary : interactionVocabularies) {
            toReturn.addInteractionType(interactionVocabulary);
        }
        return toReturn;
    }

    private Complex createComplex(Set<? extends Entity> participants, Set<Evidence> bpEvidence) {
        Complex toReturn = this.bpModel.addNew(Complex.class, this.genUri(Complex.class, this.bpModel));
        if (participants != null && !participants.isEmpty()) {
            for (Entity entity2 : participants) {
                toReturn.addComponent((PhysicalEntity)entity2);
            }
        }
        if (bpEvidence != null && !bpEvidence.isEmpty()) {
            for (Evidence evidence2 : bpEvidence) {
                toReturn.addEvidence(evidence2);
            }
        }
        return toReturn;
    }

    private <T extends EntityFeature> T getFeature(Class<T> featureClass, Feature psiFeature) {
        String entityFeatureUri = this.genUri(featureClass, this.bpModel);
        EntityFeature entityFeature = (EntityFeature)this.bpModel.addNew(featureClass, entityFeatureUri);
        Set<SequenceInterval> featureLocations = this.getSequenceLocation(psiFeature.getRanges());
        if (featureLocations != null) {
            for (SequenceLocation sequenceLocation2 : featureLocations) {
                entityFeature.setFeatureLocation(sequenceLocation2);
            }
        }
        String term = null;
        if (psiFeature.hasNames()) {
            term = this.getName(psiFeature.getNames());
        }
        UnificationXref unificationXref2 = this.getPrimaryUnificationXref(psiFeature.getXref());
        SequenceRegionVocabulary srv = this.findOrCreateControlledVocabulary(term, unificationXref2, SequenceRegionVocabulary.class);
        entityFeature.setFeatureLocationType(srv);
        if (psiFeature.hasFeatureType() && featureClass == ModificationFeature.class) {
            SequenceModificationVocabulary smv = this.findOrCreateControlledVocabulary(psiFeature.getFeatureType(), SequenceModificationVocabulary.class);
            ((ModificationFeature)entityFeature).setModificationType(smv);
        }
        return (T)entityFeature;
    }

    private SequenceInterval getSequenceLocation(long beginSequenceInterval, long endSequenceInterval) {
        SequenceInterval toReturn = this.bpModel.addNew(SequenceInterval.class, this.genUri(SequenceInterval.class, this.bpModel));
        SequenceSite bpSequenceSiteBegin = this.bpModel.addNew(SequenceSite.class, this.genUri(SequenceSite.class, this.bpModel));
        bpSequenceSiteBegin.setSequencePosition((int)beginSequenceInterval);
        toReturn.setSequenceIntervalBegin(bpSequenceSiteBegin);
        SequenceSite bpSequenceSiteEnd = this.bpModel.addNew(SequenceSite.class, this.genUri(SequenceSite.class, this.bpModel));
        bpSequenceSiteEnd.setSequencePosition((int)endSequenceInterval);
        toReturn.setSequenceIntervalEnd(bpSequenceSiteEnd);
        return toReturn;
    }

    private boolean isGeneticInteraction(Set<Evidence> bpEvidence) {
        if (bpEvidence != null && !bpEvidence.isEmpty()) {
            for (Evidence e2 : bpEvidence) {
                Set<EvidenceCodeVocabulary> evidenceCodes = e2.getEvidenceCode();
                if (evidenceCodes == null) continue;
                for (EvidenceCodeVocabulary cv : evidenceCodes) {
                    Set<String> terms = cv.getTerm();
                    if (terms == null) continue;
                    for (String term : terms) {
                        if (!GENETIC_INTERACTIONS.contains(term.toLowerCase())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private String genUri(Class<? extends BioPAXElement> type, Model model) {
        return this.xmlBase + type.getSimpleName() + "_" + this.counter++;
    }

    static {
        GENETIC_INTERACTIONS.add("dosage growth defect");
        GENETIC_INTERACTIONS.add("dosage lethality");
        GENETIC_INTERACTIONS.add("dosage rescue");
        GENETIC_INTERACTIONS.add("negative genetic");
        GENETIC_INTERACTIONS.add("phenotypic enhancement");
        GENETIC_INTERACTIONS.add("phenotypic suppression");
        GENETIC_INTERACTIONS.add("positive genetic");
        GENETIC_INTERACTIONS.add("synthetic growth defect");
        GENETIC_INTERACTIONS.add("synthetic haploinsufficiency");
        GENETIC_INTERACTIONS.add("synthetic lethality");
        GENETIC_INTERACTIONS.add("synthetic rescue");
    }
}

