/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.StandardFilterKey;

public abstract class BasicFilterFactory {
    private String[] values;
    private final String searchField;

    public BasicFilterFactory(String searchField) {
        this.searchField = searchField;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    @Key
    public FilterKey getKey() {
        StandardFilterKey key = new StandardFilterKey();
        key.addParameter((Object)this.values);
        return key;
    }

    @Factory
    public Filter getFilter() {
        BooleanQuery query2 = new BooleanQuery();
        for (String fv : this.values) {
            String term = fv.trim();
            query2.add((Query)new TermQuery(new Term(this.searchField, term)), BooleanClause.Occur.SHOULD);
            query2.add((Query)new TermQuery(new Term(this.searchField, term.toLowerCase())), BooleanClause.Occur.SHOULD);
        }
        return new CachingWrapperFilter((Filter)new QueryWrapperFilter((Query)query2));
    }
}

