/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.miner.CommonIDFetcher;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFMiner;
import org.biopax.paxtools.pattern.miner.SIFToText;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.AdjacencyMatrix;
import org.biopax.paxtools.pattern.util.Blacklist;

public class SIFSearcher {
    private List<SIFMiner> miners;
    private Set<SIFType> types;
    private IDFetcher idFetcher;
    private Blacklist blacklist;

    public SIFSearcher(SIFType ... types) {
        this((IDFetcher)null, types);
    }

    public SIFSearcher(SIFMiner ... miners) {
        this((IDFetcher)null, miners);
    }

    public SIFSearcher(IDFetcher idFetcher, SIFType ... types) {
        this.idFetcher = idFetcher;
        this.types = new HashSet<SIFType>(Arrays.asList(types));
        if (idFetcher == null) {
            this.idFetcher = new CommonIDFetcher();
        }
    }

    public SIFSearcher(IDFetcher idFetcher, SIFMiner ... miners) {
        this.idFetcher = idFetcher;
        this.miners = Arrays.asList(miners);
        if (idFetcher == null) {
            this.idFetcher = new CommonIDFetcher();
        }
    }

    private void initMiners() {
        try {
            this.miners = new ArrayList<SIFMiner>();
            for (SIFType type : this.types) {
                for (Class<? extends SIFMiner> clazz : type.getMiners()) {
                    SIFMiner miner = clazz.newInstance();
                    miner.setBlacklist(this.blacklist);
                    miner.setIDFetcher(this.idFetcher);
                    this.miners.add(miner);
                }
            }
        }
        catch (InstantiationException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
    }

    public void setBlacklist(Blacklist blacklist) {
        this.blacklist = blacklist;
    }

    public AdjacencyMatrix searchSIFGetMatrix(Model model) {
        Set<SIFInteraction> sifInts = this.searchSIF(model);
        return new AdjacencyMatrix(SIFInteraction.convertToAdjacencyMatrix(sifInts, new SIFType[0]), SIFInteraction.getSortedGeneNames(sifInts, new SIFType[0]));
    }

    public Set<SIFInteraction> searchSIF(Model model) {
        if (this.miners == null) {
            this.initMiners();
        }
        HashMap<SIFInteraction, SIFInteraction> map = new HashMap<SIFInteraction, SIFInteraction>();
        for (SIFMiner miner : this.miners) {
            Map<BioPAXElement, List<Match>> matches2 = Searcher.search(model, miner.getPattern());
            for (List<Match> matchList : matches2.values()) {
                for (Match m : matchList) {
                    SIFInteraction sif = miner.createSIFInteraction(m, this.idFetcher);
                    if (sif == null || !sif.hasIDs() || sif.sourceID.equals(sif.targetID) || this.types != null && !this.types.contains(sif.type)) continue;
                    if (map.containsKey(sif)) {
                        SIFInteraction existing = (SIFInteraction)map.get(sif);
                        existing.mergeWith(sif);
                        continue;
                    }
                    map.put(sif, sif);
                }
            }
        }
        return new HashSet<SIFInteraction>(map.values());
    }

    public boolean searchSIF(Model model, OutputStream out) {
        return this.searchSIF(model, out, false);
    }

    public boolean searchSIF(Model model, OutputStream out, final boolean withMediators) {
        return this.searchSIF(model, out, new SIFToText(){

            @Override
            public String convert(SIFInteraction inter) {
                return inter.toString(withMediators);
            }
        });
    }

    public boolean searchSIF(Model model, OutputStream out, SIFToText stt) {
        Set<SIFInteraction> inters = this.searchSIF(model);
        if (!inters.isEmpty()) {
            ArrayList<SIFInteraction> interList = new ArrayList<SIFInteraction>(inters);
            Collections.sort(interList);
            try {
                boolean first = true;
                OutputStreamWriter writer = new OutputStreamWriter(out);
                for (SIFInteraction inter : interList) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write("\n");
                    }
                    writer.write(stt.convert(inter));
                }
                writer.close();
                return true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }
}

