/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.util.Blacklist;

public class LinkedPE
extends ConstraintAdapter {
    private Type type;
    private static PathAccessor upperGenAcc = new PathAccessor("PhysicalEntity/memberPhysicalEntityOf*");
    private static PathAccessor lowerGenAcc = new PathAccessor("PhysicalEntity/memberPhysicalEntity*");
    private static PathAccessor complexAcc = new PathAccessor("PhysicalEntity/componentOf*");
    private static PathAccessor memberAcc = new PathAccessor("Complex/component*");

    public LinkedPE(Type type) {
        this(type, null);
    }

    public LinkedPE(Type type, Blacklist blacklist) {
        super(2, blacklist);
        this.type = type;
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        PhysicalEntity pe = (PhysicalEntity)match.get(ind[0]);
        Set<BioPAXElement> set = this.getLinkedElements(pe);
        return set;
    }

    public Set<BioPAXElement> getLinkedElements(PhysicalEntity pe) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        set.add(pe);
        this.enrichWithGenerics(set, set);
        return set;
    }

    protected void enrichWithGenerics(Set<BioPAXElement> seed, Set<BioPAXElement> all) {
        Set addition = this.access(upperGenAcc, seed, all);
        addition.addAll(this.access(lowerGenAcc, seed, all));
        all.addAll(addition);
        seed.addAll(addition);
        this.enrichWithCM(seed, all);
    }

    protected void enrichWithCM(Set<BioPAXElement> seed, Set<BioPAXElement> all) {
        Set addition = this.access(this.type == Type.TO_COMPLEX ? complexAcc : memberAcc, seed, all);
        if (this.blacklist != null) {
            addition = this.blacklist.getNonUbiqueObjects(addition);
        }
        if (!addition.isEmpty()) {
            all.addAll(addition);
            this.enrichWithGenerics(addition, all);
        }
    }

    protected Set access(PathAccessor pa, Set<BioPAXElement> seed, Set<BioPAXElement> all) {
        Set set = pa.getValueFromBeans((Collection<? extends BioPAXElement>)seed);
        set.removeAll(all);
        if (this.blacklist == null) {
            return set;
        }
        return this.blacklist.getNonUbiqueObjects(set);
    }

    public static enum Type {
        TO_COMPLEX,
        TO_MEMBER;

    }
}

