/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.io.sif.level3.ChangeType;
import org.biopax.paxtools.io.sif.level3.GroupMap;
import org.biopax.paxtools.io.sif.level3.Grouper;
import org.biopax.paxtools.io.sif.level3.PEStateChange;
import org.biopax.paxtools.io.sif.level3.Simplify;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;

public class ActivityNetworkAnalyzer {
    private static final Log log = LogFactory.getLog(ActivityNetworkAnalyzer.class);
    Map<BioPAXElement, Set<PEStateChange>> stateChangeMap;
    Map<Conversion, Set<EntityReference>> extendedControls;
    private static final Control EXTENDED = BioPAXLevel.L3.getDefaultFactory().create(Control.class, "http://biopax.org/generated/ExtendedControl");

    public void analyzeStates(Model model) {
        GroupMap groupMap = Grouper.inferGroups(model);
        ModelUtils.replaceEquivalentFeatures(model);
        this.stateChangeMap = new HashMap<BioPAXElement, Set<PEStateChange>>();
        this.extendedControls = new HashMap<Conversion, Set<EntityReference>>();
        for (EntityReference pr : model.getObjects(EntityReference.class)) {
            if (pr.getRDFId().startsWith("http://biopax.org/generated/fixer/normalizeGenerics/")) continue;
            Set<PEStateChange> stateChanges = this.stateChangeMap.get(pr);
            if (stateChanges == null) {
                stateChanges = new HashSet<PEStateChange>();
                this.stateChangeMap.put(pr, stateChanges);
            }
            for (SimplePhysicalEntity spe : pr.getEntityReferenceOf()) {
                this.scanInteractions(groupMap, stateChanges, pr, spe);
            }
        }
    }

    private void scanInteractions(GroupMap groupMap, Set<PEStateChange> stateChanges, EntityReference pr, PhysicalEntity spe) {
        for (Interaction interaction2 : spe.getParticipantOf()) {
            if (!(interaction2 instanceof Conversion)) continue;
            Simplify.entityHasAChange(pr, (Conversion)interaction2, groupMap, stateChanges, this.extendedControls);
        }
        for (PhysicalEntity generic : spe.getMemberPhysicalEntityOf()) {
            this.scanInteractions(groupMap, stateChanges, pr, generic);
        }
        for (Complex complex2 : spe.getComponentOf()) {
            this.scanInteractions(groupMap, stateChanges, pr, complex2);
        }
    }

    public Set<SimplePhysicalEntity> getPrecedingStates(SimplePhysicalEntity spe) {
        HashSet<SimplePhysicalEntity> result = new HashSet<SimplePhysicalEntity>();
        EntityReference er = spe.getEntityReference();
        Set<PEStateChange> peStateChanges = this.stateChangeMap.get(er);
        for (PEStateChange peStateChange : peStateChanges) {
            SimplePhysicalEntity next = peStateChange.changedInto(spe);
            if (next == null) continue;
            result.add(peStateChange.left);
        }
        return result;
    }

    public Set<PEStateChange> getAllStates(EntityReference er) {
        return this.stateChangeMap.get(er);
    }

    public Set<SimplePhysicalEntity> getSucceedingStates(SimplePhysicalEntity spe) {
        HashSet<SimplePhysicalEntity> result = new HashSet<SimplePhysicalEntity>();
        EntityReference er = spe.getEntityReference();
        Set<PEStateChange> peStateChanges = this.stateChangeMap.get(er);
        for (PEStateChange peStateChange : peStateChanges) {
            SimplePhysicalEntity next = peStateChange.changedFrom(spe);
            if (next == null) continue;
            result.add(peStateChange.left);
        }
        return result;
    }

    public void writeStateNetworkAnalysis(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        log.debug("stateChangeMap.size = " + this.stateChangeMap.values().size());
        int ineligible = 0;
        int eligible = 0;
        for (BioPAXElement bpe : this.stateChangeMap.keySet()) {
            if (bpe instanceof ProteinReference) {
                EntityReference er = (EntityReference)bpe;
                Set<PEStateChange> sc = this.stateChangeMap.get(bpe);
                for (PEStateChange sChange : sc) {
                    if (this.isEligibleProteinModification(sChange)) {
                        Set<Pathway> pathwayComponentOf = sChange.getConv().getPathwayComponentOf();
                        for (Pathway pathway2 : pathwayComponentOf) {
                            String s = pathway2.getName().toString();
                            if (s.isEmpty()) {
                                log.debug("Empty name pathway = " + pathway2);
                            }
                            writer.write(s + ";");
                        }
                        writer.write("\t");
                        writer.write(sChange.getConv().getName().toString());
                        writer.write("\t");
                        writer.write(er.getName().toString());
                        writer.write("\t");
                        writer.write(er.getXref().toString());
                        writer.write("\t");
                        writer.write(this.printControls(this.getDeltaControl(sChange)));
                        writer.write("\t");
                        writer.write(sChange.getDeltaFeatures().toString());
                        writer.write("\t");
                        writer.write(sChange.getControllersAsString());
                        writer.write("\n");
                        ++eligible;
                        continue;
                    }
                    ++ineligible;
                }
                continue;
            }
            log.debug("bpe = " + bpe);
        }
        log.debug("ineligible = " + ineligible);
        log.debug("eligible = " + eligible);
        ((Writer)writer).flush();
    }

    private Map<Control, Boolean> getDeltaControl(PEStateChange sChange) {
        Map<Control, Boolean> dc = sChange.getDeltaControls();
        if (!dc.isEmpty() || sChange.getRight() == null) {
            return dc;
        }
        PhysicalEntity rightRoot = sChange.getRightRoot();
        for (PEStateChange next : this.stateChangeMap.get(sChange.getRight().getEntityReference())) {
            if (!this.nextFollows(rightRoot, next)) continue;
            dc = next.getDeltaControls();
        }
        if (dc.isEmpty()) {
            dc = new HashMap<Control, Boolean>();
            HashSet<SimplePhysicalEntity> partners = new HashSet<SimplePhysicalEntity>();
            Simplify.getSimpleMembers(rightRoot, partners);
            for (SimplePhysicalEntity partner : partners) {
                for (PEStateChange next : this.stateChangeMap.get(partner.getEntityReference())) {
                    Set<EntityReference> xC;
                    if (!this.nextFollows(rightRoot, next) || (xC = this.extendedControls.get(next.getConv())) == null || !xC.contains(sChange.getRight().getEntityReference())) continue;
                    log.debug("extended");
                    dc.put(EXTENDED, false);
                }
            }
        }
        return dc;
    }

    private boolean nextFollows(PhysicalEntity rightRoot, PEStateChange next) {
        return next != null && next.getLeftRoot() != null && next.getLeftRoot().equals(rightRoot);
    }

    private String printControls(Map<Control, Boolean> dc) {
        StringBuilder ctString = new StringBuilder();
        for (Control control2 : dc.keySet()) {
            Boolean direction = dc.get(control2);
            ctString.append(direction != false ? "Lost activity:" : "Gained activity").append(":").append((Object)control2.getControlType());
            for (Process process2 : control2.getControlled()) {
                ctString.append(process2.getName()).append(" ,");
            }
            ctString.append("; ");
        }
        return ctString.toString();
    }

    private boolean isEligibleProteinModification(PEStateChange sChange) {
        for (EntityFeature ef : sChange.getDeltaFeatures().keySet()) {
            if (!(ef instanceof ModificationFeature) || sChange.getDeltaFeatures().get(ef).equals((Object)ChangeType.UNCHANGED)) continue;
            return true;
        }
        return false;
    }

    static {
        EXTENDED.setControlType(ControlType.ACTIVATION);
        EXTENDED.addName("Inferred from complex binding");
    }
}

