/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.faster;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.ArrayBunch;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.HashedTripleBunch;
import com.hp.hpl.jena.mem.MatchOrBind;
import com.hp.hpl.jena.mem.NodeToTriplesMapBase;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.mem.faster.ProcessedTriple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;

public class NodeToTriplesMapFaster
extends NodeToTriplesMapBase {
    public NodeToTriplesMapFaster(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        super(indexField, f2, f3);
    }

    public boolean add(Triple t) {
        Object o = this.getIndexField(t);
        TripleBunch s = this.bunchMap.get(o);
        if (s == null) {
            s = new ArrayBunch();
            this.bunchMap.put(o, s);
        }
        if (s.contains(t)) {
            return false;
        }
        if (s.size() == 9 && s instanceof ArrayBunch) {
            s = new HashedTripleBunch(s);
            this.bunchMap.put(o, s);
        }
        s.add(t);
        ++this.size;
        return true;
    }

    public boolean remove(Triple t) {
        Object o = this.getIndexField(t);
        TripleBunch s = this.bunchMap.get(o);
        if (s == null || !s.contains(t)) {
            return false;
        }
        s.remove(t);
        --this.size;
        if (s.size() == 0) {
            this.bunchMap.remove(o);
        }
        return true;
    }

    public Iterator iterator(Object o, HashCommon.NotifyEmpty container2) {
        TripleBunch s = this.bunchMap.get(o);
        return s == null ? NullIterator.instance : s.iterator(container2);
    }

    public boolean contains(Triple t) {
        TripleBunch s = this.bunchMap.get(this.getIndexField(t));
        return s == null ? false : s.contains(t);
    }

    public boolean containsBySameValueAs(Triple t) {
        TripleBunch s = this.bunchMap.get(this.getIndexField(t));
        return s == null ? false : s.containsBySameValueAs(t);
    }

    public ExtendedIterator iterator(Node index, Node n2, Node n32) {
        Object indexValue = index.getIndexingValue();
        TripleBunch s = this.bunchMap.get(indexValue);
        return s == null ? NullIterator.instance : this.f2.filterOn(n2).and(this.f3.filterOn(n32)).filterKeep(s.iterator(new NotifyMe(indexValue)));
    }

    public Applyer createFixedOApplyer(final ProcessedTriple Q) {
        final TripleBunch ss = this.bunchMap.get(Q.O.node.getIndexingValue());
        if (ss == null) {
            return Applyer.empty;
        }
        return new Applyer(){
            final MatchOrBind x;
            {
                this.x = MatchOrBind.createSP(Q);
            }

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                ss.app(d, next, this.x.reset(d));
            }
        };
    }

    public Applyer createBoundOApplyer(final ProcessedTriple pt) {
        return new Applyer(){
            final MatchOrBind x;
            {
                this.x = MatchOrBind.createSP(pt);
            }

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                TripleBunch c = NodeToTriplesMapFaster.this.bunchMap.get(pt.O.finder(d).getIndexingValue());
                if (c != null) {
                    c.app(d, next, this.x.reset(d));
                }
            }
        };
    }

    public Applyer createBoundSApplyer(final ProcessedTriple pt) {
        return new Applyer(){
            final MatchOrBind x;
            {
                this.x = MatchOrBind.createPO(pt);
            }

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                TripleBunch c = NodeToTriplesMapFaster.this.bunchMap.get(pt.S.finder(d));
                if (c != null) {
                    c.app(d, next, this.x.reset(d));
                }
            }
        };
    }

    public Applyer createFixedSApplyer(final ProcessedTriple Q) {
        final TripleBunch ss = this.bunchMap.get(Q.S.node);
        if (ss == null) {
            return Applyer.empty;
        }
        return new Applyer(){
            final MatchOrBind x;
            {
                this.x = MatchOrBind.createPO(Q);
            }

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                ss.app(d, next, this.x.reset(d));
            }
        };
    }

    protected TripleBunch get(Object index) {
        return this.bunchMap.get(index);
    }

    public Iterator iteratorForIndexed(Object y) {
        return this.get(y).iterator();
    }

    public class NotifyMe
    implements HashCommon.NotifyEmpty {
        protected final Object key;

        public NotifyMe(Object key) {
            this.key = key;
        }

        public void emptied() {
            NodeToTriplesMapFaster.this.bunchMap.remove(this.key);
        }
    }
}

