### R code from vignette source 'Vignette.Rnw'

###################################################
### code chunk number 1: Vignette.Rnw:67-70
###################################################
library(oposSOM)
env <- opossom.new(list(dataset.name="Tissues",
                        dim.1stLvlSom=20))


###################################################
### code chunk number 2: Vignette.Rnw:77-81
###################################################
data(opossom.tissues)
str(opossom.tissues, vec.len=3)

env$indata <- opossom.tissues


###################################################
### code chunk number 3: Vignette.Rnw:87-94
###################################################
data(opossom.tissues)

library(Biobase)
opossom.tissues.eset = ExpressionSet(assayData=opossom.tissues)
opossom.tissues.eset

env$indata <- opossom.tissues.eset


###################################################
### code chunk number 4: Vignette.Rnw:104-113
###################################################
env$group.labels <- c(rep("Homeostasis", 2),
                          "Endocrine",
                          "Digestion",
                          "Exocrine",
                          "Epithelium",
                          "Reproduction",
                          "Muscle",
                      rep("Immune System", 2),
                      rep("Nervous System", 2) )


###################################################
### code chunk number 5: Vignette.Rnw:115-124
###################################################
env$group.colors <- c(rep("gold", 2),
                          "red2",
                          "brown",
                          "purple",
                          "cyan",
                          "pink",
                          "green2",
                      rep("blue2", 2),
                      rep("gray", 2) )


###################################################
### code chunk number 6: Vignette.Rnw:130-152
###################################################
group.info <- data.frame( 
                  group.labels = c(rep("Homeostasis", 2),
                                       "Endocrine",
                                       "Digestion",
                                       "Exocrine",
                                       "Epithelium",
                                       "Reproduction",
                                       "Muscle",
                                   rep("Immune System", 2),
                                   rep("Nervous System", 2) ),

                  group.colors = c(rep("gold", 2),
                                       "red2",
                                       "brown",
                                       "purple",
                                       "cyan",
                                       "pink",
                                       "green2",
                                   rep("blue2", 2),
                                   rep("gray", 2) ),
													
                  row.names=colnames(opossom.tissues))


###################################################
### code chunk number 7: Vignette.Rnw:154-159
###################################################
opossom.tissues.eset = ExpressionSet(assayData=opossom.tissues,
                                     phenoData=AnnotatedDataFrame(group.info) )
opossom.tissues.eset

env$indata <- opossom.tissues.eset


###################################################
### code chunk number 8: Vignette.Rnw:169-170
###################################################
# opossom.run(env)


###################################################
### code chunk number 9: Vignette.Rnw:301-306
###################################################
env$preferences$pairwise.comparison.list <-
    list(list(c("liver","kidney cortex"),
              c("accumbens","cerebral cortex")),
         list(c("tongue"),
              c("accumbens","cerebral cortex")))


###################################################
### code chunk number 10: Vignette.Rnw:346-347
###################################################
sessionInfo()


