/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLLiteralImpl
extends OWLObjectImpl
implements OWLLiteral {
    private String literal;
    private OWLDatatype datatype;
    private String lang;

    public OWLLiteralImpl(OWLDataFactory dataFactory, String literal, OWLDatatype datatype) {
        super(dataFactory);
        this.literal = literal;
        this.datatype = datatype;
        this.lang = "";
    }

    public OWLLiteralImpl(OWLDataFactory dataFactory, String literal, String lang) {
        super(dataFactory);
        this.literal = literal;
        this.lang = lang;
        this.datatype = dataFactory.getRDFPlainLiteral();
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.datatype.equals(this.getOWLDataFactory().getRDFPlainLiteral());
    }

    @Override
    public boolean hasLang() {
        return !this.lang.equals("");
    }

    @Override
    public boolean isInteger() {
        return this.datatype.equals(this.getOWLDataFactory().getIntegerOWLDatatype());
    }

    @Override
    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.literal);
    }

    @Override
    public boolean isBoolean() {
        return this.datatype.equals(this.getOWLDataFactory().getBooleanOWLDatatype());
    }

    @Override
    public boolean parseBoolean() throws NumberFormatException {
        if (this.literal.equals("0")) {
            return false;
        }
        if (this.literal.equals("1")) {
            return true;
        }
        if (this.literal.equals("true")) {
            return true;
        }
        if (this.literal.equals("false")) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isDouble() {
        return this.datatype.equals(this.getOWLDataFactory().getDoubleOWLDatatype());
    }

    @Override
    public double parseDouble() throws NumberFormatException {
        return Double.parseDouble(this.literal);
    }

    @Override
    public boolean isFloat() {
        return this.datatype.equals(this.getOWLDataFactory().getFloatOWLDatatype());
    }

    @Override
    public float parseFloat() throws NumberFormatException {
        return Float.parseFloat(this.literal);
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasLang(String lang) {
        return this.lang != null && this.lang.equalsIgnoreCase(lang.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            return this.literal.equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.lang.equals(other.getLang());
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.literal.compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }
}

