/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.file;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.ebi.ontocat.AbstractOntologyService;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.file.OntologyLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOntologyService
extends AbstractOntologyService
implements OntologyService {
    private static final Logger log = Logger.getLogger(FileOntologyService.class.getName());
    protected final OWLOntology ontology;
    protected Set<String> ontoAccessions = new HashSet<String>();
    private String synonymSlot = "altLabel";
    private Matcher regexDropSyns = Pattern.compile("\"?([^\"]*)").matcher("");
    public String definitionSlot = "definition";
    private String labelSlot = "prefLabel";
    private URI uriOntology;
    private final Map<String, OWLEntity> cache = new TreeMap<String, OWLEntity>();
    protected OntologyLoader loader;

    public URI getOntologyUri() {
        return this.uriOntology;
    }

    public void setSynonymSlot(String synonymSlot) {
        this.synonymSlot = synonymSlot;
    }

    public void setDefinitionSlot(String definitionSlot) {
        this.definitionSlot = definitionSlot;
    }

    public void setLabelSlot(String labelSlot) {
        this.labelSlot = labelSlot;
    }

    public FileOntologyService(URI uriOntology, String ontologyAccession) throws OntologyServiceException {
        this(uriOntology);
        this.ontoAccessions.add(ontologyAccession);
    }

    public FileOntologyService(URI uriOntology) throws OntologyServiceException {
        this.loader = new OntologyLoader(uriOntology);
        this.ontology = this.loader.getOntology();
        for (OWLEntity ent : this.ontology.getSignature()) {
            if (ent.isOWLClass() || ent.isOWLNamedIndividual()) {
                this.cache.put(this.getFragment(ent), ent);
            }
            try {
                this.ontoAccessions.add(this.getOntologyAccession(ent));
            }
            catch (OntologyServiceException e) {
                log.error(e.getMessage());
            }
        }
        this.ontoAccessions.add(uriOntology.toString());
        this.ontoAccessions.add(this.ontology.getOntologyID().toString().replaceFirst("^<", "").replaceFirst(">$", ""));
        this.ontoAccessions.add(this.loader.getManager().getOntologyDocumentIRI(this.ontology).toString());
        this.uriOntology = uriOntology;
    }

    @Override
    public List<Ontology> getOntologies() throws OntologyServiceException {
        return new ArrayList<Ontology>(){
            private static final long serialVersionUID = 1L;
            {
                String ontologyAccession = FileOntologyService.this.ontology.getOntologyID().toString();
                ontologyAccession = ontologyAccession.replaceFirst("^<", "").replaceFirst(">$", "");
                this.add(new Ontology(ontologyAccession));
            }
        };
    }

    @Override
    public Ontology getOntology(String ontologyAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return null;
        }
        return this.getOntologies().get(0);
    }

    @Override
    public Map<String, Set<OntologyTerm>> getRelations(String ontologyAccession, String termAccession) throws OntologyServiceException {
        throw new UnsupportedOperationException("Not implemented. Use ReasonedFileOntologyService");
    }

    @Override
    public List<OntologyTerm> getRootTerms(String ontologyAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        ArrayList<OntologyTerm> rootTerms = new ArrayList<OntologyTerm>();
        for (OWLEntity ent : this.cache.values()) {
            if (!ent.isOWLClass()) continue;
            OWLClass cls = ent.asOWLClass();
            if (this.getParents(this.getTerm(ent)).size() != 0 || this.getAnnotations(cls).containsKey("is_obsolete")) continue;
            rootTerms.add(this.getTerm(cls));
        }
        return rootTerms;
    }

    @Override
    public List<String> getSynonyms(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        Map<String, List<String>> annots = this.getAnnotations(ontologyAccession, termAccession);
        return this.findAnnotations(annots, this.synonymSlot, "synonym", "alternative_term", "altLabel");
    }

    @Override
    public List<String> getDefinitions(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        Map<String, List<String>> annots = this.getAnnotations(ontologyAccession, termAccession);
        return this.findAnnotations(annots, this.definitionSlot, "def");
    }

    private List<String> findAnnotations(Map<String, List<String>> annots, String ... Names) {
        HashSet<String> result = new HashSet<String>();
        for (String name : Names) {
            List<String> temp = annots.get(name);
            if (temp == null) continue;
            result.addAll(this.dropQuotes(temp));
        }
        return new ArrayList<String>(result);
    }

    private List<String> dropQuotes(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String val : list) {
            this.regexDropSyns.reset(val).find();
            result.add(this.regexDropSyns.group(1));
        }
        return result;
    }

    @Override
    public OntologyTerm getTerm(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (ontologyAccession != null && !this.ontoAccessions.contains(ontologyAccession)) {
            return null;
        }
        return this.getTerm(termAccession);
    }

    @Override
    public OntologyTerm getTerm(String termAccession) throws OntologyServiceException {
        return this.getTerm(this.getOwlEntity(termAccession));
    }

    protected OntologyTerm getTerm(OWLEntity ent) throws OntologyServiceException {
        if (ent == null) {
            return null;
        }
        String ontologyAccession = this.getOntologyAccession(ent);
        String termAccession = this.getFragment(ent);
        String label = this.getLabel(ent);
        URI uri = ent.getIRI().toURI();
        return new OntologyTerm(ontologyAccession, termAccession, label, uri);
    }

    private String getOntologyAccession(OWLEntity ent) throws OntologyServiceException {
        Pattern pattern = Pattern.compile("^.*[//#]{1}");
        Matcher matcher = pattern.matcher(ent.toStringID());
        if (matcher.find()) {
            return matcher.group();
        }
        throw new OntologyServiceException("Could not create ontologyAccession for " + ent);
    }

    @Override
    public List<OntologyTerm> getTermPath(String ontologyAccession, String termAccession) throws OntologyServiceException {
        ArrayList<OntologyTerm> termPath = new ArrayList<OntologyTerm>();
        int iteration = 0;
        OntologyTerm term = this.getTerm(ontologyAccession, termAccession);
        termPath.add(term);
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return termPath;
        }
        List<OntologyTerm> parents = this.getParents(ontologyAccession, termAccession);
        while (parents.size() != 0) {
            term = parents.get(0);
            termPath.add(term);
            parents = this.getParents(term.getOntologyAccession(), term.getAccession());
            if (iteration++ <= 100) continue;
            log.error("getTermPath(): TOO MANY ITERATIONS (" + iteration + "x)");
            break;
        }
        Collections.reverse(termPath);
        return termPath;
    }

    @Override
    public List<OntologyTerm> getChildren(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        ArrayList<OntologyTerm> list = new ArrayList<OntologyTerm>();
        OWLEntity ent = this.getOwlEntity(termAccession);
        if (ent == null) {
            return Collections.emptyList();
        }
        if (ent.isOWLClass()) {
            for (OWLClassExpression desc : ent.asOWLClass().getSubClasses(this.ontology)) {
                if (desc.isAnonymous()) continue;
                list.add(this.getTerm(desc.asOWLClass()));
            }
        }
        return list;
    }

    @Override
    public List<OntologyTerm> getParents(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        ArrayList<OntologyTerm> list = new ArrayList<OntologyTerm>();
        OWLEntity ent = this.getOwlEntity(termAccession);
        if (ent == null) {
            return Collections.emptyList();
        }
        if (ent.isOWLClass()) {
            for (OWLClassExpression desc : ent.asOWLClass().getSuperClasses(this.ontology)) {
                if (desc.isAnonymous()) continue;
                list.add(this.getTerm(desc.asOWLClass()));
            }
        }
        if (ent.isOWLNamedIndividual()) {
            for (OWLClassExpression desc : ent.asOWLNamedIndividual().getTypes(this.ontology)) {
                if (desc.isAnonymous()) continue;
                list.add(this.getTerm(desc.asOWLClass()));
            }
        }
        return list;
    }

    @Override
    public Set<OntologyTerm> getAllTerms(String ontologyAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptySet();
        }
        HashSet<OntologyTerm> result = new HashSet<OntologyTerm>();
        for (OWLEntity ent : this.cache.values()) {
            result.add(this.getTerm(ent));
        }
        return result;
    }

    @Override
    public String makeLookupHyperlink(String termAccession) {
        try {
            return this.getOwlEntity(termAccession).toStringID();
        }
        catch (OntologyServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String makeLookupHyperlink(String ontologyAccession, String termAccession) {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return null;
        }
        try {
            return this.getOwlEntity(termAccession).toStringID();
        }
        catch (OntologyServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<OntologyTerm> searchAll(String query, OntologyService.SearchOptions ... options) throws OntologyServiceException {
        ArrayList<OntologyService.SearchOptions> ops = new ArrayList<OntologyService.SearchOptions>(Arrays.asList(options));
        HashMap<OntologyTerm, String> terms = new HashMap<OntologyTerm, String>();
        query = query.toLowerCase();
        for (OWLEntity ent : this.cache.values()) {
            this.resolveOptionsAndMatch(terms, query, this.getLabel(ent), ent, ops);
        }
        if (ops.contains((Object)OntologyService.SearchOptions.INCLUDE_PROPERTIES)) {
            for (OWLEntity ent : this.cache.values()) {
                for (List<String> annots : this.getAnnotations(ent).values()) {
                    for (String annot : annots) {
                        this.resolveOptionsAndMatch(terms, query, annot, ent, ops);
                    }
                }
            }
        }
        return this.injectTermContext(terms, query, options);
    }

    private Map<OntologyTerm, String> resolveOptionsAndMatch(Map<OntologyTerm, String> terms, String query, String value, OWLEntity ent, List<OntologyService.SearchOptions> options) throws OntologyServiceException {
        if (value.toLowerCase().contains(query)) {
            if (!options.contains((Object)OntologyService.SearchOptions.EXACT)) {
                terms.put(this.getTerm(ent), value);
            } else if (value.equalsIgnoreCase(query)) {
                terms.put(this.getTerm(ent), value);
            }
        }
        return terms;
    }

    @Override
    public List<OntologyTerm> searchOntology(String ontologyAccession, String query, OntologyService.SearchOptions ... options) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        return this.searchAll(query, options);
    }

    protected OWLEntity getOwlEntity(String termAccession) throws OntologyServiceException {
        OWLEntity result = this.cache.get(termAccession);
        if (result == null) {
            result = this.cache.get(termAccession.replace(":", "_"));
        }
        return result;
    }

    @Override
    public Map<String, List<String>> getAnnotations(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyMap();
        }
        return this.getAnnotations(this.getOwlEntity(termAccession));
    }

    private Map<String, List<String>> getAnnotations(OWLEntity ent) {
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        if (ent == null) {
            return Collections.emptyMap();
        }
        for (OWLAnnotation annot : ent.getAnnotations(this.ontology)) {
            String key = this.getFragment(annot.getProperty().getIRI().toURI());
            List value = null;
            value = metadata.containsKey(key) ? (List)metadata.get(key) : new ArrayList();
            List<String> arr = value;
            if (annot.getValue() instanceof OWLLiteral) {
                arr.add(((OWLLiteral)annot.getValue()).getLiteral());
            }
            metadata.put(key, arr);
        }
        return metadata;
    }

    protected String getFragment(OWLEntity ent) {
        return this.getFragment(ent.getIRI().toURI());
    }

    private String getFragment(URI uri) {
        Pattern pattern = Pattern.compile("[^//#=]*$");
        Matcher matcher = pattern.matcher(uri.toString());
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    protected String getLabel(OWLEntity ent) throws OntologyServiceException {
        Map<String, List<String>> clsAnnotations = this.getAnnotations(ent);
        List<String> labels1 = null;
        List<String> labels2 = null;
        if (clsAnnotations != null) {
            labels1 = clsAnnotations.get(this.labelSlot);
            labels2 = clsAnnotations.get("label");
        }
        if (labels1 != null) {
            if (labels1.size() != 1) {
                log.warn("Multple labels found on " + ent);
            }
            return labels1.get(0);
        }
        if (labels2 != null) {
            if (labels2.size() != 1) {
                log.warn("Multple labels found on " + ent);
            }
            return labels2.get(0);
        }
        return this.getFragment(ent);
    }
}

