/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultNode<E extends OWLObject>
implements Node<E> {
    private Set<E> entities = new HashSet(4);

    public DefaultNode(E entity) {
        this.entities.add(entity);
    }

    public DefaultNode(Set<E> entities) {
        this.entities.addAll(entities);
    }

    protected DefaultNode() {
    }

    protected abstract E getTopEntity();

    protected abstract E getBottomEntity();

    public void add(E entity) {
        this.entities.add(entity);
    }

    @Override
    public boolean isTopNode() {
        return this.entities.contains(this.getTopEntity());
    }

    @Override
    public boolean isBottomNode() {
        return this.entities.contains(this.getBottomEntity());
    }

    @Override
    public Set<E> getEntities() {
        return this.entities;
    }

    @Override
    public int getSize() {
        return this.entities.size();
    }

    @Override
    public boolean contains(E entity) {
        return this.entities.contains(entity);
    }

    @Override
    public Set<E> getEntitiesMinus(E E) {
        HashSet<E> result = new HashSet<E>(this.entities);
        result.remove(E);
        return result;
    }

    @Override
    public Set<E> getEntitiesMinusTop() {
        return this.getEntitiesMinus(this.getTopEntity());
    }

    @Override
    public Set<E> getEntitiesMinusBottom() {
        return this.getEntitiesMinus(this.getBottomEntity());
    }

    @Override
    public boolean isSingleton() {
        return this.entities.size() == 1;
    }

    @Override
    public E getRepresentativeElement() {
        if (this.entities.size() > 0) {
            return (E)((OWLObject)this.entities.iterator().next());
        }
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node( ");
        for (OWLObject entity : this.entities) {
            sb.append(entity);
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return ((Object)this.entities).equals(other.getEntities());
    }

    public int hashCode() {
        return ((Object)this.entities).hashCode();
    }
}

