/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.TupleIndex;

public class ExtensionTableWithTupleIndexes
extends ExtensionTable {
    private static final long serialVersionUID = -684536236157965372L;
    protected final TupleIndex[] m_tupleIndexes;
    protected final Object[] m_auxiliaryTuple;

    public ExtensionTableWithTupleIndexes(Tableau tableau, int n, boolean bl, TupleIndex[] tupleIndexArray) {
        super(tableau, n, bl);
        this.m_tupleIndexes = tupleIndexArray;
        this.m_auxiliaryTuple = new Object[this.m_tupleArity];
    }

    public int sizeInMemory() {
        int n = this.m_tupleTable.sizeInMemory();
        for (int i = this.m_tupleIndexes.length - 1; i >= 0; --i) {
            n += this.m_tupleIndexes[i].sizeInMemoy();
        }
        return n;
    }

    public boolean addTuple(Object[] objectArray, DependencySet dependencySet, boolean bl) {
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.addFactStarted(objectArray, bl);
        }
        if (!(!this.isTupleActive(objectArray) || !this.m_tableau.m_needsThingExtension && AtomicConcept.THING.equals(objectArray[0]) || !this.m_tableau.m_needsRDFSLiteralExtension && InternalDatatype.RDFS_LITERAL.equals(objectArray[0]))) {
            int n = this.m_tupleTable.getFirstFreeTupleIndex();
            int n2 = this.m_tupleIndexes[0].addTuple(objectArray, n);
            if (n2 == n) {
                for (int i = 1; i < this.m_tupleIndexes.length; ++i) {
                    this.m_tupleIndexes[i].addTuple(objectArray, n2);
                }
                this.m_tupleTable.addTuple(objectArray);
                this.m_dependencySetManager.setDependencySet(n2, dependencySet);
                this.m_coreManager.setCore(n2, bl);
                this.m_afterDeltaNewTupleIndex = this.m_tupleTable.getFirstFreeTupleIndex();
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.addFactFinished(objectArray, bl, true);
                }
                this.postAdd(objectArray, dependencySet, n2, bl);
                return true;
            }
            if (bl && !this.m_coreManager.isCore(n2)) {
                this.m_coreManager.addCore(n2);
                Object object = objectArray[0];
                if (object instanceof Concept) {
                    this.m_tableau.m_existentialExpansionStrategy.assertionCoreSet((Concept)object, (Node)objectArray[1]);
                } else if (object instanceof AtomicRole) {
                    this.m_tableau.m_existentialExpansionStrategy.assertionCoreSet((AtomicRole)object, (Node)objectArray[1], (Node)objectArray[2]);
                }
            }
        }
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.addFactFinished(objectArray, bl, false);
        }
        return false;
    }

    public boolean containsTuple(Object[] objectArray) {
        int n = this.m_tupleIndexes[0].getTupleIndex(objectArray);
        return n != -1 && this.isTupleActive(n);
    }

    public DependencySet getDependencySet(Object[] objectArray) {
        int n = this.m_tupleIndexes[0].getTupleIndex(objectArray);
        if (n == -1) {
            return null;
        }
        return this.m_dependencySetManager.getDependencySet(n);
    }

    public boolean isCore(Object[] objectArray) {
        int n = this.m_tupleIndexes[0].getTupleIndex(objectArray);
        if (n == -1) {
            return false;
        }
        return this.m_coreManager.isCore(n);
    }

    public ExtensionTable.Retrieval createRetrieval(int[] nArray, Object[] objectArray, Object[] objectArray2, boolean bl, ExtensionTable.View view) {
        TupleIndex tupleIndex = null;
        int n = 0;
        for (int i = this.m_tupleIndexes.length - 1; i >= 0; --i) {
            int[] nArray2 = this.m_tupleIndexes[i].getIndexingSequence();
            int n2 = 0;
            for (int j = 0; j < nArray2.length && nArray[nArray2[j]] != -1; ++j) {
                ++n2;
            }
            if (n2 <= n) continue;
            tupleIndex = this.m_tupleIndexes[i];
            n = n2;
        }
        if (tupleIndex == null) {
            return new ExtensionTable.UnindexedRetrieval(nArray, objectArray, objectArray2, bl, view);
        }
        return new IndexedRetrieval(tupleIndex, nArray, objectArray, objectArray2, bl, view);
    }

    protected void removeTuple(int n) {
        this.m_tupleTable.retrieveTuple(this.m_auxiliaryTuple, n);
        for (int i = this.m_tupleIndexes.length - 1; i >= 0; --i) {
            this.m_tupleIndexes[i].removeTuple(this.m_auxiliaryTuple);
        }
        this.postRemove(this.m_auxiliaryTuple, n);
    }

    public void clear() {
        super.clear();
        for (int i = this.m_tupleIndexes.length - 1; i >= 0; --i) {
            this.m_tupleIndexes[i].clear();
        }
    }

    protected static int[] createSelectionArray(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray2.length && nArray[nArray2[i]] != -1; ++i) {
            ++n;
        }
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    protected class IndexedRetrieval
    extends TupleIndex.TupleIndexRetrieval
    implements ExtensionTable.Retrieval,
    Serializable {
        private static final long serialVersionUID = 2180748099314801734L;
        protected final int[] m_bindingPositions;
        protected final Object[] m_tupleBuffer;
        protected final boolean m_ownsBuffers;
        protected final ExtensionTable.View m_extensionView;
        protected final boolean m_checkTupleSelection;
        protected DependencySet m_dependencySet;
        protected boolean m_isCore;
        protected int m_firstTupleIndex;
        protected int m_afterLastTupleIndex;

        public IndexedRetrieval(TupleIndex tupleIndex, int[] nArray, Object[] objectArray, Object[] objectArray2, boolean bl, ExtensionTable.View view) {
            super(tupleIndex, objectArray, ExtensionTableWithTupleIndexes.createSelectionArray(nArray, tupleIndex.m_indexingSequence));
            this.m_ownsBuffers = bl;
            this.m_bindingPositions = nArray;
            this.m_extensionView = view;
            this.m_tupleBuffer = objectArray2;
            int n = 0;
            for (int i = this.m_bindingPositions.length - 1; i >= 0; --i) {
                if (this.m_bindingPositions[i] == -1) continue;
                ++n;
            }
            this.m_checkTupleSelection = n > this.m_selectionIndices.length;
        }

        public ExtensionTable getExtensionTable() {
            return ExtensionTableWithTupleIndexes.this;
        }

        public ExtensionTable.View getExtensionView() {
            return this.m_extensionView;
        }

        public void clear() {
            if (this.m_ownsBuffers) {
                int n;
                for (n = this.m_bindingsBuffer.length - 1; n >= 0; --n) {
                    this.m_bindingsBuffer[n] = null;
                }
                for (n = this.m_tupleBuffer.length - 1; n >= 0; --n) {
                    this.m_tupleBuffer[n] = null;
                }
            }
        }

        public int[] getBindingPositions() {
            return this.m_bindingPositions;
        }

        public Object[] getBindingsBuffer() {
            return this.m_bindingsBuffer;
        }

        public Object[] getTupleBuffer() {
            return this.m_tupleBuffer;
        }

        public DependencySet getDependencySet() {
            return this.m_dependencySet;
        }

        public boolean isCore() {
            return this.m_isCore;
        }

        public void open() {
            switch (this.m_extensionView) {
                case EXTENSION_THIS: {
                    this.m_firstTupleIndex = 0;
                    this.m_afterLastTupleIndex = ExtensionTableWithTupleIndexes.this.m_afterExtensionThisTupleIndex;
                    break;
                }
                case EXTENSION_OLD: {
                    this.m_firstTupleIndex = 0;
                    this.m_afterLastTupleIndex = ExtensionTableWithTupleIndexes.this.m_afterExtensionOldTupleIndex;
                    break;
                }
                case DELTA_OLD: {
                    this.m_firstTupleIndex = ExtensionTableWithTupleIndexes.this.m_afterExtensionOldTupleIndex;
                    this.m_afterLastTupleIndex = ExtensionTableWithTupleIndexes.this.m_afterExtensionThisTupleIndex;
                    break;
                }
                case TOTAL: {
                    this.m_firstTupleIndex = 0;
                    this.m_afterLastTupleIndex = ExtensionTableWithTupleIndexes.this.m_afterDeltaNewTupleIndex;
                }
            }
            super.open();
            while (!this.afterLast()) {
                int n = this.getCurrentTupleIndex();
                if (this.m_firstTupleIndex <= n && n < this.m_afterLastTupleIndex) {
                    ExtensionTableWithTupleIndexes.this.m_tupleTable.retrieveTuple(this.m_tupleBuffer, n);
                    if (this.isTupleValid()) {
                        this.m_dependencySet = ExtensionTableWithTupleIndexes.this.m_dependencySetManager.getDependencySet(n);
                        this.m_isCore = ExtensionTableWithTupleIndexes.this.m_coreManager.isCore(n);
                        return;
                    }
                }
                super.next();
            }
        }

        public void next() {
            super.next();
            while (!this.afterLast()) {
                int n = this.getCurrentTupleIndex();
                if (this.m_firstTupleIndex <= n && n < this.m_afterLastTupleIndex) {
                    ExtensionTableWithTupleIndexes.this.m_tupleTable.retrieveTuple(this.m_tupleBuffer, n);
                    if (this.isTupleValid()) {
                        this.m_dependencySet = ExtensionTableWithTupleIndexes.this.m_dependencySetManager.getDependencySet(n);
                        this.m_isCore = ExtensionTableWithTupleIndexes.this.m_coreManager.isCore(n);
                        return;
                    }
                }
                super.next();
            }
        }

        protected boolean isTupleValid() {
            if (!ExtensionTableWithTupleIndexes.this.isTupleActive(this.m_tupleBuffer)) {
                return false;
            }
            if (this.m_checkTupleSelection) {
                for (int i = this.m_bindingPositions.length - 1; i >= 0; --i) {
                    if (this.m_bindingPositions[i] == -1 || this.m_tupleBuffer[i].equals(this.m_bindingsBuffer[this.m_bindingPositions[i]])) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

