/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.InterningManager;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Term;

public class AtomicRole
extends Role
implements DLPredicate {
    private static final long serialVersionUID = 3766087788313643809L;
    protected final String m_iri;
    protected static InterningManager<AtomicRole> s_interningManager = new InterningManager<AtomicRole>(){

        @Override
        protected boolean equal(AtomicRole atomicRole, AtomicRole atomicRole2) {
            return atomicRole.m_iri.equals(atomicRole2.m_iri);
        }

        @Override
        protected int getHashCode(AtomicRole atomicRole) {
            return atomicRole.m_iri.hashCode();
        }
    };
    public static final AtomicRole TOP_OBJECT_ROLE = AtomicRole.create("http://www.w3.org/2002/07/owl#topObjectProperty");
    public static final AtomicRole BOTTOM_OBJECT_ROLE = AtomicRole.create("http://www.w3.org/2002/07/owl#bottomObjectProperty");
    public static final AtomicRole TOP_DATA_ROLE = AtomicRole.create("http://www.w3.org/2002/07/owl#topDataProperty");
    public static final AtomicRole BOTTOM_DATA_ROLE = AtomicRole.create("http://www.w3.org/2002/07/owl#bottomDataProperty");

    protected AtomicRole(String string) {
        this.m_iri = string;
    }

    public String getIRI() {
        return this.m_iri;
    }

    public int getArity() {
        return 2;
    }

    public Role getInverse() {
        if (this == TOP_OBJECT_ROLE || this == BOTTOM_OBJECT_ROLE) {
            return this;
        }
        return InverseRole.create(this);
    }

    public Atom getRoleAssertion(Term term, Term term2) {
        return Atom.create(this, term, term2);
    }

    public String toString(Prefixes prefixes) {
        return prefixes.abbreviateIRI(this.m_iri);
    }

    protected Object readResolve() {
        return s_interningManager.intern(this);
    }

    public static AtomicRole create(String string) {
        return s_interningManager.intern(new AtomicRole(string));
    }
}

