/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.floatnum;

import java.util.Collection;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.floatnum.FloatInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntireFloatSubset
implements ValueSpaceSubset {
    @Override
    public boolean hasCardinalityAtLeast(int n) {
        int n2 = FloatInterval.subtractIntervalSizeFrom(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, n);
        return n2 <= 1;
    }

    @Override
    public boolean containsDataValue(Object object) {
        assert (object instanceof Float);
        return true;
    }

    @Override
    public void enumerateDataValues(Collection<Object> collection) {
        collection.add(Float.valueOf(Float.NaN));
        float f = Float.NEGATIVE_INFINITY;
        while (!FloatInterval.areIdentical(f, Float.POSITIVE_INFINITY)) {
            collection.add(Float.valueOf(f));
            f = FloatInterval.nextFloat(f);
        }
        collection.add(Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public String toString() {
        return "xsd:float";
    }
}

