/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.datetime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTime {
    public static final int NO_TIMEZONE = Integer.MAX_VALUE;
    public static final long MAX_TIME_ZONE_CORRECTION = 50400000L;
    protected static final Pattern s_dateTimePattern = Pattern.compile("(-?[0-9]{4,})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})([.]([0-9]{1,3}))?((Z)|(([+]|-)([0-9]{2}):([0-9]{2})))?");
    protected static final int YEAR_GROUP = 1;
    protected static final int MONTH_GROUP = 2;
    protected static final int DAY_GROUP = 3;
    protected static final int HOUR_GROUP = 4;
    protected static final int MINUTE_GROUP = 5;
    protected static final int SECOND_WHOLE_GROUP = 6;
    protected static final int SECOND_FRACTION_GROUP = 8;
    protected static final int TZ_OFFSET_GROUP = 9;
    protected static final int TZ_OFFSET_Z_GROUP = 10;
    protected static final int TZ_OFFSET_SIGN_GROUP = 12;
    protected static final int TZ_OFFSET_HOUR_GROUP = 13;
    protected static final int TZ_OFFSET_MINUTE_GROUP = 14;
    protected final long m_timeOnTimeline;
    protected final boolean m_lastDayInstant;
    protected final int m_timeZoneOffset;

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.m_timeOnTimeline = this.getTimeOnTimelineRaw(n, n2, n3, n4, n5, n6, n7) - (n8 == Integer.MAX_VALUE ? 0L : (long)n8 * 60L * 1000L);
        this.m_lastDayInstant = n4 == 24 && n5 == 0 && n6 == 0 && n7 == 0;
        this.m_timeZoneOffset = n8;
    }

    public DateTime(long l, boolean bl, int n) {
        this.m_timeOnTimeline = l;
        this.m_lastDayInstant = bl;
        this.m_timeZoneOffset = n;
    }

    public String toString() {
        long l = this.m_timeOnTimeline;
        if (this.m_timeZoneOffset != Integer.MAX_VALUE) {
            l += (long)this.m_timeZoneOffset * 60L * 1000L;
        }
        int n = (int)(l % 86400000L);
        long l2 = l / 86400000L;
        if (n < 0) {
            --l2;
            assert ((n += 86400000) >= 0);
        }
        int n2 = n % 1000;
        int n3 = (n /= 1000) % 60;
        int n4 = (int)((long)(n /= 60) % 60L);
        int n5 = (int)((long)(n /= 60) % 24L);
        int n6 = (int)(l2 / 367L);
        if (n6 >= 0) {
            while (l2 >= DateTime.daysToYearStart(n6 + 1)) {
                ++n6;
            }
            l2 -= DateTime.daysToYearStart(n6);
        } else {
            while (l2 < DateTime.daysToYearStart(n6 - 1)) {
                --n6;
            }
            l2 -= DateTime.daysToYearStart(--n6);
        }
        int n7 = 1;
        int n8 = DateTime.daysInMonth(n6, n7);
        while (l2 > (long)n8) {
            l2 -= (long)n8;
            n8 = DateTime.daysInMonth(n6, ++n7);
        }
        int n9 = (int)l2 + 1;
        if (n9 == 0) {
            if (--n7 == 0) {
                n7 = 12;
                --n6;
            }
            n9 = DateTime.daysInMonth(n6, n7);
        }
        if (this.m_lastDayInstant) {
            assert (n5 == 0 && n4 == 0 && n3 == 0 && n2 == 0);
            n5 = 24;
            if (--n9 <= 0) {
                if (--n7 <= 0) {
                    n7 = 12;
                    --n6;
                }
                n9 = DateTime.daysInMonth(n6, n7);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPadded(stringBuffer, n6, 4);
        stringBuffer.append('-');
        this.appendPadded(stringBuffer, n7, 2);
        stringBuffer.append('-');
        this.appendPadded(stringBuffer, n9, 2);
        stringBuffer.append('T');
        this.appendPadded(stringBuffer, n5, 2);
        stringBuffer.append(':');
        this.appendPadded(stringBuffer, n4, 2);
        stringBuffer.append(':');
        this.appendPadded(stringBuffer, n3, 2);
        if (n2 > 0) {
            stringBuffer.append('.');
            this.appendPadded(stringBuffer, n2, 3);
        }
        if (this.m_timeZoneOffset != Integer.MAX_VALUE) {
            if (this.m_timeZoneOffset == 0) {
                stringBuffer.append('Z');
            } else {
                int n10;
                if (this.m_timeZoneOffset > 0) {
                    stringBuffer.append('+');
                    n10 = this.m_timeZoneOffset;
                } else {
                    stringBuffer.append('-');
                    n10 = -this.m_timeZoneOffset;
                }
                int n11 = n10 / 60;
                int n12 = n10 % 60;
                this.appendPadded(stringBuffer, n11, 2);
                stringBuffer.append(':');
                this.appendPadded(stringBuffer, n12, 2);
            }
        }
        return stringBuffer.toString();
    }

    public long getTimeOnTimeline() {
        return this.m_timeOnTimeline;
    }

    public boolean hasTimeZoneOffset() {
        return this.m_timeZoneOffset != Integer.MAX_VALUE;
    }

    public int getTimeZoneOffset() {
        return this.m_timeZoneOffset;
    }

    protected void appendPadded(StringBuffer stringBuffer, int n, int n2) {
        if (n < 0) {
            stringBuffer.append('-');
        }
        String string = String.valueOf(Math.abs(n));
        for (int i = n2 - string.length(); i > 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    public static DateTime parse(String string) {
        Matcher matcher = s_dateTimePattern.matcher(string.trim());
        if (!matcher.matches()) {
            return null;
        }
        try {
            int n;
            int n2;
            int n3 = Integer.parseInt(matcher.group(1));
            int n4 = Integer.parseInt(matcher.group(2));
            int n5 = Integer.parseInt(matcher.group(3));
            int n6 = Integer.parseInt(matcher.group(4));
            int n7 = Integer.parseInt(matcher.group(5));
            int n8 = Integer.parseInt(matcher.group(6));
            String string2 = matcher.group(8);
            if (string2 != null) {
                while (string2.length() < 3) {
                    string2 = string2 + '0';
                }
                n2 = Integer.parseInt(string2);
            } else {
                n2 = 0;
            }
            if (n3 < -9999 || n3 > 9999 || n4 <= 0 || n4 > 12 || n5 <= 0 || n5 > DateTime.daysInMonth(n3, n4) || n6 < 0 || n6 > 24 || n6 == 24 && (n7 != 0 || n8 != 0 || n2 != 0) || n7 < 0 || n7 >= 60 || n8 < 0 || n8 >= 60 || n2 < 0 || n2 >= 1000) {
                return null;
            }
            if (matcher.group(9) == null) {
                n = Integer.MAX_VALUE;
            } else if (matcher.group(10) != null) {
                n = 0;
            } else {
                int n9 = "-".equals(matcher.group(12)) ? -1 : 1;
                int n10 = Integer.parseInt(matcher.group(13));
                int n11 = Integer.parseInt(matcher.group(14));
                if (n10 < 0 || n10 > 14 || n10 == 14 && n11 != 0 || n11 < 0 || n11 >= 60) {
                    return null;
                }
                n = n9 * (n10 * 60 + n11);
            }
            return new DateTime(n3, n4, n5, n6, n7, n8, n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        DateTime dateTime = (DateTime)object;
        return this.m_timeOnTimeline == dateTime.m_timeOnTimeline && this.m_lastDayInstant == dateTime.m_lastDayInstant && this.m_timeZoneOffset == dateTime.m_timeZoneOffset;
    }

    public int hashCode() {
        return (int)(this.m_timeOnTimeline * 3L + (long)this.m_timeZoneOffset + (this.m_lastDayInstant ? 117L : 0L));
    }

    protected long getTimeOnTimelineRaw(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        long l = n - 1;
        long l2 = 31536000L * l;
        l2 += 86400L * (l / 400L - l / 100L + l / 4L);
        for (int i = 1; i < n2; ++i) {
            l2 += 86400L * (long)DateTime.daysInMonth(n, i);
        }
        l2 += 86400L * (long)(n3 - 1);
        l2 += 3600L * (long)n4 + 60L * (long)n5 + (long)n6;
        l2 = l2 * 1000L + (long)n7;
        return l2;
    }

    protected static long daysToYearStart(int n) {
        long l = n - 1;
        return 365L * l + l / 400L - l / 100L + l / 4L;
    }

    protected static int daysInMonth(int n, int n2) {
        if (n2 == 2) {
            if (n % 4 != 0 || n % 100 == 0 && n % 400 != 0) {
                return 28;
            }
            return 29;
        }
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        return 31;
    }

    public static boolean isLastDayInstant(long l) {
        return l % 86400000L == 0L;
    }

    public static boolean secondsAreZero(long l) {
        return l % 60000L == 0L;
    }

    public static int getMinutesInDay(long l) {
        return (int)(l / 60000L % 1440L);
    }
}

