/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.AbstractInternalsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalsImpl
extends AbstractInternalsImpl {
    protected Set<OWLImportsDeclaration> importsDeclarations;
    protected Set<OWLAnnotation> ontologyAnnotations;
    protected Map<AxiomType<?>, Set<OWLAxiom>> axiomsByType;
    protected Map<OWLAxiom, Set<OWLAxiom>> logicalAxiom2AnnotatedAxiomMap;
    protected Set<OWLClassAxiom> generalClassAxioms;
    protected Set<OWLSubPropertyChainOfAxiom> propertyChainSubPropertyAxioms;
    protected Map<OWLClass, Set<OWLAxiom>> owlClassReferences;
    protected Map<OWLObjectProperty, Set<OWLAxiom>> owlObjectPropertyReferences;
    protected Map<OWLDataProperty, Set<OWLAxiom>> owlDataPropertyReferences;
    protected Map<OWLNamedIndividual, Set<OWLAxiom>> owlIndividualReferences;
    protected Map<OWLAnonymousIndividual, Set<OWLAxiom>> owlAnonymousIndividualReferences;
    protected Map<OWLDatatype, Set<OWLAxiom>> owlDatatypeReferences;
    protected Map<OWLAnnotationProperty, Set<OWLAxiom>> owlAnnotationPropertyReferences;
    protected Map<OWLEntity, Set<OWLDeclarationAxiom>> declarationsByEntity;

    public InternalsImpl() {
        this.initMaps();
    }

    protected void initMaps() {
        this.importsDeclarations = CollectionFactory.createSet();
        this.ontologyAnnotations = CollectionFactory.createSet();
        this.axiomsByType = this.createMap();
        this.logicalAxiom2AnnotatedAxiomMap = this.createMap();
        this.generalClassAxioms = CollectionFactory.createSet();
        this.propertyChainSubPropertyAxioms = CollectionFactory.createSet();
        this.owlClassReferences = this.createMap();
        this.owlObjectPropertyReferences = this.createMap();
        this.owlDataPropertyReferences = this.createMap();
        this.owlIndividualReferences = this.createMap();
        this.owlAnonymousIndividualReferences = this.createMap();
        this.owlDatatypeReferences = this.createMap();
        this.owlAnnotationPropertyReferences = this.createMap();
        this.declarationsByEntity = this.createMap();
    }

    @Override
    public boolean isDeclared(OWLDeclarationAxiom ax) {
        return this.declarationsByEntity.containsKey(ax.getEntity());
    }

    @Override
    public boolean isEmpty() {
        for (Set<OWLAxiom> axiomSet : this.axiomsByType.values()) {
            if (axiomSet.isEmpty()) continue;
            return false;
        }
        return this.ontologyAnnotations.isEmpty();
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype datatype) {
        Set<OWLDatatypeDefinitionAxiom> result = CollectionFactory.createSet();
        Set<OWLDatatypeDefinitionAxiom> axioms = this.getAxiomsInternal(AxiomType.DATATYPE_DEFINITION);
        for (OWLDatatypeDefinitionAxiom ax : axioms) {
            if (!ax.getDatatype().equals(datatype)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        Set<OWLSubAnnotationPropertyOfAxiom> result = CollectionFactory.createSet();
        for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxiomsInternal(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            if (!ax.getSubProperty().equals(subProperty)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        Set<OWLAnnotationPropertyDomainAxiom> result = CollectionFactory.createSet();
        for (OWLAnnotationPropertyDomainAxiom ax : this.getAxiomsInternal(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            if (!ax.getProperty().equals(property)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        Set<OWLAnnotationPropertyRangeAxiom> result = CollectionFactory.createSet();
        for (OWLAnnotationPropertyRangeAxiom ax : this.getAxiomsInternal(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            if (!ax.getProperty().equals(property)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    protected <T extends OWLAxiom> Set<T> getAxiomsInternal(AxiomType<T> axiomType) {
        return this.getAxioms(axiomType, this.axiomsByType, false);
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLAnonymousIndividual individual) {
        return this.getReturnSet(this.getAxioms(individual, this.owlAnonymousIndividualReferences, false));
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        Set<OWLAxiom> axioms = owlEntity instanceof OWLClass ? this.getAxioms(owlEntity.asOWLClass(), this.owlClassReferences, false) : (owlEntity instanceof OWLObjectProperty ? this.getAxioms(owlEntity.asOWLObjectProperty(), this.owlObjectPropertyReferences, false) : (owlEntity instanceof OWLDataProperty ? this.getAxioms(owlEntity.asOWLDataProperty(), this.owlDataPropertyReferences, false) : (owlEntity instanceof OWLNamedIndividual ? this.getAxioms(owlEntity.asOWLNamedIndividual(), this.owlIndividualReferences, false) : (owlEntity instanceof OWLDatatype ? this.getAxioms(owlEntity.asOWLDatatype(), this.owlDatatypeReferences, false) : (owlEntity instanceof OWLAnnotationProperty ? this.getAxioms(owlEntity.asOWLAnnotationProperty(), this.owlAnnotationPropertyReferences, false) : Collections.emptySet())))));
        return this.getReturnSet(axioms);
    }

    @Override
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity entity) {
        return this.getReturnSet(this.getAxioms(entity, this.declarationsByEntity, false));
    }

    @Override
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.getReturnSet(this.importsDeclarations);
    }

    @Override
    public boolean addImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        if (this.importsDeclarations.contains(importDeclaration)) {
            return false;
        }
        this.importsDeclarations.add(importDeclaration);
        return true;
    }

    @Override
    public boolean removeImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        if (!this.importsDeclarations.contains(importDeclaration)) {
            return false;
        }
        this.importsDeclarations.remove(importDeclaration);
        return true;
    }

    @Override
    public Set<OWLAnnotation> getOntologyAnnotations() {
        return this.getReturnSet(this.ontologyAnnotations);
    }

    @Override
    public boolean addOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.add(ann);
    }

    @Override
    public boolean removeOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.remove(ann);
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom) {
        Set<OWLAxiom> axioms = this.axiomsByType.get(axiom.getAxiomType());
        return axioms != null && axioms.contains(axiom);
    }

    @Override
    public int getAxiomCount() {
        int count = 0;
        for (AxiomType<?> type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet = this.axiomsByType.get(type);
            if (axiomSet == null) continue;
            count += axiomSet.size();
        }
        return count;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        Set<OWLAxiom> axioms = CollectionFactory.createSet();
        for (AxiomType<?> type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> owlAxiomSet = this.axiomsByType.get(type);
            if (owlAxiomSet == null) continue;
            axioms.addAll(owlAxiomSet);
        }
        return axioms;
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return this.getAxioms(axiomType, this.axiomsByType, false);
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, Collection<OWLOntology> importsClosure) {
        if (importsClosure == null || importsClosure.size() == 0) {
            return this.getAxioms(axiomType);
        }
        Set result = CollectionFactory.createSet();
        for (OWLOntology ont : importsClosure) {
            result.addAll(ont.getAxioms(axiomType));
        }
        return result;
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        Set<OWLAxiom> axioms = this.axiomsByType.get(axiomType);
        if (axioms == null) {
            return 0;
        }
        return axioms.size();
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        Set<OWLLogicalAxiom> axioms = CollectionFactory.createSet();
        for (AxiomType<?> type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet;
            if (!type.isLogical() || (axiomSet = this.axiomsByType.get(type)) == null) continue;
            for (OWLAxiom ax : axiomSet) {
                axioms.add((OWLLogicalAxiom)ax);
            }
        }
        return axioms;
    }

    @Override
    public int getLogicalAxiomCount() {
        int count = 0;
        for (AxiomType<?> type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet;
            if (!type.isLogical() || (axiomSet = this.axiomsByType.get(type)) == null) continue;
            count += axiomSet.size();
        }
        return count;
    }

    @Override
    public void addAxiomsByType(AxiomType<?> type, OWLAxiom axiom) {
        this.addToIndexedSet(type, this.axiomsByType, axiom);
    }

    @Override
    public void removeAxiomsByType(AxiomType<?> type, OWLAxiom axiom) {
        this.removeAxiomFromSet(type, this.axiomsByType, axiom, true);
    }

    @Override
    public Map<OWLAxiom, Set<OWLAxiom>> getLogicalAxiom2AnnotatedAxiomMap() {
        return new HashMap<OWLAxiom, Set<OWLAxiom>>(this.logicalAxiom2AnnotatedAxiomMap);
    }

    @Override
    public Set<OWLAxiom> getLogicalAxiom2AnnotatedAxiom(OWLAxiom ax) {
        return this.getReturnSet(this.logicalAxiom2AnnotatedAxiomMap.get(ax.getAxiomWithoutAnnotations()));
    }

    @Override
    public void addLogicalAxiom2AnnotatedAxiomMap(OWLAxiom ax) {
        this.addToIndexedSet(ax.getAxiomWithoutAnnotations(), this.logicalAxiom2AnnotatedAxiomMap, ax);
    }

    @Override
    public void removeLogicalAxiom2AnnotatedAxiomMap(OWLAxiom ax) {
        this.removeAxiomFromSet(ax.getAxiomWithoutAnnotations(), this.logicalAxiom2AnnotatedAxiomMap, ax, true);
    }

    @Override
    public boolean containsLogicalAxiom2AnnotatedAxiomMap(OWLAxiom ax) {
        return this.logicalAxiom2AnnotatedAxiomMap.containsKey(ax.getAxiomWithoutAnnotations());
    }

    @Override
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.getReturnSet(this.generalClassAxioms);
    }

    @Override
    public void addGeneralClassAxioms(OWLClassAxiom ax) {
        this.generalClassAxioms.add(ax);
    }

    @Override
    public void removeGeneralClassAxioms(OWLClassAxiom ax) {
        this.generalClassAxioms.remove(ax);
    }

    @Override
    public Set<OWLSubPropertyChainOfAxiom> getPropertyChainSubPropertyAxioms() {
        return this.getReturnSet(this.propertyChainSubPropertyAxioms);
    }

    @Override
    public void addPropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        this.propertyChainSubPropertyAxioms.add(ax);
    }

    @Override
    public void removePropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        this.propertyChainSubPropertyAxioms.remove(ax);
    }

    @Override
    public Map<OWLClass, Set<OWLAxiom>> getOwlClassReferences() {
        return new HashMap<OWLClass, Set<OWLAxiom>>(this.owlClassReferences);
    }

    @Override
    public void removeOwlClassReferences(OWLClass c, OWLAxiom ax) {
        this.removeAxiomFromSet(c, this.owlClassReferences, ax, true);
    }

    @Override
    public void addOwlClassReferences(OWLClass c, OWLAxiom ax) {
        this.addToIndexedSet(c, this.owlClassReferences, ax);
    }

    @Override
    public boolean containsOwlClassReferences(OWLClass c) {
        return this.owlClassReferences.containsKey(c);
    }

    @Override
    public Map<OWLObjectProperty, Set<OWLAxiom>> getOwlObjectPropertyReferences() {
        return new HashMap<OWLObjectProperty, Set<OWLAxiom>>(this.owlObjectPropertyReferences);
    }

    @Override
    public void removeOwlObjectPropertyReferences(OWLObjectProperty p, OWLAxiom ax) {
        this.removeAxiomFromSet(p, this.owlObjectPropertyReferences, ax, true);
    }

    @Override
    public void addOwlObjectPropertyReferences(OWLObjectProperty p, OWLAxiom ax) {
        this.addToIndexedSet(p, this.owlObjectPropertyReferences, ax);
    }

    @Override
    public boolean containsOwlObjectPropertyReferences(OWLObjectProperty c) {
        return this.owlObjectPropertyReferences.containsKey(c);
    }

    @Override
    public Map<OWLDataProperty, Set<OWLAxiom>> getOwlDataPropertyReferences() {
        return new HashMap<OWLDataProperty, Set<OWLAxiom>>(this.owlDataPropertyReferences);
    }

    @Override
    public void removeOwlDataPropertyReferences(OWLDataProperty c, OWLAxiom ax) {
        this.removeAxiomFromSet(c, this.owlDataPropertyReferences, ax, true);
    }

    @Override
    public void addOwlDataPropertyReferences(OWLDataProperty c, OWLAxiom ax) {
        this.addToIndexedSet(c, this.owlDataPropertyReferences, ax);
    }

    @Override
    public boolean containsOwlDataPropertyReferences(OWLDataProperty c) {
        return this.owlDataPropertyReferences.containsKey(c);
    }

    @Override
    public Map<OWLNamedIndividual, Set<OWLAxiom>> getOwlIndividualReferences() {
        return this.owlIndividualReferences;
    }

    @Override
    public void removeOwlIndividualReferences(OWLNamedIndividual c, OWLAxiom ax) {
        this.removeAxiomFromSet(c, this.owlIndividualReferences, ax, true);
    }

    @Override
    public void addOwlIndividualReferences(OWLNamedIndividual c, OWLAxiom ax) {
        this.addToIndexedSet(c, this.owlIndividualReferences, ax);
    }

    @Override
    public boolean containsOwlIndividualReferences(OWLNamedIndividual c) {
        return this.owlIndividualReferences.containsKey(c);
    }

    @Override
    public Map<OWLAnonymousIndividual, Set<OWLAxiom>> getOwlAnonymousIndividualReferences() {
        return new HashMap<OWLAnonymousIndividual, Set<OWLAxiom>>(this.owlAnonymousIndividualReferences);
    }

    @Override
    public void removeOwlAnonymousIndividualReferences(OWLAnonymousIndividual c, OWLAxiom ax) {
        this.removeAxiomFromSet(c, this.owlAnonymousIndividualReferences, ax, true);
    }

    @Override
    public void addOwlAnonymousIndividualReferences(OWLAnonymousIndividual c, OWLAxiom ax) {
        this.addToIndexedSet(c, this.owlAnonymousIndividualReferences, ax);
    }

    @Override
    public boolean containsOwlAnonymousIndividualReferences(OWLAnonymousIndividual c) {
        return this.owlAnonymousIndividualReferences.containsKey(c);
    }

    @Override
    public Map<OWLDatatype, Set<OWLAxiom>> getOwlDatatypeReferences() {
        return new HashMap<OWLDatatype, Set<OWLAxiom>>(this.owlDatatypeReferences);
    }

    @Override
    public void removeOwlDatatypeReferences(OWLDatatype c, OWLAxiom ax) {
        this.removeAxiomFromSet(c, this.owlDatatypeReferences, ax, true);
    }

    @Override
    public void addOwlDatatypeReferences(OWLDatatype c, OWLAxiom ax) {
        this.addToIndexedSet(c, this.owlDatatypeReferences, ax);
    }

    @Override
    public boolean containsOwlDatatypeReferences(OWLDatatype c) {
        return this.owlDatatypeReferences.containsKey(c);
    }

    @Override
    public Map<OWLAnnotationProperty, Set<OWLAxiom>> getOwlAnnotationPropertyReferences() {
        return new HashMap<OWLAnnotationProperty, Set<OWLAxiom>>(this.owlAnnotationPropertyReferences);
    }

    @Override
    public void removeOwlAnnotationPropertyReferences(OWLAnnotationProperty c, OWLAxiom ax) {
        this.removeAxiomFromSet(c, this.owlAnnotationPropertyReferences, ax, true);
    }

    @Override
    public void addOwlAnnotationPropertyReferences(OWLAnnotationProperty c, OWLAxiom ax) {
        this.addToIndexedSet(c, this.owlAnnotationPropertyReferences, ax);
    }

    @Override
    public boolean containsOwlAnnotationPropertyReferences(OWLAnnotationProperty c) {
        return this.owlAnnotationPropertyReferences.containsKey(c);
    }

    @Override
    public Map<OWLEntity, Set<OWLDeclarationAxiom>> getDeclarationsByEntity() {
        return new HashMap<OWLEntity, Set<OWLDeclarationAxiom>>(this.declarationsByEntity);
    }

    @Override
    public void removeDeclarationsByEntity(OWLEntity c, OWLDeclarationAxiom ax) {
        this.removeAxiomFromSet(c, this.declarationsByEntity, ax, true);
    }

    @Override
    public void addDeclarationsByEntity(OWLEntity c, OWLDeclarationAxiom ax) {
        this.addToIndexedSet(c, this.declarationsByEntity, ax);
    }

    @Override
    public boolean containsDeclarationsByEntity(OWLEntity c) {
        return this.declarationsByEntity.containsKey(c);
    }
}

