/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.special;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.bioportal.BioportalOntologyService;
import uk.ac.ebi.ontocat.file.FileOntologyService;
import uk.ac.ebi.ontocat.ols.OlsOntologyService;
import uk.ac.ebi.ontocat.special.AbstractOntologyServiceTest;
import uk.ac.ebi.ontocat.virtual.CompositeDecorator;

public class CompositeDecoratorTest
extends AbstractOntologyServiceTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BioportalOntologyService osBP = new BioportalOntologyService();
        OlsOntologyService osOLS = new OlsOntologyService();
        FileOntologyService osFile = new FileOntologyService(new URI("http://diseaseontology.svn.sourceforge.net/svnroot/diseaseontology/trunk/HumanDO.obo"));
        os = CompositeDecorator.getService(new OntologyService[]{osOLS, osBP, osFile});
        ONTOLOGY_ACCESSION = "http://www.ebi.ac.uk/efo/";
        TERM_ACCESSION = "EFO_0000400";
    }

    @Test
    @Ignore(value="Tested equals() on OntologyTerm, fixed now")
    public void testHashCollapse() throws OntologyServiceException {
        List<OntologyTerm> l = os.searchAll("thymus", new OntologyService.SearchOptions[0]);
        log.info("List size " + l.size());
        HashSet<OntologyTerm> h = new HashSet<OntologyTerm>(l);
        log.info("Hash size " + h.size());
        Assert.assertEquals((Object)l.size(), (Object)h.size());
    }

    @Test
    @Ignore(value="Fixed concurrency issues in OWLmanager")
    public void testConcurrentRequests() throws OntologyServiceException, URISyntaxException {
        ExecutorService ec = Executors.newFixedThreadPool(50);
        ArrayList<RequestTask> tasks = new ArrayList<RequestTask>();
        for (int i = 0; i < 50; ++i) {
            tasks.add(new RequestTask());
        }
        try {
            ec.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestTask
    implements Callable<Object> {
        private RequestTask() {
        }

        @Override
        public Object call() throws Exception {
            new FileOntologyService(new URI("http://www.ebi.ac.uk/efo"));
            return null;
        }
    }
}

