/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner;

import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class TimedConsoleProgressMonitor
implements ReasonerProgressMonitor {
    private int lastPercentage = 0;
    private long lastTime;

    public void reasonerTaskStarted(String taskName) {
        System.out.print(taskName);
        System.out.println(" ...");
        this.lastTime = System.currentTimeMillis();
    }

    public void reasonerTaskStopped() {
        System.out.println("    ... finished");
        this.lastPercentage = 0;
    }

    public void reasonerTaskProgressChanged(int value, int max) {
        int percent;
        long time = System.currentTimeMillis();
        if (max > 0 && this.lastPercentage != (percent = value * 100 / max)) {
            System.out.print("    ");
            System.out.print(percent);
            System.out.println("%\t" + (time - this.lastTime));
            this.lastTime = time;
            this.lastPercentage = percent;
        }
    }

    public void reasonerTaskBusy() {
        System.out.println("    busy ...");
    }
}

