/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;

public final class TupleTable
implements Serializable {
    private static final long serialVersionUID = -7712458276004062803L;
    protected static final int PAGE_SIZE = 512;
    protected final int m_arity;
    protected Page[] m_pages;
    protected int m_numberOfPages;
    protected int m_tupleCapacity;
    protected int m_firstFreeTupleIndex;

    public TupleTable(int n) {
        this.m_arity = n;
        this.clear();
    }

    public int sizeInMemory() {
        int n = this.m_pages.length * 4;
        for (int i = this.m_pages.length - 1; i >= 0; --i) {
            if (this.m_pages[i] == null) continue;
            n += this.m_pages[i].sizeInMemory();
        }
        return n;
    }

    public int getFirstFreeTupleIndex() {
        return this.m_firstFreeTupleIndex;
    }

    public int addTuple(Object[] objectArray) {
        int n = this.m_firstFreeTupleIndex;
        if (n == this.m_tupleCapacity) {
            if (this.m_numberOfPages == this.m_pages.length) {
                Page[] pageArray = new Page[this.m_numberOfPages * 3 / 2];
                System.arraycopy(this.m_pages, 0, pageArray, 0, this.m_numberOfPages);
                this.m_pages = pageArray;
            }
            this.m_pages[this.m_numberOfPages++] = new Page(this.m_arity);
            this.m_tupleCapacity += 512;
        }
        this.m_pages[n / 512].storeTuple(n % 512 * this.m_arity, objectArray);
        ++this.m_firstFreeTupleIndex;
        return n;
    }

    public boolean tupleEquals(Object[] objectArray, int n, int n2) {
        return this.m_pages[n / 512].tupleEquals(objectArray, n % 512 * this.m_arity, n2);
    }

    public boolean tupleEquals(Object[] objectArray, int[] nArray, int n, int n2) {
        return this.m_pages[n / 512].tupleEquals(objectArray, nArray, n % 512 * this.m_arity, n2);
    }

    public void retrieveTuple(Object[] objectArray, int n) {
        this.m_pages[n / 512].retrieveTuple(n % 512 * this.m_arity, objectArray);
    }

    public Object getTupleObject(int n, int n2) {
        assert (n2 < this.m_arity);
        return this.m_pages[n / 512].m_objects[n % 512 * this.m_arity + n2];
    }

    public void setTupleObject(int n, int n2, Object object) {
        this.m_pages[n / 512].m_objects[n % 512 * this.m_arity + n2] = object;
    }

    public void truncate(int n) {
        this.m_firstFreeTupleIndex = n;
    }

    public void nullifyTuple(int n) {
        this.m_pages[n / 512].nullifyTuple(n % 512 * this.m_arity);
    }

    public void clear() {
        this.m_pages = new Page[10];
        this.m_numberOfPages = 1;
        this.m_pages[0] = new Page(this.m_arity);
        this.m_tupleCapacity = this.m_numberOfPages * 512;
        this.m_firstFreeTupleIndex = 0;
    }

    protected static final class Page
    implements Serializable {
        private static final long serialVersionUID = 2239482172592108644L;
        public final int m_arity;
        public Object[] m_objects;

        public Page(int n) {
            this.m_arity = n;
            this.m_objects = new Object[this.m_arity * 512];
        }

        public int sizeInMemory() {
            return this.m_objects.length * 4;
        }

        public void storeTuple(int n, Object[] objectArray) {
            System.arraycopy(objectArray, 0, this.m_objects, n, objectArray.length);
        }

        public void retrieveTuple(int n, Object[] objectArray) {
            System.arraycopy(this.m_objects, n, objectArray, 0, objectArray.length);
        }

        public void nullifyTuple(int n) {
            for (int i = 0; i < this.m_arity; ++i) {
                this.m_objects[n + i] = null;
            }
        }

        public boolean tupleEquals(Object[] objectArray, int n, int n2) {
            int n3 = n2 - 1;
            int n4 = n + n3;
            while (n3 >= 0) {
                if (!objectArray[n3].equals(this.m_objects[n4])) {
                    return false;
                }
                --n3;
                --n4;
            }
            return true;
        }

        public boolean tupleEquals(Object[] objectArray, int[] nArray, int n, int n2) {
            int n3 = n2 - 1;
            int n4 = n + n3;
            while (n3 >= 0) {
                if (!objectArray[nArray[n3]].equals(this.m_objects[n4])) {
                    return false;
                }
                --n3;
                --n4;
            }
            return true;
        }
    }
}

