/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.PermanentDependencySet;
import org.semanticweb.HermiT.tableau.UnionDependencySet;

public final class DependencySetFactory
implements Serializable {
    private static final long serialVersionUID = 8632867055646817311L;
    protected final IntegerArray m_mergeArray = new IntegerArray();
    protected final List<PermanentDependencySet> m_mergeSets = new ArrayList<PermanentDependencySet>();
    protected final List<UnionDependencySet> m_unprocessedSets = new ArrayList<UnionDependencySet>();
    protected PermanentDependencySet m_emptySet;
    protected PermanentDependencySet m_firstUnusedSet;
    protected PermanentDependencySet m_firstDestroyedSet;
    protected PermanentDependencySet[] m_entries;
    protected int m_size;
    protected int m_resizeThreshold;

    public DependencySetFactory() {
        this.clear();
    }

    public int sizeInMemory() {
        return this.m_entries.length * 4 + this.m_size * 20;
    }

    public void clear() {
        this.m_mergeArray.clear();
        this.m_mergeSets.clear();
        this.m_unprocessedSets.clear();
        this.m_emptySet = new PermanentDependencySet();
        this.m_emptySet.m_branchingPoint = -1;
        this.m_emptySet.m_usageCounter = 1;
        this.m_emptySet.m_rest = null;
        this.m_emptySet.m_previousUnusedSet = null;
        this.m_emptySet.m_nextUnusedSet = null;
        this.m_firstUnusedSet = null;
        this.m_firstDestroyedSet = null;
        this.m_entries = new PermanentDependencySet[16];
        this.m_resizeThreshold = (int)((double)this.m_entries.length * 0.75);
        this.m_size = 0;
    }

    public PermanentDependencySet emptySet() {
        return this.m_emptySet;
    }

    public void removeUnusedSets() {
        while (this.m_firstUnusedSet != null) {
            this.destroyDependencySet(this.m_firstUnusedSet);
        }
    }

    public void addUsage(PermanentDependencySet permanentDependencySet) {
        assert (permanentDependencySet.m_branchingPoint >= 0 || permanentDependencySet == this.m_emptySet);
        if (permanentDependencySet.m_usageCounter == 0) {
            this.removeFromUnusedList(permanentDependencySet);
        }
        ++permanentDependencySet.m_usageCounter;
    }

    public void removeUsage(PermanentDependencySet permanentDependencySet) {
        assert (permanentDependencySet.m_branchingPoint >= 0 || permanentDependencySet == this.m_emptySet);
        assert (permanentDependencySet.m_usageCounter > 0);
        assert (permanentDependencySet.m_previousUnusedSet == null);
        assert (permanentDependencySet.m_nextUnusedSet == null);
        --permanentDependencySet.m_usageCounter;
        if (permanentDependencySet.m_usageCounter == 0) {
            this.addToUnusedList(permanentDependencySet);
        }
    }

    public PermanentDependencySet addBranchingPoint(DependencySet dependencySet, int n) {
        PermanentDependencySet permanentDependencySet = this.getPermanent(dependencySet);
        if (n > permanentDependencySet.m_branchingPoint) {
            return this.getDepdendencySet(permanentDependencySet, n);
        }
        if (n == permanentDependencySet.m_branchingPoint) {
            return permanentDependencySet;
        }
        this.m_mergeArray.clear();
        PermanentDependencySet permanentDependencySet2 = permanentDependencySet;
        while (n < permanentDependencySet2.m_branchingPoint) {
            this.m_mergeArray.add(permanentDependencySet2.m_branchingPoint);
            permanentDependencySet2 = permanentDependencySet2.m_rest;
        }
        if (n == permanentDependencySet2.m_branchingPoint) {
            return permanentDependencySet;
        }
        permanentDependencySet2 = this.getDepdendencySet(permanentDependencySet2, n);
        for (int i = this.m_mergeArray.size() - 1; i >= 0; --i) {
            permanentDependencySet2 = this.getDepdendencySet(permanentDependencySet2, this.m_mergeArray.get(i));
        }
        return permanentDependencySet2;
    }

    protected PermanentDependencySet getDepdendencySet(PermanentDependencySet permanentDependencySet, int n) {
        int n2 = permanentDependencySet.hashCode() + n & this.m_entries.length - 1;
        PermanentDependencySet permanentDependencySet2 = this.m_entries[n2];
        while (permanentDependencySet2 != null) {
            if (permanentDependencySet2.m_rest == permanentDependencySet && permanentDependencySet2.m_branchingPoint == n) {
                return permanentDependencySet2;
            }
            permanentDependencySet2 = permanentDependencySet2.m_nextEntry;
        }
        permanentDependencySet2 = this.createDependencySet(permanentDependencySet, n);
        permanentDependencySet2.m_nextEntry = this.m_entries[n2];
        this.m_entries[n2] = permanentDependencySet2;
        if (this.m_size >= this.m_resizeThreshold) {
            this.resizeEntries();
        }
        return permanentDependencySet2;
    }

    protected PermanentDependencySet createDependencySet(PermanentDependencySet permanentDependencySet, int n) {
        PermanentDependencySet permanentDependencySet2;
        if (this.m_firstDestroyedSet == null) {
            permanentDependencySet2 = new PermanentDependencySet();
        } else {
            permanentDependencySet2 = this.m_firstDestroyedSet;
            this.m_firstDestroyedSet = this.m_firstDestroyedSet.m_nextEntry;
        }
        permanentDependencySet2.m_rest = permanentDependencySet;
        permanentDependencySet2.m_branchingPoint = n;
        permanentDependencySet2.m_usageCounter = 0;
        this.addUsage(permanentDependencySet2.m_rest);
        this.addToUnusedList(permanentDependencySet2);
        ++this.m_size;
        return permanentDependencySet2;
    }

    protected void destroyDependencySet(PermanentDependencySet permanentDependencySet) {
        assert (permanentDependencySet.m_branchingPoint >= 0);
        assert (permanentDependencySet.m_usageCounter == 0);
        assert (permanentDependencySet.m_rest.m_usageCounter > 0);
        this.removeFromUnusedList(permanentDependencySet);
        this.removeUsage(permanentDependencySet.m_rest);
        this.removeFromEntries(permanentDependencySet);
        permanentDependencySet.m_rest = null;
        permanentDependencySet.m_branchingPoint = -2;
        permanentDependencySet.m_nextEntry = this.m_firstDestroyedSet;
        this.m_firstDestroyedSet = permanentDependencySet;
        --this.m_size;
    }

    protected void removeFromEntries(PermanentDependencySet permanentDependencySet) {
        int n = permanentDependencySet.m_rest.hashCode() + permanentDependencySet.m_branchingPoint & this.m_entries.length - 1;
        PermanentDependencySet permanentDependencySet2 = null;
        PermanentDependencySet permanentDependencySet3 = this.m_entries[n];
        while (permanentDependencySet3 != null) {
            if (permanentDependencySet3 == permanentDependencySet) {
                if (permanentDependencySet2 == null) {
                    this.m_entries[n] = permanentDependencySet.m_nextEntry;
                } else {
                    permanentDependencySet2.m_nextEntry = permanentDependencySet.m_nextEntry;
                }
                return;
            }
            permanentDependencySet2 = permanentDependencySet3;
            permanentDependencySet3 = permanentDependencySet3.m_nextEntry;
        }
        throw new IllegalStateException("Internal error: dependency set not in the entries table. Please inform HermiT authors about this.");
    }

    protected void removeFromUnusedList(PermanentDependencySet permanentDependencySet) {
        if (permanentDependencySet.m_previousUnusedSet != null) {
            permanentDependencySet.m_previousUnusedSet.m_nextUnusedSet = permanentDependencySet.m_nextUnusedSet;
        } else {
            this.m_firstUnusedSet = permanentDependencySet.m_nextUnusedSet;
        }
        if (permanentDependencySet.m_nextUnusedSet != null) {
            permanentDependencySet.m_nextUnusedSet.m_previousUnusedSet = permanentDependencySet.m_previousUnusedSet;
        }
        permanentDependencySet.m_previousUnusedSet = null;
        permanentDependencySet.m_nextUnusedSet = null;
    }

    protected void addToUnusedList(PermanentDependencySet permanentDependencySet) {
        permanentDependencySet.m_previousUnusedSet = null;
        permanentDependencySet.m_nextUnusedSet = this.m_firstUnusedSet;
        if (this.m_firstUnusedSet != null) {
            this.m_firstUnusedSet.m_previousUnusedSet = permanentDependencySet;
        }
        this.m_firstUnusedSet = permanentDependencySet;
    }

    protected void resizeEntries() {
        int n = this.m_entries.length * 2;
        int n2 = n - 1;
        PermanentDependencySet[] permanentDependencySetArray = new PermanentDependencySet[n];
        for (int i = 0; i < this.m_entries.length; ++i) {
            PermanentDependencySet permanentDependencySet = this.m_entries[i];
            while (permanentDependencySet != null) {
                PermanentDependencySet permanentDependencySet2 = permanentDependencySet.m_nextEntry;
                int n3 = permanentDependencySet.m_rest.hashCode() + permanentDependencySet.m_branchingPoint & n2;
                permanentDependencySet.m_nextEntry = permanentDependencySetArray[n3];
                permanentDependencySetArray[n3] = permanentDependencySet;
                permanentDependencySet = permanentDependencySet2;
            }
        }
        this.m_entries = permanentDependencySetArray;
        this.m_resizeThreshold = (int)((double)this.m_entries.length * 0.75);
    }

    public PermanentDependencySet removeBranchingPoint(DependencySet dependencySet, int n) {
        PermanentDependencySet permanentDependencySet = this.getPermanent(dependencySet);
        if (n == permanentDependencySet.m_branchingPoint) {
            return permanentDependencySet.m_rest;
        }
        if (n > permanentDependencySet.m_branchingPoint) {
            return permanentDependencySet;
        }
        this.m_mergeArray.clear();
        PermanentDependencySet permanentDependencySet2 = permanentDependencySet;
        while (n < permanentDependencySet2.m_branchingPoint) {
            this.m_mergeArray.add(permanentDependencySet2.m_branchingPoint);
            permanentDependencySet2 = permanentDependencySet2.m_rest;
        }
        if (n != permanentDependencySet2.m_branchingPoint) {
            return permanentDependencySet;
        }
        permanentDependencySet2 = permanentDependencySet2.m_rest;
        for (int i = this.m_mergeArray.size() - 1; i >= 0; --i) {
            permanentDependencySet2 = this.getDepdendencySet(permanentDependencySet2, this.m_mergeArray.get(i));
        }
        return permanentDependencySet2;
    }

    public PermanentDependencySet unionWith(DependencySet dependencySet, DependencySet dependencySet2) {
        PermanentDependencySet permanentDependencySet;
        PermanentDependencySet permanentDependencySet2 = this.getPermanent(dependencySet);
        if (permanentDependencySet2 == (permanentDependencySet = this.getPermanent(dependencySet2))) {
            return permanentDependencySet2;
        }
        this.m_mergeArray.clear();
        while (permanentDependencySet2 != permanentDependencySet) {
            if (permanentDependencySet2.m_branchingPoint > permanentDependencySet.m_branchingPoint) {
                this.m_mergeArray.add(permanentDependencySet2.m_branchingPoint);
                permanentDependencySet2 = permanentDependencySet2.m_rest;
                continue;
            }
            if (permanentDependencySet2.m_branchingPoint < permanentDependencySet.m_branchingPoint) {
                this.m_mergeArray.add(permanentDependencySet.m_branchingPoint);
                permanentDependencySet = permanentDependencySet.m_rest;
                continue;
            }
            this.m_mergeArray.add(permanentDependencySet2.m_branchingPoint);
            permanentDependencySet2 = permanentDependencySet2.m_rest;
            permanentDependencySet = permanentDependencySet.m_rest;
        }
        PermanentDependencySet permanentDependencySet3 = permanentDependencySet2;
        for (int i = this.m_mergeArray.size() - 1; i >= 0; --i) {
            permanentDependencySet3 = this.getDepdendencySet(permanentDependencySet3, this.m_mergeArray.get(i));
        }
        return permanentDependencySet3;
    }

    public PermanentDependencySet getPermanent(DependencySet dependencySet) {
        int n;
        PermanentDependencySet permanentDependencySet;
        if (dependencySet instanceof PermanentDependencySet) {
            return (PermanentDependencySet)dependencySet;
        }
        this.m_unprocessedSets.clear();
        this.m_mergeSets.clear();
        this.m_unprocessedSets.add((UnionDependencySet)dependencySet);
        while (!this.m_unprocessedSets.isEmpty()) {
            UnionDependencySet unionDependencySet = this.m_unprocessedSets.remove(this.m_unprocessedSets.size() - 1);
            for (int i = 0; i < unionDependencySet.m_numberOfConstituents; ++i) {
                DependencySet dependencySet2 = unionDependencySet.m_dependencySets[i];
                if (dependencySet2 instanceof UnionDependencySet) {
                    this.m_unprocessedSets.add((UnionDependencySet)dependencySet2);
                    continue;
                }
                this.m_mergeSets.add((PermanentDependencySet)dependencySet2);
            }
        }
        int n2 = this.m_mergeSets.size();
        this.m_mergeArray.clear();
        block2: while (true) {
            PermanentDependencySet permanentDependencySet2;
            int n3;
            permanentDependencySet = this.m_mergeSets.get(0);
            n = permanentDependencySet.m_branchingPoint;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = true;
            for (n3 = 1; n3 < n2; ++n3) {
                permanentDependencySet2 = this.m_mergeSets.get(n3);
                int n5 = permanentDependencySet2.m_branchingPoint;
                if (n5 > n) {
                    n = n5;
                    bl = false;
                    n4 = n3;
                } else if (n5 == n) {
                    bl = true;
                }
                if (permanentDependencySet2 == permanentDependencySet) continue;
                bl2 = false;
            }
            if (bl2) break;
            this.m_mergeArray.add(n);
            if (bl) {
                n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block2;
                    permanentDependencySet2 = this.m_mergeSets.get(n3);
                    if (permanentDependencySet2.m_branchingPoint == n) {
                        this.m_mergeSets.set(n3, permanentDependencySet2.m_rest);
                    }
                    ++n3;
                }
            }
            PermanentDependencySet permanentDependencySet3 = this.m_mergeSets.get(n4);
            this.m_mergeSets.set(n4, permanentDependencySet3.m_rest);
        }
        permanentDependencySet = this.m_mergeSets.get(0);
        for (n = this.m_mergeArray.size() - 1; n >= 0; --n) {
            permanentDependencySet = this.getDepdendencySet(permanentDependencySet, this.m_mergeArray.get(n));
        }
        this.m_mergeSets.clear();
        return permanentDependencySet;
    }

    protected static final class IntegerArray
    implements Serializable {
        private static final long serialVersionUID = 7070190530381846058L;
        protected int[] m_elements = new int[64];
        protected int m_size = 0;

        public void clear() {
            this.m_size = 0;
        }

        public int size() {
            return this.m_size;
        }

        public int get(int n) {
            return this.m_elements[n];
        }

        public void add(int n) {
            if (this.m_size >= this.m_elements.length) {
                int[] nArray = new int[this.m_elements.length * 3 / 2];
                System.arraycopy(this.m_elements, 0, nArray, 0, this.m_elements.length);
                this.m_elements = nArray;
            }
            this.m_elements[this.m_size++] = n;
        }
    }
}

