/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.Printing;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.tableau.Node;

public class OriginStatsCommand
extends AbstractCommand {
    public OriginStatsCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "originStats";
    }

    public String[] getDescription() {
        return new String[]{"", "prints origin information for nodes in the model"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: originStats");
        printWriter.println("    Prints origin information for the nodes in the current model.");
    }

    /*
     * WARNING - void declaration
     */
    public void execute(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Node node;
        HashMap<Object, OriginInfo> hashMap = new HashMap<Object, OriginInfo>();
        for (node = this.m_debugger.getTableau().getFirstTableauNode(); node != null; node = node.getNextTableauNode()) {
            void object4;
            object3 = this.m_debugger.getNodeCreationInfo(node);
            object2 = object3.m_createdByExistential;
            if (!(object2 instanceof AtLeastConcept)) continue;
            object = ((AtLeastConcept)object2).getToConcept();
            OriginInfo originInfo = (OriginInfo)hashMap.get(object);
            if (originInfo == null) {
                OriginInfo originInfo2 = new OriginInfo((Concept)object);
                hashMap.put(object, originInfo2);
            }
            object4.m_nodes.add(node);
            if (node.isActive()) continue;
            ++object4.m_numberOfNonactiveOccurrences;
        }
        object3 = new OriginInfo[hashMap.size()];
        hashMap.values().toArray((T[])object3);
        Arrays.sort(object3, OriginInfoComparator.INSTANCE);
        object2 = new CharArrayWriter();
        object = new PrintWriter((Writer)object2);
        ((PrintWriter)object).println("Statistics of node origins");
        ((PrintWriter)object).println("====================================");
        ((PrintWriter)object).println("  Occurrence    Nonactive   Concept");
        ((PrintWriter)object).println("====================================");
        for (OriginInfo originInfo : object3) {
            ((PrintWriter)object).print("  ");
            Printing.printPadded((PrintWriter)object, originInfo.m_nodes.size(), 8);
            ((PrintWriter)object).print("    ");
            Printing.printPadded((PrintWriter)object, originInfo.m_numberOfNonactiveOccurrences, 8);
            ((PrintWriter)object).print("    ");
            ((PrintWriter)object).print(originInfo.m_concept.toString(this.m_debugger.getPrefixes()));
            if (originInfo.m_nodes.size() <= 5) {
                ((PrintWriter)object).print("  [ ");
                for (int i = 0; i < originInfo.m_nodes.size(); ++i) {
                    if (i != 0) {
                        ((PrintWriter)object).print(", ");
                    }
                    node = originInfo.m_nodes.get(i);
                    ((PrintWriter)object).print(node.getNodeID());
                    if (node.isActive()) continue;
                    ((PrintWriter)object).print('*');
                }
                ((PrintWriter)object).print(" ]");
            }
            ((PrintWriter)object).println();
        }
        ((PrintWriter)object).println("====================================");
        ((PrintWriter)object).flush();
        this.showTextInWindow(((CharArrayWriter)object2).toString(), "Statistics of node origins");
        this.selectConsoleWindow();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OriginInfoComparator
    implements Comparator<OriginInfo> {
        public static final OriginInfoComparator INSTANCE = new OriginInfoComparator();

        protected OriginInfoComparator() {
        }

        @Override
        public int compare(OriginInfo originInfo, OriginInfo originInfo2) {
            int n = originInfo.m_nodes.size() - originInfo2.m_nodes.size();
            if (n == 0 && (n = originInfo.m_numberOfNonactiveOccurrences - originInfo2.m_numberOfNonactiveOccurrences) == 0) {
                n = Printing.ConceptComparator.INSTANCE.compare(originInfo.m_concept, originInfo2.m_concept);
            }
            return n;
        }
    }

    protected static class OriginInfo {
        public final Concept m_concept;
        public final List<Node> m_nodes;
        public int m_numberOfNonactiveOccurrences;

        public OriginInfo(Concept concept) {
            this.m_concept = concept;
            this.m_nodes = new ArrayList<Node>();
        }
    }
}

