### R code from vignette source 'immunoClust.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: stage0
###################################################
library(immunoClust)


###################################################
### code chunk number 3: stage1data
###################################################
data(dat.fcs)
dat.fcs


###################################################
### code chunk number 4: stage1cluster
###################################################
pars=c("FSC-A","SSC-A","FITC-A","PE-A","APC-A","APC-Cy7-A","Pacific Blue-A")
res.fcs <- cell.process(dat.fcs, parameters=pars)


###################################################
### code chunk number 5: stage1summary
###################################################
summary(res.fcs)


###################################################
### code chunk number 6: stage1bias
###################################################
res2 <- cell.process(dat.fcs, bias=0.25)
summary(res2)


###################################################
### code chunk number 7: stage1trans
###################################################
dat.transformed <- trans.ApplyToData(res.fcs, dat.fcs)


###################################################
### code chunk number 8: stage1splom
###################################################
splom(res.fcs, dat.transformed, N=1000)


###################################################
### code chunk number 9: stage1plot
###################################################
plot(res.fcs, data=dat.transformed, subset=c(1,2))


###################################################
### code chunk number 10: stage2data
###################################################
data(dat.exp)
meta<-meta.process(dat.exp, meta.bias=0.3)


###################################################
### code chunk number 11: stage2splom
###################################################
splom(meta$res.clusters, meta$dat.clusters$M, ellipse=TRUE)


###################################################
### code chunk number 12: stage2plot
###################################################
plot(meta$res.scatter, data=meta$dat.scatter$M)


###################################################
### code chunk number 13: stage2export
###################################################
tbl <- meta.numEvents(meta, out.all=FALSE)
tbl[,1:5]


###################################################
### code chunk number 14: stage2final
###################################################
splom(meta$res.clusters, meta$dat.clusters$M, 
include=c(3,9,10,4,7,12), subset=3:7, ellipse=TRUE)


###################################################
### code chunk number 15: sessionInfo
###################################################
toLatex(sessionInfo())


