## ----biocstyle, eval=TRUE, echo=FALSE, results="asis"-----------------------------------
BiocStyle::latex()

## ----env, echo=FALSE--------------------------------------------------------------------
suppressPackageStartupMessages(library("org.Hs.eg.db"))
suppressPackageStartupMessages(library("GO.db"))

## ----install, echo=TRUE, eval=FALSE-----------------------------------------------------
#  source("http://bioconductor.org/biocLite.R")
#  ## or, if you have already used the above before
#  library("BiocInstaller") ## and to install the package
#  biocLite("hpar")

## ----library----------------------------------------------------------------------------
library("hpar")

## ----hpaData----------------------------------------------------------------------------
data(hpaNormalTissue)
dim(hpaNormalTissue)
names(hpaNormalTissue)
## Number of genes
length(unique(hpaNormalTissue$Gene))
## Number of cell types
length(unique(hpaNormalTissue$Cell.type))
head(levels(hpaNormalTissue$Cell.type))
## Number of tissues
length(unique(hpaNormalTissue$Tissue))
head(levels(hpaNormalTissue$Tissue))
table(hpaNormalTissue$Expression.type)

## ----getHpa-----------------------------------------------------------------------------
id <- "ENSG00000000003"
head(getHpa(id, hpadata = "NormalTissue"))
getHpa(id, hpadata = "SubcellularLoc")
head(getHpa(id, hpadata = "Rna"))

## ----getHpa2, eval=FALSE----------------------------------------------------------------
#  getHpa(id, type = "details")

## ----opts-------------------------------------------------------------------------------
getHparOptions()
setHparOptions(hpadata = "SubcellularLoc")
getHparOptions()
getHpa(id)

## ----rel--------------------------------------------------------------------------------
getHpaVersion()
getHpaDate()
getHpaEnsembl()

## ----uc-hpar----------------------------------------------------------------------------
id <- "ENSG00000001460"
getHpa(id, "SubcellularLoc")

## ----uc-db------------------------------------------------------------------------------
library(org.Hs.eg.db)
library(GO.db)
ans <- select(org.Hs.eg.db, keys = id, 
              columns = c("ENSEMBL", "GO", "ONTOLOGY"), 
              keytype = "ENSEMBL")
ans <- ans[ans$ONTOLOGY == "CC", ]
ans
sapply(as.list(GOTERM[ans$GO]), slot, "Term")

## ----sessioninfo, results='asis', echo = FALSE, cache = FALSE---------------------------
toLatex(sessionInfo())

