### R code from vignette source 'geNetClassifier-vignette.Rnw'

###################################################
### code chunk number 1: geNetClassifier-vignette.Rnw:81-83 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("geNetClassifier")


###################################################
### code chunk number 2: geNetClassifier-vignette.Rnw:89-90 (eval = FALSE)
###################################################
## biocLite("leukemiasEset")


###################################################
### code chunk number 3: geNetClassifier-vignette.Rnw:96-99
###################################################
library(leukemiasEset)
data(leukemiasEset)
leukemiasEset


###################################################
### code chunk number 4: geNetClassifier-vignette.Rnw:101-102
###################################################
summary(leukemiasEset$LeukemiaType) 


###################################################
### code chunk number 5: geNetClassifier-vignette.Rnw:104-105 (eval = FALSE)
###################################################
## pData(leukemiasEset)


###################################################
### code chunk number 6: geNetClassifier-vignette.Rnw:108-109 (eval = FALSE)
###################################################
## ?leukemiasEset


###################################################
### code chunk number 7: geNetClassifier-vignette.Rnw:115-117 (eval = FALSE)
###################################################
## data(geneSymbols)
## head(geneSymbols)


###################################################
### code chunk number 8: geNetClassifier-vignette.Rnw:121-127 (eval = FALSE)
###################################################
## load("genes-human-annotation.R")
## leukEset_protCoding <- leukemiasEset[featureNames(leukemiasEset) 
## %in% rownames(genes.human.Annotation[genes.human.Annotation$biotype 
## %in% "protein_coding",]),]
## dim(leukemiasEset)
## dim(leukEset_protCoding)


###################################################
### code chunk number 9: geNetClassifier-vignette.Rnw:155-156
###################################################
library(geNetClassifier)


###################################################
### code chunk number 10: geNetClassifier-vignette.Rnw:159-163 (eval = FALSE)
###################################################
## # List available vignettes for package geNetClassifier: 
## vignette(package="geNetClassifier")
## # Open vignette named "geNetClassifier-vignette":
## vignette("geNetClassifier-vignette")


###################################################
### code chunk number 11: geNetClassifier-vignette.Rnw:166-167
###################################################
options(width=80)


###################################################
### code chunk number 12: geNetClassifier-vignette.Rnw:169-170
###################################################
objects("package:geNetClassifier")


###################################################
### code chunk number 13: geNetClassifier-vignette.Rnw:172-173 (eval = FALSE)
###################################################
## ?geNetClassifier


###################################################
### code chunk number 14: geNetClassifier-vignette.Rnw:177-179 (eval = FALSE)
###################################################
## library(leukemiasEset)
## data(leukemiasEset)


###################################################
### code chunk number 15: geNetClassifier-vignette.Rnw:183-185
###################################################
trainSamples <- c(1:10, 13:22, 25:34, 37:46, 49:58)
summary(leukemiasEset$LeukemiaType[trainSamples])


###################################################
### code chunk number 16: geNetClassifier-vignette.Rnw:218-219
###################################################
data(leukemiasClassifier) 


###################################################
### code chunk number 17: geNetClassifier-vignette.Rnw:223-226 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(leukEset_protCoding[,trainSamples],
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier",
## estimateGError=TRUE, geneLabels=geneSymbols)


###################################################
### code chunk number 18: geNetClassifier-vignette.Rnw:232-235 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier", 
## skipInteractions=TRUE, maxGenesTrain=20, geneLabels=geneSymbols)


###################################################
### code chunk number 19: geNetClassifier-vignette.Rnw:238-240 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier") 


###################################################
### code chunk number 20: geNetClassifier-vignette.Rnw:243-246 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier", 
## estimateGError=TRUE)


###################################################
### code chunk number 21: geNetClassifier-vignette.Rnw:259-261 (eval = FALSE)
###################################################
## getwd()
## save(leukemiasClassifier, file="leukemiasClassifier.RData") 


###################################################
### code chunk number 22: geNetClassifier-vignette.Rnw:269-270
###################################################
options(width=50)


###################################################
### code chunk number 23: geNetClassifier-vignette.Rnw:272-273
###################################################
names(leukemiasClassifier)


###################################################
### code chunk number 24: geNetClassifier-vignette.Rnw:275-276
###################################################
options(width=80)


###################################################
### code chunk number 25: geNetClassifier-vignette.Rnw:281-282
###################################################
leukemiasClassifier@call


###################################################
### code chunk number 26: geNetClassifier-vignette.Rnw:300-301
###################################################
leukemiasClassifier


###################################################
### code chunk number 27: geNetClassifier-vignette.Rnw:325-326
###################################################
leukemiasClassifier@genesRanking


###################################################
### code chunk number 28: geNetClassifier-vignette.Rnw:330-331
###################################################
numGenes(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 29: geNetClassifier-vignette.Rnw:335-336
###################################################
subRanking <- getTopRanking(leukemiasClassifier@genesRanking, 10)


###################################################
### code chunk number 30: geNetClassifier-vignette.Rnw:340-341
###################################################
getRanking(subRanking)


###################################################
### code chunk number 31: geNetClassifier-vignette.Rnw:344-345
###################################################
getRanking(subRanking, showGeneID=TRUE)$geneID[,1:4]


###################################################
### code chunk number 32: geNetClassifier-vignette.Rnw:351-352
###################################################
genesDetails(subRanking)$AML


###################################################
### code chunk number 33: geNetClassifier-vignette.Rnw:356-357 (eval = FALSE)
###################################################
## options(width=200)


###################################################
### code chunk number 34: geNetClassifier-vignette.Rnw:385-386
###################################################
numSignificantGenes(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 35: geNetClassifier-vignette.Rnw:390-391 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 36: geNetClassifier-vignette.Rnw:395-397 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking, 
## numGenesPlot=3000, lpThreshold=0.80)


###################################################
### code chunk number 37: geNetClassifier-vignette.Rnw:408-409
###################################################
leukemiasClassifier@classifier


###################################################
### code chunk number 38: geNetClassifier-vignette.Rnw:414-415
###################################################
leukemiasClassifier@classificationGenes


###################################################
### code chunk number 39: geNetClassifier-vignette.Rnw:417-419
###################################################
numGenes(leukemiasClassifier@classificationGenes)
genesDetails(leukemiasClassifier@classificationGenes)$ALL


###################################################
### code chunk number 40: geNetClassifier-vignette.Rnw:478-479
###################################################
leukemiasClassifier@generalizationError


###################################################
### code chunk number 41: geNetClassifier-vignette.Rnw:482-483 (eval = FALSE)
###################################################
## overview(leukemiasClassifier@generalizationError)


###################################################
### code chunk number 42: geNetClassifier-vignette.Rnw:489-490
###################################################
leukemiasClassifier@generalizationError@confMatrix


###################################################
### code chunk number 43: geNetClassifier-vignette.Rnw:494-495
###################################################
leukemiasClassifier@generalizationError@probMatrix


###################################################
### code chunk number 44: geNetClassifier-vignette.Rnw:504-505
###################################################
leukemiasClassifier@generalizationError@classificationGenes.stats$CLL


###################################################
### code chunk number 45: geNetClassifier-vignette.Rnw:510-511
###################################################
leukemiasClassifier@generalizationError@classificationGenes.num


###################################################
### code chunk number 46: geNetClassifier-vignette.Rnw:525-527
###################################################
leukemiasClassifier@genesNetwork
overview(leukemiasClassifier@genesNetwork$AML)


###################################################
### code chunk number 47: geNetClassifier-vignette.Rnw:532-534
###################################################
getNumEdges(leukemiasClassifier@genesNetwork$AML)
getNumNodes(leukemiasClassifier@genesNetwork$AML)


###################################################
### code chunk number 48: geNetClassifier-vignette.Rnw:536-538
###################################################
getEdges(leukemiasClassifier@genesNetwork$AML)[1:5,]
getNodes(leukemiasClassifier@genesNetwork$AML)[1:12]


###################################################
### code chunk number 49: geNetClassifier-vignette.Rnw:542-543 (eval = FALSE)
###################################################
## network2txt(leukemiasClassifier@genesNetwork, filePrefix="leukemiasNetwork")


###################################################
### code chunk number 50: geNetClassifier-vignette.Rnw:546-549 (eval = FALSE)
###################################################
## geneNtwsInfo <- lapply(leukemiasClassifier@genesNetwork, 
##     function(x) write.table(getEdges(x), 
##     file=paste("leukemiaNtw_",getEdges(x)[1,"class1"],".txt",sep="")))


###################################################
### code chunk number 51: geNetClassifier-vignette.Rnw:567-569
###################################################
testSamples <- c(1:60)[-trainSamples]
testSamples


###################################################
### code chunk number 52: geNetClassifier-vignette.Rnw:573-575
###################################################
queryResult <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples])


###################################################
### code chunk number 53: geNetClassifier-vignette.Rnw:579-581
###################################################
queryResult$class
queryResult$probabilities


###################################################
### code chunk number 54: geNetClassifier-vignette.Rnw:585-587
###################################################
confusionMatrix <- table(leukemiasEset[,testSamples]$LeukemiaType, 
queryResult$class)


###################################################
### code chunk number 55: geNetClassifier-vignette.Rnw:591-592
###################################################
externalValidation.stats(confusionMatrix)


###################################################
### code chunk number 56: geNetClassifier-vignette.Rnw:596-598
###################################################
externalValidation.probMatrix(queryResult, 
leukemiasEset[,testSamples]$LeukemiaType, numDecimals=3)


###################################################
### code chunk number 57: geNetClassifier-vignette.Rnw:611-614
###################################################
queryResult_AssignAll <- queryGeNetClassifier(leukemiasClassifier, 
    leukemiasEset[,testSamples], minProbAssignCoeff=0, minDiffAssignCoeff=0)
which(queryResult_AssignAll$class=="NotAssigned")


###################################################
### code chunk number 58: geNetClassifier-vignette.Rnw:619-622
###################################################
queryResult_AssignLess <- queryGeNetClassifier(leukemiasClassifier, 
    leukemiasEset[,testSamples], minProbAssignCoeff=1.5, minDiffAssignCoeff=1)
queryResult_AssignLess$class


###################################################
### code chunk number 59: geNetClassifier-vignette.Rnw:626-628
###################################################
t(queryResult_AssignLess$probabilities[,
    queryResult_AssignLess$class=="NotAssigned", drop=FALSE])


###################################################
### code chunk number 60: geNetClassifier-vignette.Rnw:649-650
###################################################
testSamples <- c(1:60)[-trainSamples]


###################################################
### code chunk number 61: geNetClassifier-vignette.Rnw:654-656
###################################################
queryResult_AsUnkown <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples])


###################################################
### code chunk number 62: geNetClassifier-vignette.Rnw:660-661
###################################################
names(queryResult_AsUnkown)


###################################################
### code chunk number 63: geNetClassifier-vignette.Rnw:663-664
###################################################
queryResult_AsUnkown$class


###################################################
### code chunk number 64: geNetClassifier-vignette.Rnw:668-670
###################################################
t(queryResult_AsUnkown$probabilities[ ,
queryResult$class=="NotAssigned"])


###################################################
### code chunk number 65: geNetClassifier-vignette.Rnw:674-675
###################################################
querySummary(queryResult_AsUnkown, numDecimals=3)


###################################################
### code chunk number 66: geNetClassifier-vignette.Rnw:686-687 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 67: geNetClassifier-vignette.Rnw:696-698 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking, numGenesPlot=3000, 
## plotTitle="5 classes: ALL, AML, CLL, CML, NoL", lpThreshold=0.80)


###################################################
### code chunk number 68: geNetClassifier-vignette.Rnw:709-711 (eval = FALSE)
###################################################
## ranking <- calculateGenesRanking(leukemiasEset[,trainSamples], 
## "LeukemiaType")


###################################################
### code chunk number 69: geNetClassifier-vignette.Rnw:721-722
###################################################
data(geneSymbols)


###################################################
### code chunk number 70: geNetClassifier-vignette.Rnw:724-730 (eval = FALSE)
###################################################
## data(geneSymbols)
## topGenes <- getRanking(
## getTopRanking(leukemiasClassifier@classificationGenes,numGenesClass=1), 
## showGeneID=TRUE)$geneID
## plotExpressionProfiles(leukemiasEset, topGenes[,c("ALL","AML"), drop=FALSE], 
##     sampleLabels="LeukemiaType", geneLabels=geneSymbols)


###################################################
### code chunk number 71: geNetClassifier-vignette.Rnw:741-743 (eval = FALSE)
###################################################
## plotExpressionProfiles(leukemiasEset[,trainSamples], leukemiasClassifier,
##     sampleLabels="LeukemiaType", fileName="leukExprs_trainSamples.pdf")


###################################################
### code chunk number 72: geNetClassifier-vignette.Rnw:747-751 (eval = FALSE)
###################################################
## classGenes <- getRanking(leukemiasClassifier@classificationGenes, 
##     showGeneID=TRUE)$geneID[,"AML"]
## plotExpressionProfiles(leukemiasEset, genes=classGenes, 
##     sampleLabels="LeukemiaType", geneLabels=geneSymbols, fileName="AML_genes.pdf")


###################################################
### code chunk number 73: geNetClassifier-vignette.Rnw:759-764 (eval = FALSE)
###################################################
## plotExpressionProfiles(leukemiasEset, genes=topGenes[,3, drop=FALSE], 
##                        sampleLabels="LeukemiaType", 
##                        showMean=TRUE, identify=FALSE,
##                        sampleColors=c("grey","red")
##                        [(sampleNames(leukemiasEset)%in% c("GSM331386.CEL","GSM331392.CEL"))+1])


###################################################
### code chunk number 74: geNetClassifier-vignette.Rnw:766-770 (eval = FALSE)
###################################################
## plotExpressionProfiles(leukemiasEset, genes=topGenes[,3, drop=FALSE], 
##                        sampleLabels="LeukemiaType", 
##                        showMean=TRUE, identify=FALSE,
##                        classColors=c("red","red", "blue","red","red"))


###################################################
### code chunk number 75: geNetClassifier-vignette.Rnw:777-780 (eval = FALSE)
###################################################
## plotExpressionProfiles(leukemiasEset, genes=topGenes[,3, drop=FALSE],
##                        sampleLabels="LeukemiaType", 
##                        type="boxplot", geneLabels=geneSymbols, sameScale=FALSE)


###################################################
### code chunk number 76: geNetClassifier-vignette.Rnw:800-802
###################################################
plotDiscriminantPower(leukemiasClassifier, 
classificationGenes="ENSG00000169575")


###################################################
### code chunk number 77: geNetClassifier-vignette.Rnw:806-808
###################################################
plotDiscriminantPower(leukemiasClassifier, 
classificationGenes="ENSG00000169575")


###################################################
### code chunk number 78: geNetClassifier-vignette.Rnw:816-819 (eval = FALSE)
###################################################
## discPowerTable <- plotDiscriminantPower(leukemiasClassifier, 
## classificationGenes=getRanking(leukemiasClassifier@classificationGenes,
## showGeneID=TRUE)$geneID[1:4,"AML",drop=FALSE], returnTable=TRUE)


###################################################
### code chunk number 79: geNetClassifier-vignette.Rnw:823-826
###################################################
discPowerTable <- plotDiscriminantPower(leukemiasClassifier, 
classificationGenes=getRanking(leukemiasClassifier@classificationGenes,
showGeneID=TRUE)$geneID[1:4,"AML",drop=FALSE], returnTable=TRUE)


###################################################
### code chunk number 80: geNetClassifier-vignette.Rnw:843-845
###################################################
clGenesSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, 
leukemiasClassifier@classificationGenes)


###################################################
### code chunk number 81: geNetClassifier-vignette.Rnw:856-857 (eval = FALSE)
###################################################
## clGenesInfo <- genesDetails(leukemiasClassifier@classificationGenes)


###################################################
### code chunk number 82: geNetClassifier-vignette.Rnw:867-868 (eval = FALSE)
###################################################
## plotNetwork(genesNetwork=clGenesSubNet$ALL, genesInfo=clGenesInfo)


###################################################
### code chunk number 83: geNetClassifier-vignette.Rnw:880-882 (eval = FALSE)
###################################################
## plotNetwork(genesNetwork=clGenesSubNet$ALL, genesInfo=clGenesInfo, 
## plotAllNodesNetwork=FALSE, plotOnlyConnectedNodesNetwork=TRUE)


###################################################
### code chunk number 84: geNetClassifier-vignette.Rnw:886-892 (eval = FALSE)
###################################################
## top30g <- getRanking(leukemiasClassifier@genesRanking, 
## showGeneID=TRUE)$geneID[1:30,]
## top30gSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, top30g)
## top30gInfo <- lapply(genesDetails(leukemiasClassifier@genesRanking), 
## function(x) x[1:30,])
## plotNetwork(genesNetwork=top30gSubNet$AML, genesInfo=top30gInfo$AML)


###################################################
### code chunk number 85: geNetClassifier-vignette.Rnw:905-914 (eval = FALSE)
###################################################
## top100gRanking <- getTopRanking(leukemiasClassifier@genesRanking, 
## numGenes=100)
## top100gSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, 
## getRanking(top100gRanking, showGeneID=TRUE)$geneID)
## plotNetwork(genesNetwork=top100gSubNet, 
## classificationGenes=leukemiasClassifier@classificationGenes, 
## genesRanking=top100gRanking, plotAllNodesNetwork=TRUE, 
## plotOnlyConnectedNodesNetwork=TRUE, labelSize=0.4, 
## plotType="pdf", fileName="leukemiasNetwork")


