### R code from vignette source 'flowCL.Rnw'

###################################################
### code chunk number 1: loadlibs
###################################################
library("flowCL")


###################################################
### code chunk number 2: Load_archive
###################################################
flowCL("Archive")


###################################################
### code chunk number 3: Date
###################################################
flowCL("Date")


###################################################
### code chunk number 4: CCR7+CD45RA+_with_visual
###################################################
Res <- flowCL("CCR7+CD45RA+")
Res$Table
tmp <- Res$'CCR7+CD45RA+'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])


###################################################
### code chunk number 5: CCR7+CD45RA+_without_visual
###################################################
Res <- flowCL("CCR7+CD45RA+", VisualSkip = TRUE, ResetArch=FALSE, KeepArch=TRUE)


###################################################
### code chunk number 6: CCR7+CD45RA+CD8+
###################################################
Res <- flowCL("CD3+CD4+CD8-CCR7-CD45RA+", CompInfo = TRUE, OntolNamesTD = TRUE)
tmp <- Res$'CD3+CD4+CD8-CCR7-CD45RA+'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])


###################################################
### code chunk number 7: HIPC1
###################################################
Res <- flowCL(c("CD3-CD19-CD20-CD14-HLA-DR-CD16-CD56hi", "CD3+CD4-CD8+CCR7-CD45RA+"))
tmp <- Res$'CD3-CD19-CD20-CD14-HLA-DR-CD16-CD56hi'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])
Res$Cell_Labels$'CD3-CD19-CD20-CD14-HLA-DR-CD16-CD56hi'
Res$Ranking$'CD3-CD19-CD20-CD14-HLA-DR-CD16-CD56hi'
Res$Markers$'CD3-CD19-CD20-CD14-HLA-DR-CD16-CD56hi'


###################################################
### code chunk number 8: HIPC2
###################################################
tmp <- Res$'CD3+CD4-CD8+CCR7-CD45RA+'
plot(tmp[[1]], nodeAttrs=tmp[[2]], edgeAttrs=tmp[[3]], attrs=tmp[[4]])
Res$Cell_Labels$'CD3+CD4-CD8+CCR7-CD45RA+'
Res$Ranking$'CD3+CD4-CD8+CCR7-CD45RA+'
Res$Markers$'CD3+CD4-CD8+CCR7-CD45RA+'


###################################################
### code chunk number 9: CD3+CD4+CD8-CCR7-CD45RA-
###################################################
x <-"CD3+CD4+CD8-CCR7-CD45RA-"
Res <- flowCL(x)
Res$Cell_Label[[x]][[1]]


