## ----import_data, message=FALSE------------------------------------------
library(cogena)
data(PD)
# Three objects in the PD dataset and one in AllGeneSymbols dataset.

## ----PD_data, echo=FALSE-------------------------------------------------
ls()

## ----gene_list_annotation------------------------------------------------
annoGMT <- "c2.cp.kegg.v4.0.symbols.gmt"
annofile <- system.file("extdata", annoGMT, package="cogena")

## ----cogena, results="hide"----------------------------------------------
# the number of clusters. It could be a vector.
nClust <- 2:8
# the number of cores.
ncore <- 2
# the clustering methods
clMethods <- c("hierarchical","kmeans")
# the distance metric
metric <- "correlation"
# the agglomeration method used for hierarchical clustering 
#(hierarchical and agnes)
method <- "complete"

# the cogena analysis
cogena_result <- cogena(DEexprs, nClust=nClust, clMethods=clMethods, 
    metric=metric, method=method,  annofile=annofile, 
    sampleLabel=sampleLabel, ncore=ncore, verbose=TRUE)

## ----cogena_result_analysis----------------------------------------------
summary(cogena_result)
score <- optCluster(cogena_result, ncores=1)
#choose optimun based on cluster I.
#score <- optCluster(cogena_result, based="I", ncores=1)

## ----score, echo=FALSE, results='asis'-----------------------------------
knitr::kable(score)

## ----enrichment----------------------------------------------------------
#Here we consider the "hierarchical" method and 6 clusters as the optimum.
#Always make the number as character, please!
enrichment.table <- enrichment(cogena_result, "hierarchical", "6")

## ----heatmapPEI, fig.width=10, fig.height=6, fig.cap="KEGG pathway enrichment"----
#The values shown in Figure 2. is the -log2 (p-values).
#Always make the number as character, please!
heatmapPEI(cogena_result, "hierarchical", "6", printGS=FALSE)
#ordered by the Cluster I.
#heatmapPEI(cogena_result, "hierarchical", "6", orderMethod = "I")

## ----heatmapCluster, fig.width=10, fig.height=7, fig.cap="Heatmap of expression profiling with clusters"----
#Always make the number as character, please!
heatmapCluster(cogena_result, "hierarchical", "6")

## ----geneInCluster-------------------------------------------------------
#Always make the number as character, please!
head(geneInCluster(cogena_result, "hierarchical", "6", "2"))

## ----geneExpInCluster----------------------------------------------------
#Always make the number as character, please!
gec <- geneExpInCluster(cogena_result, "hierarchical", "6")
head(gec$clusterGeneExp, 3)
gec$label

## ----corInCluster, fig.width=6, fig.height=6, fig.cap="Correlation"------
#Always make the number as character, please!
corInCluster(cogena_result, "hierarchical", "8", "8")

## ----sessionInfo, echo=FALSE---------------------------------------------
sessionInfo()

