## ----style, eval=TRUE, echo=FALSE,results="asis"----------------------------------------
#library("BiocStyle")
BiocStyle::latex()

## ----setup, include=FALSE, cache=FALSE, echo=F------------------------------------------
library(knitr)
opts_chunk$set(fig.path='figure/minimal-', fig.align='center', fig.show='hold')
options(replace.assign=TRUE,width=90)

## ----citatation-------------------------------------------------------------------------
citation(package='coMET')

## ----installPackages,eval=FALSE---------------------------------------------------------
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("coMET")

## ----dd,echo=FALSE,eval=FALSE-----------------------------------------------------------
#  require("hash")
#  require("grid")
#  require("grDevices")
#  require("biomaRt")
#  require("Gviz")
#  require("ggbio")
#  require("rtracklayer")
#  require("GenomicRanges")
#  require("colortools")
#  require("gridExtra")
#  require("ggplot2")
#  require("trackViewer")
#  require("psych")
#  
#  rdir <- system.file("R", package="coMET",mustWork=TRUE)
#  source(file.path(rdir, "AnalyseFile.R"))
#  source(file.path(rdir, "BiofeatureGraphics.R"))
#  source(file.path(rdir, "comet.R"))
#  source(file.path(rdir, "cometWeb.R"))
#  source(file.path(rdir, "DrawPlot.R"))
#  source(file.path(rdir, "GeneralMethodComet.R"))

## ----loadPackages, eval=TRUE------------------------------------------------------------
library("coMET")

## ----findHel, eval=FALSE----------------------------------------------------------------
#  ?comet
#  ?comet.web
#  ?comet.list

## ----installPackages_develbioc,eval=FALSE-----------------------------------------------
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("coMET")

## ----installPackages_develversion,eval=FALSE--------------------------------------------
#  install.packages("YourPath/coMET_YourVersion.tar.gz",repos=NULL,type="source")
#  ##This is an example
#  install.packages("YourPath/coMET_0.99.9.tar.gz",repos=NULL,type="source")

## ----Filedata---------------------------------------------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
infofile <- file.path(extdata, "cyp1b1_infofile.txt")

data_info <-read.csv(infofile, header = TRUE,
                     sep = "\t", quote = "")

head(data_info)

## ----expMatrix--------------------------------------------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
infoexp <- file.path(extdata, "cyp1b1_infofile_exprGene_region.txt")

data_infoexp <-read.csv(infoexp, header = TRUE,
                        sep = "\t", quote = "")

head(data_infoexp)

## ----corrMatrix-------------------------------------------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
corfile <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")

data_cor <-read.csv(corfile, header = TRUE,
                    sep = "\t", quote = "")
data_cor[1:6,1:6]

## ----configMatrix-----------------------------------------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
configfile <- file.path(extdata, "config_cyp1b1_zoom_4webserver.txt")

data_config <-read.csv(configfile, quote = "", sep="\t", header=FALSE)
data_config

## ----cometwebPlotText, eval=FALSE, fig.keep='last'--------------------------------------
#  extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
#  myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
#  myexpressfile <- file.path(extdata, "cyp1b1_infofile_exprGene_region.txt")
#  mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")
#  configfile <- file.path(extdata, "config_cyp1b1_zoom_4webserver.txt")
#  comet.web(config.file=configfile, mydata.file=myinfofile,
#            cormatrix.file=mycorrelation ,mydata.large.file=myexpressfile,
#            print.image=FALSE,verbose=FALSE)

## ----cometwebPlot, echo=FALSE, fig.keep='last'------------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
myexpressfile <- file.path(extdata, "cyp1b1_infofile_exprGene_region.txt")
mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt") 
configfile <- file.path(extdata, "config_cyp1b1_zoom_4webserver.txt")
comet.web(config.file=configfile, mydata.file=myinfofile, cormatrix.file=mycorrelation,
          mydata.large.file=myexpressfile, print.image=FALSE,verbose=FALSE)

## ----cometPlotText, eval=FALSE, fig.keep='last'-----------------------------------------
#  extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
#  configfile <- file.path(extdata, "config_cyp1b1_zoom_4comet.txt")
#  myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
#  myexpressfile <- file.path(extdata, "cyp1b1_infofile_exprGene_region.txt")
#  mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")
#  
#  chrom <- "chr2"
#  start <- 38290160
#  end <- 38303219
#  gen <- "hg19"
#  strand <- "*"
#  
#  BROWSER.SESSION="UCSC"
#  mySession <- browserSession(BROWSER.SESSION)
#  genome(mySession) <- gen
#  
#  genetrack <-genesENSEMBL(gen,chrom,start,end,showId=TRUE)
#  snptrack <- snpBiomart(chrom, start, end, dataset="hsapiens_snp_som",showId=FALSE)
#  iscatrack <-ISCATrack(gen,chrom,start,end,mySession, table="iscaPathogenic")
#  
#  listgviz <- list(genetrack,snptrack,iscatrack)
#  
#  comet(config.file=configfile, mydata.file=myinfofile, mydata.type="file",
#        cormatrix.file=mycorrelation,  cormatrix.type="listfile",
#        mydata.large.file=myexpressfile, mydata.large.type="listfile",
#        tracks.gviz=listgviz, verbose=FALSE, print.image=FALSE)

## ----cometPlotfile, echo=FALSE, fig.keep='last'-----------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
configfile <- file.path(extdata, "config_cyp1b1_zoom_4comet.txt")
myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
myexpressfile <- file.path(extdata, "cyp1b1_infofile_exprGene_region.txt")
mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")

#configfile <- "../inst/extdata/config_cyp1b1_zoom_4comet.txt" 
chrom <- "chr2"
start <- 38290160
end <- 38303219
gen <- "hg19"
strand <- "*"

data(geneENSEMBLtrack)
data(snpBiomarttrack)
data(ISCAtrack)

listgviz <- list(genetrack,snptrack,iscatrack)

comet(config.file=configfile, mydata.file=myinfofile, mydata.type="file",
      cormatrix.file=mycorrelation,  cormatrix.type="listfile",
      mydata.large.file=myexpressfile, mydata.large.type="listfile",
      tracks.gviz=listgviz, verbose=FALSE, print.image=FALSE)

## ----cometPlotmatrix, eval=FALSE, fig.keep='last'---------------------------------------
#  extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
#  configfile <- file.path(extdata, "config_cyp1b1_zoom_4comet.txt")
#  myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
#  myexpressfile <- file.path(extdata, "cyp1b1_infofile_exprGene_region.txt")
#  mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")
#  
#  chrom <- "chr2"
#  start <- 38290160
#  end <- 38303219
#  gen <- "hg19"
#  strand <- "*"
#  
#  BROWSER.SESSION="UCSC"
#  mySession <- browserSession(BROWSER.SESSION)
#  genome(mySession) <- gen
#  
#  genetrack <-genesENSEMBL(gen,chrom,start,end,showId=TRUE)
#  snptrack <- snpBiomart(chrom, start, end, dataset="hsapiens_snp_som",showId=FALSE)
#  iscatrack <-ISCATrack(gen,chrom,start,end,mySession, table="iscaPathogenic")
#  
#  listgviz <- list(genetrack,snptrack,iscatrack)
#  
#  matrix.dnamethylation <- read.delim(myinfofile, header=TRUE, sep="\t", as.is=TRUE,
#                                      blank.lines.skip = TRUE, fill=TRUE)
#  matrix.expression <- read.delim(myexpressfile, header=TRUE, sep="\t", as.is=TRUE,
#                                  blank.lines.skip = TRUE, fill=TRUE)
#  cormatrix.data.raw <- read.delim(mycorrelation, sep="\t", header=TRUE, as.is=TRUE,
#                                   blank.lines.skip = TRUE, fill=TRUE)
#  
#  listmatrix.expression <- list(matrix.expression)
#  listcormatrix.data.raw <- list(cormatrix.data.raw)
#  comet(config.file=configfile, mydata.file=matrix.dnamethylation,
#        mydata.type="dataframe",cormatrix.file=listcormatrix.data.raw,
#        cormatrix.type="listdataframe",cormatrix.sig.level=0.05,
#        cormatrix.conf.level=0.05, cormatrix.adjust="BH",
#        mydata.large.file=listmatrix.expression, mydata.large.type="listdataframe",
#        tracks.gviz=listgviz,verbose=FALSE, print.image=FALSE)

## ----cometPlotMatrix, echo=FALSE, fig.keep='last'---------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
configfile <- file.path(extdata, "config_cyp1b1_zoom_4comet.txt")
myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
myexpressfile <- file.path(extdata, "cyp1b1_infofile_exprGene_region.txt")
mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")

#configfile <- "../inst/extdata/config_cyp1b1_zoom_4comet.txt" 
chrom <- "chr2"
start <- 38290160
end <- 38303219
gen <- "hg19"
strand <- "*"

data(geneENSEMBLtrack)
data(snpBiomarttrack)
data(ISCAtrack)

listgviz <- list(genetrack,snptrack,iscatrack)

matrix.dnamethylation <- read.delim(myinfofile, header=TRUE, sep="\t", as.is=TRUE, blank.lines.skip = TRUE, fill=TRUE)
matrix.expression <- read.delim(myexpressfile, header=TRUE, sep="\t", as.is=TRUE, blank.lines.skip = TRUE, fill=TRUE)
cormatrix.data.raw <- read.delim(mycorrelation, sep="\t", header=TRUE, as.is=TRUE, blank.lines.skip = TRUE, fill=TRUE)

listmatrix.expression <- list(matrix.expression)
listcormatrix.data.raw <- list(cormatrix.data.raw)
comet(config.file=configfile, mydata.file=matrix.dnamethylation, 
      mydata.type="dataframe",cormatrix.file=listcormatrix.data.raw,
      cormatrix.type="listdataframe",cormatrix.sig.level=0.05,
      cormatrix.conf.level=0.05, cormatrix.adjust="BH",
      mydata.large.file=listmatrix.expression, mydata.large.type="listdataframe",
      tracks.gviz=listgviz,verbose=FALSE, print.image=FALSE)

## ----cometPlotNopvalText, eval=FALSE, fig.keep='last'-----------------------------------
#  extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
#  configfile <- file.path(extdata, "config_cyp1b1_zoom_4cometnopval.txt")
#  myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
#  mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")
#  
#  chrom <- "chr2"
#  start <- 38290160
#  end <- 38303219
#  gen <- "hg19"
#  strand <- "*"
#  
#  genetrack <-genesENSEMBL(gen,chrom,start,end,showId=FALSE)
#  snptrack <- snpBiomart(chrom, start, end,
#                         dataset="hsapiens_snp_som",showId=FALSE)
#  strutrack <- structureBiomart(chrom, start, end,
#                                strand, dataset="hsapiens_structvar_som")
#  clinVariant<-ClinVarMainTrack(gen,chrom,start,end)
#  clinCNV<-ClinVarCnvTrack(gen,chrom,start,end)
#  gwastrack <-GWASTrack(gen,chrom,start,end)
#  geneRtrack <-GeneReviewsTrack(gen,chrom,start,end)
#  
#  listgviz <- list(genetrack,snptrack,strutrack,clinVariant,
#                   clinCNV,gwastrack,geneRtrack)
#  comet(config.file=configfile, mydata.file=myinfofile, mydata.type="file",
#        cormatrix.file=mycorrelation, cormatrix.type="listfile",
#        tracks.gviz=listgviz, verbose=FALSE, print.image=FALSE,disp.pvalueplot=FALSE)

## ----cometPlot_nopval, echo=FALSE, fig.keep='last'--------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
configfile <- file.path(extdata, "config_cyp1b1_zoom_4cometnopval.txt")
#configfile <- "../inst/extdata/config_cyp1b1_zoom_4comet.txt" 
myinfofile <- file.path(extdata, "cyp1b1_infofile.txt")
mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")

chrom <- "chr2"
start <- 38290160
end <- 38303219
gen <- "hg19"
strand <- "*"

data(geneENSEMBLtrack)
data(snpBiomarttrack)
data(strucBiomarttrack)
data(ClinVarCnvTrack)
data(clinVarMaintrack)
data(GWASTrack)
data(GeneReviewTrack)

listgviz <- list(genetrack,snptrack,strutrack,clinVariant,
                 clinCNV,gwastrack,geneRtrack)
comet(config.file=configfile, mydata.file=myinfofile, mydata.type="file",
      cormatrix.file=mycorrelation, cormatrix.type="listfile",
      tracks.gviz=listgviz, verbose=FALSE, print.image=FALSE,disp.pvalueplot=FALSE)

## ----cometlist--------------------------------------------------------------------------
extdata <- system.file("extdata", package="coMET",mustWork=TRUE)
mycorrelation <- file.path(extdata, "cyp1b1_res37_rawMatrix.txt")
myoutput <- file.path(extdata, "cyp1b1_res37_cormatrix_list_BH05.txt")


comet.list(cormatrix.file=mycorrelation,cormatrix.method = "spearman",
           cormatrix.format= "raw", cormatrix.conf.level=0.05,
           cormatrix.sig.level= 0.05, cormatrix.adjust="BH",
           cormatrix.type = "listfile", cormatrix.output=myoutput, 
           verbose=FALSE)

listcorr <- read.csv(myoutput, header = TRUE,
                     sep = "\t", quote = "")
dim(listcorr)
head(listcorr)

## ----session-info, results="asis"-------------------------------------------------------
toLatex(sessionInfo())

