################################################################################
## This is just a set of scripts that will get IDs that match with entrez gene
## IDs and then populate them into a DB.

## Call this script from src_build.sh, and AFTER organism_annotation/script.sh

## 1) Get a set of entrez gene IDs for a species (and tax ID) (
## (extract ALL of this information from the relevant chipsrc DB)

library("RSQLite")
library("UniProt.ws")
##Connect to the DB
drv <- dbDriver("SQLite")

## Path to all the Db's.
dir <- file.path("/mnt/cpb_anno/mcarlson/proj/mcarlson/sqliteGen/annosrc/db")
## ## Use this one (temporarily while the /db rebuilds)
## dir <- file.path("/home/mcarlson/arch/x86_64/R-devel/library/human.db0/extdata")
    


## For now just get data for the ones that we have traditionally supported
## I don't even know if the other species are available...
speciesList = c("chipsrc_human.sqlite",
  "chipsrc_rat.sqlite",
  "chipsrc_chicken.sqlite",
  "chipsrc_zebrafish.sqlite",
  #  "chipsrc_worm.sqlite",
  #  "chipsrc_fly.sqlite",
  "chipsrc_mouse.sqlite",
  "chipsrc_bovine.sqlite"#,
  #  "chipsrc_arabidopsis.sqlite"  ## this is available and could be "activated"
  ## But to activate arabidopsis, remember you have to pre-add the tables...
  #  "chipsrc_canine.sqlite",
  #  "chipsrc_rhesus.sqlite",
  #  "chipsrc_chimp.sqlite",
  #  "chipsrc_anopheles.sqlite"
  )

## ## temp for testing:
## speciesList = c("chipsrc_human.sqlite")
## speciesList = c("chipsrc_arabidopsis.sqlite")


## 2) use the package accessors to get all the relevant data back (IPI, PFAM
## and Prosite IDs).

## 3) AND: merge all these frames together into two data frames:
## SO        gene_id, ipi_id, pfam_id
## & ALSO    gene_id, ipi_id, prosite_id


## getuniProtAndIPIs <- function(genes){
  
##   ## get the UniProt IDs.
##   ## issue: URI is too large, so I need a helper since I will have to do this
##   ## in pieces...  - and actually, helper mapUniprot should do that
##   ## automagically.
##   ups <- UniProt.ws:::mapUniprot(from='P_ENTREZGENEID',to='ACC',query=genes)
##   ## get the IPI IDs
##   upKeys <- as.character(t(ups$ACC))

##   ## This no longer will work (UniProt no longer supports IPI accessions)
##   ## ips <- UniProt.ws:::mapUniprot(from='ACC',to='P_IPI', upKeys)
##   ## SO I NEED a NEW way to get the IPI IDs associated with uniprot ACCs.
  
  
##   ## return as a single frame.
##   ## Currently, I use an inner join here b/c DB is gene centric 
##   base <- merge(ups, ips, by.x ="ACC", by.y ="ACC")#, all=TRUE)
##   base
  
## }

## Modified to get uniprots where we may not have an IPI
getuniProtAndIPIs <- function(genes, dbFile){

  ups <- UniProt.ws:::mapUniprot(from='P_ENTREZGENEID',to='ACC',query=genes)
  ## get the IPI IDs
  ##upKeys <- as.character(t(ups$ACC))


  ## NOW hack in the old IPI data
  baseDir = '/mnt/cpb_anno/mcarlson/proj/mcarlson/sqliteGen/annosrc/uniprot/TEMPOLDCHIPSRC'
  con <- dbConnect(drv,dbname=file.path(baseDir, dbFile))
  pf_ipi <- dbGetQuery(con, 'select g.gene_id AS P_ENTREZGENEID, p.ipi_id AS P_IPI from pfam AS p, genes AS g WHERE p._id=g._id')
  ps_ipi <- dbGetQuery(con, 'select g.gene_id AS P_ENTREZGENEID, p.ipi_id AS P_IPI from prosite AS p, genes AS g WHERE p._id=g._id')
  ips <- unique(rbind(pf_ipi, ps_ipi))
  
  ## return as a single frame.
  ## Currently, I use an inner join here b/c DB is gene centric 
  base <- merge(ups, ips, by.x ="P_ENTREZGENEID", by.y ="P_ENTREZGENEID", all.x=TRUE)
  base
}


## Maybe have to stop using getOneToMany here and start with this instead (slower) ???
## taxId(UniProt.ws) <- curTaxId
## k <- keys(UniProt.ws, keytype="UNIPROTKB")
## select(UniProt.ws, k, columns="PFAM", keytype="UNIPROTKB")

getData <- function(dbFile, db){
  ## look up the tax ID
  taxId <- dbGetQuery(db, "SELECT value FROM metadata WHERE name='TAXID'")
  ## look up the entrez gene IDs
  if(dbFile != "chipsrc_arabidopsis.sqlite"){ ## if its not arabidopsis
    genes <- dbGetQuery(db, "SELECT gene_id FROM genes")
  }else{
    genes <- dbGetQuery(db, "SELECT gene_id FROM entrez_genes")
  }
  genes <- as.character(t(genes))

  ## ## get the UniProt and IPI Id's (merged into a table)
  base <- getuniProtAndIPIs(genes, dbFile)
  ## NO MORE IPIs! (temporarily we will populate with values from last time)
  
  ## get the pfam Id's
  pfam <- UniProt.ws:::getOneToMany(taxId, type="PFAM")
  colnames(pfam) <- c("ACC", "PFAM")
  ## and the prosite Id's.
  prosite <- UniProt.ws:::getOneToMany(taxId, type="prosite")
  colnames(prosite) <- c("ACC", "PROSITE")
  
  
  
  ## merge it all together. # 3 above - then return a list of length two
  ## Currently I am using an inner join here b/c the DB is gene centric, so
  ## there is no benefit fo haveing pfam/UniProt accessions that are not
  ## connected to an entrez gene
  lst <- list()
  lst[[1]] <- merge(base, pfam, by.x="ACC", by.y="ACC") #,all=TRUE)
  lst[[2]] <- merge(base, prosite, by.x="ACC", by.y="ACC") #,all=TRUE)
  names(lst) <- c("pfam","prosite")

## finally, be sure to drop the UniProt IDS?  I think we should keep
## em...  ;) Later on I can make use of them to enhance the devel annots.
  lst
}


## ## make PFAM and Prosite tables
makePFAMandPrositeTables <- function(db){
    dbGetQuery(db, "DROP TABLE IF EXISTS pfam;")
    sql <-  "CREATE TABLE pfam (
     _id INTEGER REFERENCES genes(_id),
     ipi_id TEXT,
     pfam_id TEXT
    );"
    dbGetQuery(db, sql)
    sql <-  "CREATE INDEX c20 ON pfam(_id);"
    dbGetQuery(db, sql)
    dbGetQuery(db, "DROP TABLE IF EXISTS prosite;")
    sql <-  "CREATE TABLE prosite (
     _id INTEGER REFERENCES genes(_id),
     ipi_id TEXT,
     prosite_id TEXT
    );"
    dbGetQuery(db, sql)
    sql <-  "CREATE INDEX c21 ON prosite(_id);"
    dbGetQuery(db, sql)
}


## 4) For each species, get the data, using getData, and then go
## straight to humansrc.sqlite etc and populate the pfam and prosite
## tables. ALSO, be sure to add entries to metadata about where the data came
## from.  (and remove relevant code from the scripts).  - See the bindb.R
## script in ensembl/script.


## Helper for doing inserts from pfam
doInserts <- function(db, table, data){

  ## make a temp pfam table pfamt
  sqlDrop <-paste0("DROP TABLE IF EXISTS ",table,"t;")
  dbGetQuery(db, sqlDrop)

  sqlCreate <- paste0("CREATE TABLE ",table,"t (
                gene_id TEXT,
                ipi_id TEXT,
                ",table,"_id TEXT);")
  dbGetQuery(db, sqlCreate)

  
  ## 1st insert for pfam
  sqlIns <- paste0("INSERT into ",table,"t
             (gene_id, ipi_id, ",table,"_id)
             VALUES ($P_ENTREZGENEID,$P_IPI,$",toupper(table),")")
  dbBegin(db)
  rset <- dbSendPreparedQuery(db, sqlIns, data)
  dbClearResult(rset)
  dbCommit(db)

  ## then insert into the real pfam table
  sqlIns2 <- paste0("INSERT INTO ",table,"
                SELECT DISTINCT g._id as _id, i.ipi_id, i.",table,"_id
                FROM genes as g, ",table,"t as i
                WHERE g.gene_id=i.gene_id
                ORDER BY _id")
  dbGetQuery(db, sqlIns2)

  
  ## then drop the table
  sqlDrop <- paste0("DROP TABLE ",table,"t")
  dbGetQuery(db, sqlDrop)
  
}


## So: loop, where we call getData and then just populate the tables
require("RSQLite")

for(species in speciesList){

  ## DB connection
  db <- dbConnect(drv,dbname=file.path(dir, species))
  
  message("Getting data for:",species)
  res <- getData(species, db) 

  message("Making tables for pfam and prosite")
  makePFAMandPrositeTables(db)
  
  message("Inserting data for:",species)
  ## Now I need to insert the data:
  doInserts(db, "pfam", res[["pfam"]])
  doInserts(db, "prosite", res[["prosite"]])
  
  ## And then I need to add metadata:
  date <- date()
  url <- "http://www.UniProt.org/"
  name <- "Uniprot"
  
  dbGetQuery(db, "DELETE FROM metadata where name ='UPSOURCENAME' ")   
  sqlMeta1 <- paste0("INSERT INTO metadata (name,value) VALUES ('UPSOURCENAME','",name,"')")
  dbGetQuery(db, sqlMeta1)
  
  dbGetQuery(db, "DELETE FROM metadata where name ='UPSOURCEURL' ")   
  sqlMeta2 <- paste0("INSERT INTO metadata (name,value) VALUES ('UPSOURCEURL','",url,"')")
  dbGetQuery(db, sqlMeta2)
  
  dbGetQuery(db, "DELETE FROM metadata where name ='UPSOURCEDATE' ")   
  sqlMeta3 <- paste0("INSERT INTO metadata (name,value) VALUES ('UPSOURCEDATE','",date,"')")
  dbGetQuery(db, sqlMeta3)
  dbGetQuery(db,"DELETE FROM metadata WHERE name LIKE 'IPISOURCE%'")

  
  ## And don't forget the map_counts for PROSITE AND PFAM
  dbGetQuery(db, "DELETE FROM map_counts where map_name ='PFAM' ")   
  sqlmapcnt1 <- "INSERT INTO map_counts
                 SELECT 'PFAM', count(DISTINCT _id)
                 FROM pfam;"
  dbGetQuery(db, sqlmapcnt1)

  dbGetQuery(db, "DELETE FROM map_counts where map_name ='PROSITE' ")   
  sqlmapcnt2 <- "INSERT INTO map_counts
                 SELECT 'PROSITE', count(DISTINCT _id)
                 FROM prosite;"
  dbGetQuery(db, sqlmapcnt2)

  ## ALSO: modify the map_metadata (1st drop the PFAM and prosite entries
  dbGetQuery(db, "DELETE FROM map_metadata where map_name ='PFAM' ") 
  dbGetQuery(db, "DELETE FROM map_metadata where map_name ='PROSITE' ")
  ## then put our own entries in...
  sqlPFMM <- paste0( "INSERT INTO map_metadata (map_name, source_name, ",
                    "source_url, source_date) VALUES ('PFAM','",name,
                    "','",url,"','",date,"')")
  dbGetQuery(db, sqlPFMM)
  sqlPSMM <- paste0( "INSERT INTO map_metadata (map_name, source_name, ",
                    "source_url, source_date) VALUES ('PROSITE','",name,
                    "','",url,"','",date,"')")
  dbGetQuery(db, sqlPSMM)
  
}



## 5) ALSO: Be sure to also add metadata to each DB as we loop!


## 6) ALSO: Be sure to add map counts for PFAM and PROSITE too.













################################################################################
################################################################################
################################################################################
################################################################################
## Now for special treatment for missing stuff from yeast.
################################################################################
################################################################################
################################################################################
################################################################################






getuniProt <- function(genes, dbFile){
    UniProt.ws:::mapUniprot(from='P_ENTREZGENEID',to='ACC',query=genes)
}


getYeastData <- function(dbFile, db){
  ## look up the tax ID
  taxId <- dbGetQuery(db, "SELECT value FROM metadata WHERE name='TAXID'")
  ## look up the entrez gene IDs
  genes <- dbGetQuery(db, "SELECT gene_id FROM genes")
  genes <- as.character(t(genes))

  ## ## get the UniProt
  base <- getuniProt(genes, dbFile)
  
  ## get the pfam Id's
  pfam <- UniProt.ws:::getOneToMany(taxId, type="PFAM")
  colnames(pfam) <- c("ACC", "PFAM")
  pfam <- pfam[!is.na(pfam$PFAM),]
  ## And smart IDs
  smart <- UniProt.ws:::getOneToMany(taxId, type="SMART")
  colnames(smart) <- c("ACC", "SMART")
  smart <- smart[!is.na(smart$SMART),]
  
  
  ## merge it all together. # 3 above - then return a list of length two
  ## Currently I am using an inner join here b/c the DB is gene centric, so
  ## there is no benefit fo haveing pfam/UniProt accessions that are not
  ## connected to an entrez gene
  lst <- list()
  lst[[1]] <- merge(base, pfam, by.x="ACC", by.y="ACC") #,all=TRUE)
  lst[[2]] <- merge(base, smart, by.x="ACC", by.y="ACC") #,all=TRUE)
  names(lst) <- c("pfam","smart")

## finally, be sure to drop the UniProt IDS?  I think we should keep
## em...  ;) Later on I can make use of them to enhance the devel annots.
  lst
}



doYeastInserts <- function(db, table, data){

  ## make a temp pfam table pfamt
  sqlDrop <-paste0("DROP TABLE IF EXISTS ",table,"t;")
  dbGetQuery(db, sqlDrop)

  sqlCreate <- paste0("CREATE TABLE ",table,"t (
                gene_id TEXT,
                ",table,"_id TEXT);")
  dbGetQuery(db, sqlCreate)
  
  ## 1st insert
  sqlIns <- paste0("INSERT into ",table,"t
             (gene_id, ",table,"_id)
             VALUES ($P_ENTREZGENEID,$",toupper(table),")")
  dbBegin(db)
  rset <- dbSendPreparedQuery(db, sqlIns, data)
  dbClearResult(rset)
  dbCommit(db)

  ## then insert into the real table
  sqlIns2 <- paste0("INSERT INTO ",table,"
                SELECT DISTINCT g._id as _id, i.",table,"_id
                FROM genes as g, ",table,"t as i
                WHERE g.gene_id=i.gene_id
                ORDER BY _id")
  dbGetQuery(db, sqlIns2)

  ## then drop the table
  sqlDrop <- paste0("DROP TABLE ",table,"t")
  dbGetQuery(db, sqlDrop)
  
}


## just one more run through to just do what is needed to get pfam into yeast.

species <- 'chipsrc_yeast.sqlite'
## DB connection
db <- dbConnect(drv,dbname=file.path(dir, species))
message("Getting data for:",species)
res <- getYeastData(species, db) 

## Add pfam table
message("Making table for pfam") 
dbGetQuery(db, "DROP TABLE IF EXISTS pfam;")
sql <-  "CREATE TABLE pfam (
     _id INTEGER NOT NULL,
     pfam_id CHAR(7) NOT NULL,
     FOREIGN KEY (_id) REFERENCES sgd (_id)
    );"
dbGetQuery(db, sql)
sql <-  "CREATE INDEX pf1 ON pfam(_id);"
dbGetQuery(db, sql)

## And a smart table too
message("Making table for smart") 
dbGetQuery(db, "DROP TABLE IF EXISTS smart;")
sql <-  "CREATE TABLE smart (
     _id INTEGER NOT NULL,
     smart_id CHAR(7) NOT NULL,
     FOREIGN KEY (_id) REFERENCES sgd (_id)
    );"
dbGetQuery(db, sql)
sql <-  "CREATE INDEX sm1 ON smart(_id);"
dbGetQuery(db, sql)




message("Inserting data for:",species)
## Now I need to insert the data:
doYeastInserts(db, "pfam", res[["pfam"]])
doYeastInserts(db, "smart", res[["smart"]])
  
## And then I need to add metadata:
date <- date()
url <- "http://www.UniProt.org/"
name <- "Uniprot"
  
dbGetQuery(db, "DELETE FROM metadata where name ='UPSOURCENAME' ")   
sqlMeta1 <- paste0("INSERT INTO metadata (name,value) VALUES ('UPSOURCENAME','",name,"')")
dbGetQuery(db, sqlMeta1)
  
dbGetQuery(db, "DELETE FROM metadata where name ='UPSOURCEURL' ")   
sqlMeta2 <- paste0("INSERT INTO metadata (name,value) VALUES ('UPSOURCEURL','",url,"')")
dbGetQuery(db, sqlMeta2)
  
dbGetQuery(db, "DELETE FROM metadata where name ='UPSOURCEDATE' ")   
sqlMeta3 <- paste0("INSERT INTO metadata (name,value) VALUES ('UPSOURCEDATE','",date,"')")
dbGetQuery(db, sqlMeta3)
dbGetQuery(db,"DELETE FROM metadata WHERE name LIKE 'IPISOURCE%'")

  
## And don't forget the map_counts for PROSITE AND PFAM
dbGetQuery(db, "DELETE FROM map_counts where map_name ='PFAM' ")   
sqlmapcnt1 <- "INSERT INTO map_counts
                 SELECT 'PFAM', count(DISTINCT _id)
                 FROM pfam;"
dbGetQuery(db, sqlmapcnt1)

dbGetQuery(db, "DELETE FROM map_counts where map_name ='SMART' ")   
sqlmapcnt1 <- "INSERT INTO map_counts
                 SELECT 'SMART', count(DISTINCT _id)
                 FROM smart;"
dbGetQuery(db, sqlmapcnt1)


## ALSO: modify the map_metadata (1st drop the PFAM and prosite entries
dbGetQuery(db, "DELETE FROM map_metadata where map_name ='PFAM' ") 
## then put our own entries in...
sqlPFMM <- paste0( "INSERT INTO map_metadata (map_name, source_name, ",
                  "source_url, source_date) VALUES ('PFAM','",name,
                  "','",url,"','",date,"')")
dbGetQuery(db, sqlPFMM)

dbGetQuery(db, "DELETE FROM map_metadata where map_name ='SMART' ") 
## then put our own entries in...
sqlPFMM <- paste0( "INSERT INTO map_metadata (map_name, source_name, ",
                  "source_url, source_date) VALUES ('SMART','",name,
                  "','",url,"','",date,"')")
dbGetQuery(db, sqlPFMM)


