### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: vignette.Rnw:97-98
###################################################
library(TRONCO)


###################################################
### code chunk number 2: vignette.Rnw:112-114
###################################################
types.add("gain", "cornflowerblue")
types.add("loss", "brown1")


###################################################
### code chunk number 3: vignette.Rnw:141-142
###################################################
 events.load("events.txt")


###################################################
### code chunk number 4: vignette.Rnw:155-157
###################################################
data(ov.cgh)
data.load(ov.cgh)


###################################################
### code chunk number 5: vignette.Rnw:158-159
###################################################
str(data.values)


###################################################
### code chunk number 6: vignette.Rnw:185-186
###################################################
topology <- tronco.caprese(data.values, lambda=0.5)


###################################################
### code chunk number 7: vignette.Rnw:201-204
###################################################
topology
tronco.plot(topology, title="Ovarian cancer progression with CAPRESE", legend.title="CGH events", 
	legend.coeff = 1.0, label.coeff = 1.2, legend = TRUE)


###################################################
### code chunk number 8: vignette.Rnw:243-244
###################################################
 confidence.data.single(topology)


###################################################
### code chunk number 9: vignette.Rnw:246-247
###################################################
 confidence.data.joint(topology)


###################################################
### code chunk number 10: vignette.Rnw:249-250
###################################################
 confidence.data.conditional(topology)


###################################################
### code chunk number 11: vignette.Rnw:261-262
###################################################
confidence.single(topology)


###################################################
### code chunk number 12: vignette.Rnw:264-265
###################################################
confidence.joint(topology)


###################################################
### code chunk number 13: vignette.Rnw:267-268
###################################################
confidence.conditional(topology)


###################################################
### code chunk number 14: vignette.Rnw:283-285
###################################################
set.seed(12345)
topology <- tronco.bootstrap(topology, type="non-parametric", nboot=1000)


###################################################
### code chunk number 15: vignette.Rnw:287-288
###################################################
tronco.bootstrap.show(topology)


###################################################
### code chunk number 16: vignette.Rnw:298-300
###################################################
set.seed(12345)
topology <- tronco.bootstrap(topology, type="parametric", nboot=1000)


###################################################
### code chunk number 17: vignette.Rnw:302-303
###################################################
tronco.bootstrap.show(topology)


###################################################
### code chunk number 18: vignette.Rnw:315-317
###################################################
tronco.plot(topology, title="Ovarian cancer progression with CAPRESE", legend.title="CGH events", 
	legend.coeff = 1.0, label.coeff = 1.2, legend = TRUE, confidence = TRUE)


