/*
 * Decompiled with CFR 0.152.
 */
package org.renci.sequencing.util;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.renci.sequencing.util.SortedBaseHolderUnpacker;

public class BAMUnpacker
extends CommandLineProgram {
    @Option(shortName="I", doc="The input BAM file to process")
    public File INPUT;
    @Option(shortName="O", doc="A file to which to write the BAM table")
    public File OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only")
    public boolean ALIGNED_READS_ONLY = true;
    @Option(shortName="PF", doc="If set to true calculate mean quality over PF reads only")
    public boolean PF_READS_ONLY = true;
    @Option(doc="If set to true, include quality for no-call bases in the distribution")
    public boolean INCLUDE_NO_CALLS = true;
    @Option(doc="Stop after processing N reads. Mostly for debugging purposes.")
    public int STOP_AFTER = 0;
    @Option(doc="Region to unpack of the form 1:1-2500000 'chromosome:startpos-endpos'", optional=true)
    public String REGION = null;
    @Option(doc="If set to true, display available chromome sequence names and sequence lengths for the input BAM file.", mutex={"OUTPUT", "COEFF", "FLAGGED"})
    public boolean TARGETS = false;
    private boolean bHasRegion;
    private int iStartPos;
    private int iEndPos;
    private String sChromosome;

    public BAMUnpacker() {
        this.QUIET = true;
    }

    public static void main(String[] args) {
        try {
            if (BAMUnpacker.runIt(args) != 0) {
                throw new Exception("Exiting with an error, a non-zero exit status");
            }
        }
        catch (RuntimeException rte) {
            BAMUnpacker.doRuntimeExceptionCIGARErrorAndExit(rte);
            rte.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Caught an exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static int runIt(String[] args) {
        int iReturn = new BAMUnpacker().instanceMain(args);
        if (iReturn == 0) {
            System.out.println("[" + new Date() + "] " + "org.renci.sequencing.util.BAMUnpacker done");
            System.out.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
        }
        return iReturn;
    }

    public static void doRuntimeExceptionCIGARErrorAndExit(Exception tException) {
        if (tException.getMessage().contains("CIGAR") && tException.getMessage().contains("SAM validation error")) {
            System.err.println("CIGAR should have zero elements for unmapped string.  Maybe aligned using BWA?  Exiting recalibration.");
            tException.printStackTrace();
        } else {
            System.err.println("Caught a RuntimeException: " + tException.getMessage());
            tException.printStackTrace();
        }
    }

    @Override
    protected int doWork() {
        try {
            SAMFileReader tSAMFileReaderIn = new SAMFileReader(this.INPUT);
            if (this.TARGETS && this.INPUT != null) {
                this.handleTargets(tSAMFileReaderIn);
            } else {
                IoUtil.assertFileIsReadable(this.INPUT);
                IoUtil.assertFileIsWritable(this.OUTPUT);
            }
            if (!tSAMFileReaderIn.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
                System.out.println("WARNING: This BAM's header does not say it is sorted (perhaps it was sorted by samtools?");
            }
            if (this.REGION != null) {
                this.handleRegionParameters();
            }
            SortedBaseHolderUnpacker sbh = new SortedBaseHolderUnpacker(this.OUTPUT);
            tSAMFileReaderIn.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            if (this.bHasRegion) {
                if (tSAMFileReaderIn == null || sbh == null) {
                    System.out.println("SAMFileReader is null or SortedBaseHolderUnpacker is null.");
                }
                this.processRegionQuery(tSAMFileReaderIn, sbh);
            } else {
                int processed = 0;
                for (SAMRecord rec : tSAMFileReaderIn) {
                    if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag() || this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) continue;
                    sbh.addRead(rec);
                    if (this.STOP_AFTER > 0 && ++processed > this.STOP_AFTER) break;
                }
                sbh.flushAll();
            }
        }
        catch (IOException e) {
            System.out.println("I/O Error.  Underlying cause:\n " + e);
            e.printStackTrace();
            return 1;
        }
        catch (RuntimeException rte) {
            BAMUnpacker.doRuntimeExceptionCIGARErrorAndExit(rte);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    private void handleRegionParameters() throws Exception {
        String[] sRegionArray = this.REGION.split(":");
        if (sRegionArray.length != 2) {
            System.out.println("REGION parameter is not of the form 1:1-2500000 where '1' is the chromosome, '1-2500000' is the start and end position.");
            throw new Exception("REGION parameter is not of the form 1:1-2500000 where '1' is the chromosome, '1-2500000' is the start and end position.");
        }
        this.sChromosome = sRegionArray[0];
        String[] sPositionArray = sRegionArray[1].split("-");
        if (sPositionArray.length != 2) {
            System.out.println("REGION parameter does not include a start and end position.");
            throw new Exception("Region parameter does not include a start and end position.");
        }
        this.iStartPos = Integer.parseInt(sPositionArray[0]);
        this.iEndPos = Integer.parseInt(sPositionArray[1]);
        this.bHasRegion = true;
    }

    private void processRegionQuery(SAMFileReader tSAMFileReaderIn, SortedBaseHolderUnpacker sbh) {
        try {
            int processed = 0;
            SAMRecordIterator tSRIter = tSAMFileReaderIn.query(this.sChromosome, this.iStartPos, this.iEndPos, false);
            while (tSRIter.hasNext()) {
                ++processed;
                SAMRecord tRecord = (SAMRecord)tSRIter.next();
                if (this.PF_READS_ONLY && tRecord.getReadFailsVendorQualityCheckFlag() || this.ALIGNED_READS_ONLY && tRecord.getReadUnmappedFlag()) continue;
                sbh.addRead(tRecord);
                if (this.STOP_AFTER > 0 && ++processed > this.STOP_AFTER) break;
            }
            tSRIter.close();
            sbh.flushAll();
            tSAMFileReaderIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleTargets(SAMFileReader tSAMFileReaderIn) {
        SAMFileHeader tHeader = tSAMFileReaderIn.getFileHeader();
        SAMSequenceDictionary tDict = tHeader.getSequenceDictionary();
        List<SAMSequenceRecord> tSRecordList = tDict.getSequences();
        Iterator<SAMSequenceRecord> tIter3 = tSRecordList.iterator();
        System.out.println("Sequence Name:\t Sequence Length");
        while (tIter3.hasNext()) {
            SAMSequenceRecord tSSRecord = tIter3.next();
            System.out.println(String.valueOf(tSSRecord.getSequenceName()) + ":\t " + tSSRecord.getSequenceLength());
        }
    }
}

