### R code from vignette source 'RMassBankNonstandard.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: RMassBankNonstandard.Rnw:24-26
###################################################
options(width=74)
#library(xtable)


###################################################
### code chunk number 2: RMassBankNonstandard.Rnw:41-44
###################################################
library("RMassBank")
library("RMassBankData")
library("gplots")


###################################################
### code chunk number 3: RMassBankNonstandard.Rnw:50-51 (eval = FALSE)
###################################################
## vignette("RMassBank")


###################################################
### code chunk number 4: RMassBankNonstandard.Rnw:71-78
###################################################
RmbDefaultSettings()
rmbo <- getOption("RMassBank")
rmbo$recalibrator <- list(
		"MS1" = "recalibrate.identity",
		"MS2" = "recalibrate.identity"
	)
options("RMassBank" = rmbo)


###################################################
### code chunk number 5: RMassBankNonstandard.Rnw:84-86
###################################################
w <- loadMsmsWorkspace(system.file("results/pH_narcotics_RF.RData", 
				package="RMassBankData"))


###################################################
### code chunk number 6: RMassBankNonstandard.Rnw:90-91
###################################################
plotRecalibration(w)


###################################################
### code chunk number 7: RMassBankNonstandard.Rnw:95-97
###################################################
w@recalibratedSpecs[[1]]$parentPeak[30:32,]
w@recalibratedSpecs[[1]]$peaks[[1]][15:17,]


###################################################
### code chunk number 8: RMassBankNonstandard.Rnw:103-104
###################################################
w <- msmsWorkflow(w, steps=4)


###################################################
### code chunk number 9: RMassBankNonstandard.Rnw:110-112
###################################################
w@recalibratedSpecs[[1]]$parentPeak[30:32,]
w@recalibratedSpecs[[1]]$peaks[[1]][15:17,]


###################################################
### code chunk number 10: RMassBankNonstandard.Rnw:130-150
###################################################
RmbDefaultSettings()
getOption("RMassBank")$multiplicityFilter

# to make processing faster, we only use 3 spectra per compound
rmbo <- getOption("RMassBank")
rmbo$spectraList <- list(
    list(mode="CID", ces = "35%", ce = "35 % (nominal)", res = 7500),
    list(mode="HCD", ces = "15%", ce = "15 % (nominal)", res = 7500),
    list(mode="HCD", ces = "30%", ce = "30 % (nominal)", res = 7500)
)
options(RMassBank = rmbo)

loadList(system.file("list/NarcoticsDataset.csv", 
        package="RMassBankData"))


w <- newMsmsWorkspace()
files <- list.files(system.file("spectra", package="RMassBankData"),
        ".mzML", full.names = TRUE)
w@files <- files[1:2]


###################################################
### code chunk number 11: RMassBankNonstandard.Rnw:153-163
###################################################
w1 <- msmsWorkflow(w, mode="pH", steps=c(1))
# Here we artificially cut spectra out to make the workflow run faster for the vignette:
w1@specs <- lapply(w1@specs, function(s)
    {
      s$childScans <- s$childScans[1:3]
      s$childHeaders <- s$childHeaders[1:3,]
      s$peaks <- s$peaks[1:3]
      s
    })
w1 <- msmsWorkflow(w1, mode="pH", steps=c(2:7))


###################################################
### code chunk number 12: RMassBankNonstandard.Rnw:169-179
###################################################
w2 <- msmsWorkflow(w, mode="pH", steps=c(1), confirmMode = 1)
# Here we artificially cut spectra out to make the workflow run faster for the vignette:
w2@specs <- lapply(w2@specs, function(s)
    {
      s$childScans <- s$childScans[1:3]
      s$childHeaders <- s$childHeaders[1:3,]
      s$peaks <- s$peaks[1:3]
      s
    })
w2 <- msmsWorkflow(w2, mode="pH", steps=c(2:7))


###################################################
### code chunk number 13: RMassBankNonstandard.Rnw:185-187
###################################################
wTotal <- combineMultiplicities(c(w1, w2))
wTotal <- msmsWorkflow(wTotal, steps=8, mode="pH", archivename = "output")


###################################################
### code chunk number 14: RMassBankNonstandard.Rnw:192-194
###################################################
mb <- newMbWorkspace(wTotal)
# [...] load lists, execute workflow etc.


###################################################
### code chunk number 15: RMassBankNonstandard.Rnw:201-202
###################################################
sessionInfo()


