require("Homo.sapiens")
x <- Homo.sapiens

################################################################################
## VERY simple minded tests for VERY simple wrapper funs
## Basically are they returning something?  If so then they are proabbly OK.
.testPopulatedGranges <- function(res){
    all(checkTrue(length(res) > 1),
        checkTrue(class(res) == "GRanges"))
}

test_microRNAs <- function(){
    res <- microRNAs(x)
    .testPopulatedGranges(res)
}

test_tRNAs <- function(){
    res <- tRNAs(x)
    .testPopulatedGranges(res)
}

test_promoters <- function(){
    res <- promoters(x)
    .testPopulatedGranges(res)
}

test_threeUTRsByTranscript <- function(){
    res <- threeUTRsByTranscript(x)
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "GRangesList")    
}


test_asBED <- function(){
    res <- asBED(x)
    .testPopulatedGranges(res)
}

test_asGFF <- function(){
    res <- asGFF(x)
    .testPopulatedGranges(res)
}

test_disjointExons <- function(){
    res <- disjointExons(x)
    .testPopulatedGranges(res)
}

test_distance <- function(){
    gr <- GRanges(c("chr19", "chr20"),
                  IRanges(c(60000000, 40000000),  width=200))
    res <- distance(gr, x,id=c('1','100'),type="gene")
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "integer")
}


## This adds new suggests
require(BSgenome.Hsapiens.UCSC.hg19)
genome <- BSgenome.Hsapiens.UCSC.hg19

test_extractTranscriptSeqs <- function(){
    res <- extractTranscriptSeqs(genome, x)
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "DNAStringSet")
}

test_extractUpstreamSeqs <- function(){
    res <- extractUpstreamSeqs(genome, x)
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "DNAStringSet")
}

test_intronsByTranscript <- function(){
    res <- intronsByTranscript(x)
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "GRangesList")    
}

test_fiveUTRsByTranscript <- function(){
    res <- fiveUTRsByTranscript(x)
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "GRangesList")    
}

test_isActiveSeq <- function(){
    ## getter works
    res <- isActiveSeq(x) 
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "logical")
    checkTrue(all(res) == "TRUE")
    ## and check setter works
    isActiveSeq(x)[seqlevels(x)] <- FALSE
    res <- isActiveSeq(x) 
    checkTrue(length(res) > 1)
    checkTrue(class(res) == "logical")
    checkTrue(all(res) == "FALSE")
    ## Because the tests run in some 'other' order, I need to set this
    ## back to default!
    isActiveSeq(x)[seqlevels(x)] <- TRUE
}

