## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ----, echo = FALSE------------------------------------------------------
apiKey <- Sys.getenv("GOOGLE_API_KEY")
if (nchar(apiKey) == 0) {
  warning(paste("To build this vignette, please setup the environment variable",
                "GOOGLE_API_KEY with the public API key from your Google",
                "Developer Console before loading the GoogleGenomics package,",
                "or run GoogleGenomics::authenticate."))
  knitr::knit_exit()
}

## ------------------------------------------------------------------------
# Authenticated on package load from the env variable GOOGLE_API_KEY.
suppressPackageStartupMessages(library(GoogleGenomics))

reads <- getReads(readGroupSetId="CMvnhpKTFhDyy__v0qfPpkw",
                  chromosome="chr13",
                  start=33628130,
                  end=33628145)
alignments <- readsToGAlignments(reads)

## ----coverage------------------------------------------------------------
suppressPackageStartupMessages(library(ggplot2))
suppressPackageStartupMessages(library(ggbio))
alignmentPlot <- autoplot(alignments, aes(color=strand, fill=strand))
coveragePlot <- ggplot(as(alignments, "GRanges")) +
                stat_coverage(color="gray40", fill="skyblue")
tracks(alignmentPlot, coveragePlot,
       xlab="Reads overlapping rs9536314 for NA12893")

## ----ideogram------------------------------------------------------------
ideogramPlot <- plotIdeogram(genome="hg19", subchr="chr13")
ideogramPlot + xlim(as(alignments, "GRanges"))

## ------------------------------------------------------------------------
sessionInfo()

