### R code from vignette source 'GenoView.Rnw'

###################################################
### code chunk number 1: GenoView.Rnw:26-27
###################################################
require(GenoView)


###################################################
### code chunk number 2: GenoView.Rnw:32-36
###################################################
# Load relevant packages containing hg19 datasets
require(TxDb.Hsapiens.UCSC.hg19.knownGene)
require(biovizBase)
require(grid)


###################################################
### code chunk number 3: GenoView.Rnw:42-46
###################################################
# Extract the relevant data from published genomic datasets
tx.db <- TxDb.Hsapiens.UCSC.hg19.knownGene
seqs <- seqlengths(tx.db)
data(genesymbol, package = "biovizBase")


###################################################
### code chunk number 4: GenoView.Rnw:57-63
###################################################
# Select the location of TP53
exon.int <- genesymbol["TP53"]
# An example of a truncated plotting interval from 7575000 bp to 7579000 bp
plot.int <- intSel(exon.int, new.start = 7575000, 
                   new.end = 7579000)
gr <- biovizBase::crunch(tx.db, which=exon.int, type = "all")


###################################################
### code chunk number 5: GenoView.Rnw:68-70
###################################################
data(sample.mut.df, package = 'GenoView')
head(sample.mut.df)


###################################################
### code chunk number 6: GenoView.Rnw:73-79
###################################################
# Using exon.int range (TP53)
sample.mut.gr <- makeGR(sample.mut.df, chr.col = "seqnames", 
                        s.p.col = "start", e.p.col = "end", 
                        str.col = "strand", id.col = "ids", 
                        show.legend = TRUE, des.seqs = seqs, 
                        plot.int = exon.int) 


###################################################
### code chunk number 7: GenoView.Rnw:82-88
###################################################
# Using plot.int range (truncated region of TP53)
sample.mut.trunc <- makeGR(sample.mut.df, chr.col = "seqnames", 
                        s.p.col = "start", e.p.col = "end", 
                        str.col = "strand", id.col = "ids", 
                        show.legend = TRUE, des.seqs = seqs, 
                        plot.int = plot.int) # uses plot.int


###################################################
### code chunk number 8: ml1lab
###################################################
ml1 = mutExonPlot(mut.gr = sample.mut.gr, exon.int = exon.int, 
                 plot.int = exon.int, disp.track = 1, p.height = 4/8, 
                 d.height = 0, l.height = 4/8, plt.title = "mutExonPlot1", 
                 id.col = "IDs", tx.db = tx.db, gr = gr)


###################################################
### code chunk number 9: mep1
###################################################
grid.draw(ml1$mep)


###################################################
### code chunk number 10: fig1
###################################################
grid.draw(ml1$mep)


###################################################
### code chunk number 11: GenoView.Rnw:119-123
###################################################
# Create PFAM objects using the wrapper function makePFAMObjs
pfam.objs <- makePFAMObjs()
pfam.desc <- pfam.objs$desc
pfam.ids <- pfam.objs$ids


###################################################
### code chunk number 12: GenoView.Rnw:127-137
###################################################
# Load the pfam data.frame
data(pfam.df, package = "GenoView", envir = environment())

# Create the GRanges object using the pfam.df dataset
pfam.gr <- GRanges(seqnames = as.character(pfam.df[,"chr"]), 
                       IRanges(start = pfam.df[,"start"], 
                               end = pfam.df[,"end"]), 
                       strand = pfam.df[,"strand"])
# Assign the column of domain information as values for pfam.gr
values(pfam.gr) <- list(domain = as.character(as.matrix(pfam.df[,1])))


###################################################
### code chunk number 13: GenoView.Rnw:140-145
###################################################
ml2 = mutExonPlot(mut.gr = sample.mut.trunc, exon.int = exon.int, 
                  plot.int = plot.int, p.height = 2/4, d.height = 1/4, 
                  l.height = 1/4, plt.title = "mutExonPlot3", 
                  id.col = "IDs", tx.db = tx.db, pfam.gr = pfam.gr, 
                  pfam.desc = pfam.desc, pfam.ids = pfam.ids, gr = gr)


###################################################
### code chunk number 14: mep2
###################################################
grid.draw(ml2$mep)


###################################################
### code chunk number 15: fig3
###################################################
grid.draw(ml2$mep)


###################################################
### code chunk number 16: GenoView.Rnw:170-173
###################################################
if(interactive()) {
    mepHuman(m.data = sample.mut.df, gui = TRUE)
}


###################################################
### code chunk number 17: GenoView.Rnw:179-182
###################################################
if(interactive()) {
    mepHuman(m.data = sample.mut.df, gui = FALSE)
}


