/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionError;
import org.cytoscape.equations.FunctionUtil;

public class Var
extends AbstractFunction {
    public Var() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "Two or more floating point numbers.")});
    }

    public String getName() {
        return "VAR";
    }

    public String getFunctionSummary() {
        return "Returns the sample variance of a list(s) of numbers.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws FunctionError {
        double[] numbers = FunctionUtil.getDoubles(args);
        if (numbers.length < 2) {
            throw new IllegalArgumentException("illegal list argument in call to VAR(): must have at least 2 numbers!");
        }
        return FunctionUtil.calcSampleVariance(numbers);
    }
}

