/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.util.ColorUtil;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;

public class NodeLabelColorProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_LABEL_COLOR;
    }

    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.setColor((Color)value);
                Font font = (Font)VisualPropertyType.NODE_FONT_FACE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
                this.g2d.setFont(new Font(font.getFontName(), font.getStyle(), 28));
                this.g2d.drawString("Label", 8, c.getHeight() / 2 + 10);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o, VisualPropertyDependency dep) {
        Label nodelabel;
        if (o == null || nv == null || !(o instanceof Color)) {
            return;
        }
        Color color = (Color)o;
        boolean sync = false;
        if (dep != null && dep.check(VisualPropertyDependency.Definition.NODE_LABLE_COLOR_FROM_NODE_COLOR)) {
            color = ColorUtil.getComplementaryColor((Color)nv.getUnselectedPaint());
        }
        if (!color.equals((nodelabel = nv.getLabel()).getTextPaint())) {
            nodelabel.setTextPaint(color);
        }
    }

    public Object getDefaultAppearanceObject() {
        return Color.black;
    }
}

