/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import cytoscape.visual.mappings.discrete.DiscreteMappingReader;
import cytoscape.visual.parsers.ColorParser;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.SortedMap;
import junit.framework.TestCase;

public class DiscreteMappingReaderTest
extends TestCase {
    public void testReader() throws Exception {
        InputStream in = DiscreteMappingReaderTest.getDataFile();
        Properties properties = new Properties();
        properties.load(in);
        ColorParser parser = new ColorParser();
        DiscreteMappingReader reader = new DiscreteMappingReader(properties, "nodeColorCalculator.JUnitDiscreteColor.mapping", parser);
        String attribute = reader.getControllingAttributeName();
        DiscreteMappingReaderTest.assertEquals("canonicalName", attribute);
        SortedMap map = reader.getMap();
        Color color = (Color)map.get("A");
        DiscreteMappingReaderTest.assertEquals(new Color(204, 255, 255), color);
        color = (Color)map.get("Y");
        DiscreteMappingReaderTest.assertEquals(new Color(255, 51, 51), color);
    }

    static InputStream getDataFile() {
        String file = new String("nodeColorCalculator.JUnitDiscreteColor.class=cytoscape.visual.calculators.GenericNodeColorCalculator\nnodeColorCalculator.JUnitDiscreteColor.mapping.controller=canonicalName\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.A=204,255,255\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.B=51,255,51\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.C=204,204,255\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.D=255,255,255\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.X=102,51,0\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.Y=255,51,51\nnodeColorCalculator.JUnitDiscreteColor.mapping.type=DiscreteMapping\n");
        ByteArrayInputStream in = new ByteArrayInputStream(file.getBytes());
        return in;
    }

    static InputStream getControllerTypeDataFile() {
        String file = new String("nodeColorCalculator.JUnitDiscreteColor.class=cytoscape.visual.calculators.GenericNodeColorCalculator\nnodeColorCalculator.JUnitDiscreteColor.mapping.controller=homer\nnodeColorCalculator.JUnitDiscreteColor.mapping.controllerType=3\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.1=204,255,255\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.2=51,255,51\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.3=204,204,255\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.4=255,255,255\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.5=102,51,0\nnodeColorCalculator.JUnitDiscreteColor.mapping.map.6=255,51,51\nnodeColorCalculator.JUnitDiscreteColor.mapping.type=DiscreteMapping\n");
        ByteArrayInputStream in = new ByteArrayInputStream(file.getBytes());
        return in;
    }

    public void testControllerType() throws Exception {
        InputStream in = DiscreteMappingReaderTest.getControllerTypeDataFile();
        Properties properties = new Properties();
        properties.load(in);
        ColorParser parser = new ColorParser();
        DiscreteMappingReader reader = new DiscreteMappingReader(properties, "nodeColorCalculator.JUnitDiscreteColor.mapping", parser);
        String attribute = reader.getControllingAttributeName();
        DiscreteMappingReaderTest.assertEquals("controlling attr name", "homer", attribute);
        SortedMap map = reader.getMap();
        Color color = (Color)map.get(new Integer(1));
        DiscreteMappingReaderTest.assertEquals(new Color(204, 255, 255), color);
        color = (Color)map.get(new Integer(3));
        DiscreteMappingReaderTest.assertEquals(new Color(204, 204, 255), color);
        color = (Color)map.get(new Integer(6));
        DiscreteMappingReaderTest.assertEquals(new Color(255, 51, 51), color);
    }
}

