/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.impl.bitmap;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.render.stateful.CustomGraphic;
import cytoscape.visual.customgraphic.ImageUtil;
import cytoscape.visual.customgraphic.impl.AbstractDCustomGraphics;
import cytoscape.visual.customgraphic.impl.DLayer;
import cytoscape.visual.customgraphic.paint.TexturePaintFactory;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;

public class URLImageCustomGraphics
extends AbstractDCustomGraphics {
    private static BufferedImage DEF_IMAGE;
    private static final String DEF_TAG = "bitmap image";
    private CustomGraphic cg;
    private BufferedImage originalImage;
    private BufferedImage scaledImage;
    private URL sourceUrl;

    public URLImageCustomGraphics(String url) throws IOException {
        super(url);
        this.tags.add(DEF_TAG);
        this.createImage(url);
        this.buildCustomGraphics(this.originalImage);
    }

    public URLImageCustomGraphics(Long id, String url) throws IOException {
        super(id, url);
        this.tags.add(DEF_TAG);
        this.createImage(url);
        this.buildCustomGraphics(this.originalImage);
    }

    public URLImageCustomGraphics(String name, BufferedImage img) {
        super(name);
        if (img == null) {
            throw new IllegalArgumentException("Image cannot be null.");
        }
        this.tags.add(DEF_TAG);
        this.originalImage = img;
        this.buildCustomGraphics(this.originalImage);
    }

    private void buildCustomGraphics(BufferedImage targetImg) {
        this.layers.clear();
        Rectangle2D.Double bound = null;
        this.width = targetImg.getWidth();
        this.height = targetImg.getHeight();
        bound = new Rectangle2D.Double(-this.width / 2, -this.height / 2, this.width, this.height);
        TexturePaintFactory paintFactory = new TexturePaintFactory(targetImg);
        this.cg = new CustomGraphic(bound, paintFactory);
        DLayer layer = new DLayer(this.cg, 1);
        this.layers.add(layer);
    }

    private void createImage(String url) throws MalformedURLException {
        URL imageLocation;
        if (url == null) {
            throw new IllegalStateException("URL string cannot be null.");
        }
        this.sourceUrl = imageLocation = new URL(url);
        try {
            this.originalImage = ImageIO.read(imageLocation);
        }
        catch (IOException e) {
            this.originalImage = DEF_IMAGE;
            CyLogger.getLogger().warn("Broken Image found.  Default is used instead.");
        }
        if (this.originalImage == null) {
            this.originalImage = DEF_IMAGE;
        }
    }

    public Image getRenderedImage() {
        if (this.width == this.originalImage.getWidth() && this.height == this.originalImage.getHeight()) {
            return this.originalImage;
        }
        if (this.scaledImage == null) {
            this.resizeImage(this.width, this.height);
        } else if (this.scaledImage.getWidth() != this.width || this.scaledImage.getHeight() != this.height) {
            this.resizeImage(this.width, this.height);
        }
        return this.scaledImage;
    }

    private Image resizeImage(int width, int height) {
        Image img = this.originalImage.getScaledInstance(width, height, 16);
        try {
            this.scaledImage = ImageUtil.toBufferedImage(img);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return this.originalImage;
        }
        this.buildCustomGraphics(this.scaledImage);
        return this.scaledImage;
    }

    public Image resetImage() {
        if (this.scaledImage != null) {
            this.scaledImage.flush();
            this.scaledImage = null;
        }
        this.buildCustomGraphics(this.originalImage);
        return this.originalImage;
    }

    public URL getSourceURL() {
        return this.sourceUrl;
    }

    static {
        try {
            DEF_IMAGE = ImageIO.read(Cytoscape.class.getResource("images/ximian/stock_dialog-warning-32.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

